/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.structurelike;

import divinerpg.registries.StructureRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class Beam
extends Feature<NoneFeatureConfiguration> {
    public static StructureTemplate base;
    public static StructureTemplate middle;
    public static StructureTemplate top;

    public Beam() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        return this.place((NoneFeatureConfiguration)null, context.level(), (ChunkGenerator)null, context.random(), context.origin());
    }

    public boolean place(NoneFeatureConfiguration c, WorldGenLevel level, ChunkGenerator gen, RandomSource random, BlockPos pos) {
        if (base == null) {
            StructureTemplateManager manager = level.getLevel().getServer().getStructureManager();
            base = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"vethea/all_biomes/beam_base"));
            middle = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"vethea/all_biomes/beam_middle"));
            top = manager.getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"divinerpg", (String)"vethea/all_biomes/beam_top"));
        }
        BlockPos.MutableBlockPos p = pos.mutable();
        StructureRegistry.placeStructure(base, level, random, (BlockPos)p);
        p.move(0, 5, 0);
        do {
            StructureRegistry.placeStructure(middle, level, random, (BlockPos)p);
        } while (!level.isOutsideBuildHeight((BlockPos)p.move(0, 4, 0)) && level.getBlockState((BlockPos)p).isAir());
        p.move(0, -4, 0);
        StructureRegistry.placeStructure(top, level, random, (BlockPos)p);
        return true;
    }
}

