/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.ShiverspineTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;

public class DeadShiverspine
extends ShiverspineTree {
    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        int treeType;
        boolean wide;
        int treeHeight;
        if (this.canBeHere(level, random, pos, config) && this.heightCheck(level, pos, treeHeight = (wide = (treeType = random.nextInt(8)) == 0) ? 6 + random.nextInt(6) : 3 + random.nextInt(5), wide ? 2 : 1)) {
            BlockState log = config.log;
            BlockState xlog = (BlockState)log.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
            BlockState zlog = (BlockState)log.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
            BlockPos.MutableBlockPos p = pos.mutable().move(0, 1, 0);
            if (wide) {
                this.wideGrow(level, pos, log, treeHeight, 0, 0, true);
            } else {
                this.grow(level, pos, log, treeHeight, true);
            }
            int shift = random.nextBoolean() ? 2 : 0;
            for (int i = 0; i < treeHeight - 1; ++i) {
                if ((i + shift) % 4 == 0) {
                    if (wide) {
                        this.angledWideGrow(level, (BlockPos)p, xlog, zlog, 1, 0);
                    } else {
                        this.setBlock(level, p.offset(1, 0, 0), xlog, true);
                        this.setBlock(level, p.offset(-1, 0, 0), xlog, true);
                    }
                } else if ((i + shift) % 4 == 2) {
                    if (wide) {
                        this.angledWideGrow(level, (BlockPos)p, xlog, zlog, 1, 1);
                    } else {
                        this.setBlock(level, p.offset(0, 0, 1), zlog, true);
                        this.setBlock(level, p.offset(0, 0, -1), zlog, true);
                    }
                }
                p.move(0, 1, 0);
            }
            return true;
        }
        return false;
    }

    protected void angledWideGrow(WorldGenLevel world, BlockPos pos, BlockState xlog, BlockState zlog, int width, int offset) {
        this.setBlock(world, pos.offset(width + 1, 0, offset), xlog, true);
        this.setBlock(world, pos.offset(-width, 0, 1 - offset), xlog, true);
        this.setBlock(world, pos.offset(offset, 0, -width), zlog, true);
        this.setBlock(world, pos.offset(1 - offset, 0, width + 1), zlog, true);
    }
}

