/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.SkythernTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class FirewoodTree
extends SkythernTree {
    protected Direction direction;

    protected void directionalWideGrow(WorldGenLevel world, BlockPos pos, BlockState state, int width, int offset) {
        if (this.direction == Direction.UP || this.direction == Direction.DOWN) {
            this.wideGrow(world, pos, state, width, offset);
        } else if (this.direction == Direction.NORTH || this.direction == Direction.SOUTH) {
            this.setBlock((LevelWriter)world, pos.offset(offset, width + 1, 0), state);
            this.setBlock((LevelWriter)world, pos.offset(1 - offset, -width, 0), state);
            this.setBlock((LevelWriter)world, pos.offset(-width, offset, 0), state);
            this.setBlock((LevelWriter)world, pos.offset(width + 1, 1 - offset, 0), state);
        } else {
            this.setBlock((LevelWriter)world, pos.offset(0, width + 1, offset), state);
            this.setBlock((LevelWriter)world, pos.offset(0, -width, 1 - offset), state);
            this.setBlock((LevelWriter)world, pos.offset(0, offset, -width), state);
            this.setBlock((LevelWriter)world, pos.offset(0, 1 - offset, width + 1), state);
        }
    }

    @Override
    public boolean canBeHere(WorldGenLevel level, RandomSource random, BlockPos pos, TreeConfig config) {
        BlockState state = level.getBlockState(pos);
        if (config.growableOn.isEmpty() && this.defaultGrowOn(state)) {
            return this.searchForSpace(level, random, pos);
        }
        for (RuleTest test : config.growableOn) {
            if (!test.test(state, random)) continue;
            return this.searchForSpace(level, random, pos);
        }
        return false;
    }

    protected boolean searchForSpace(WorldGenLevel level, RandomSource random, BlockPos pos) {
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction dir;
            this.direction = dir = directionArray[i];
            if (!level.getBlockState(pos.relative(this.direction)).isAir()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is((Block)BlockRegistry.dreamStone.get()) || state.is(BlockTags.DIRT);
    }

    protected void placeBigTree(TreeConfig config, WorldGenLevel level, RandomSource random, BlockPos pos) {
        int treeHeight;
        this.wideGrow(level, pos, config.log, treeHeight, 0, 0);
        pos = pos.offset(0, treeHeight, 0);
        this.wideGrow(level, pos, config.leaves, 2, 0, 0);
        this.wideGrow(level, pos, config.leaves, 1, 1, 0);
        this.wideGrow(level, pos, config.leaves, 1, 1, 1);
        this.wideGrow(level, pos, config.leaves, 1, 1, 2);
        this.wideGrow(level, pos, config.leaves, 2, -1);
        this.wideGrow(level, pos, config.leaves, 2, 0);
        this.wideGrow(level, pos, config.leaves, 2, 1);
        this.wideGrow(level, pos, config.leaves, 2, 2);
        this.wideGrow(level, pos, config.leaves, 2, 3);
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (treeHeight = 5 + random.nextInt(8); random.nextBoolean() && treeHeight > 0; --treeHeight) {
            mutable.move(Direction.DOWN);
            if (random.nextBoolean()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, -1);
            }
            if (random.nextBoolean()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 0);
            }
            if (random.nextBoolean()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 1);
            }
            if (random.nextBoolean()) {
                this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 2);
            }
            if (!random.nextBoolean()) continue;
            this.wideGrow(level, (BlockPos)mutable, config.leaves, 2, 3);
        }
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            if (this.direction == Direction.UP && random.nextInt(8) == 0) {
                this.placeBigTree(config, level, random, pos);
            } else if (random.nextInt(3) == 0) {
                for (int size = 0; size < 3 + random.nextInt(5); ++size) {
                    pos = pos.relative(this.direction);
                    this.directionalWideGrow(level, pos, config.log, 0, 0);
                    if (!(random.nextFloat() < 0.2f)) continue;
                    this.direction = Direction.getRandom((RandomSource)random);
                }
                this.directionalWideGrow(level, pos, config.leaves, 1, 0);
                this.directionalWideGrow(level, pos, config.leaves, 1, 1);
                pos = pos.relative(this.direction);
                this.directionalWideGrow(level, pos, config.leaves, 0, 0);
                this.setBlock(level, pos.relative(Direction.getRandom((RandomSource)random)), config.leaves, false);
                this.setBlock(level, pos.relative(this.direction), config.leaves, false);
            } else {
                for (int size = 0; size < 3 + random.nextInt(9); ++size) {
                    pos = pos.relative(this.direction);
                    this.setBlock(level, pos, config.log, true);
                    if (!(random.nextFloat() < 0.3f)) continue;
                    this.direction = Direction.getRandom((RandomSource)random);
                }
                this.setBlock(level, pos.above(), config.leaves, false);
                this.setBlock(level, pos.north(), config.leaves, false);
                this.setBlock(level, pos.east(), config.leaves, false);
                this.setBlock(level, pos.south(), config.leaves, false);
                this.setBlock(level, pos.west(), config.leaves, false);
                this.setBlock(level, pos.below(), config.leaves, false);
            }
            return true;
        }
        return false;
    }
}

