/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.feature.tree;

import divinerpg.registries.BlockRegistry;
import divinerpg.world.feature.config.tree.TreeConfig;
import divinerpg.world.feature.tree.DivineTree;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;

public class FractalTree
extends DivineTree {
    protected Vec3 pos = null;
    protected Vec3 left = null;
    protected Vec3 right = null;
    protected Vec3 upright = null;
    protected Vec3 downright = null;
    protected Vec3 downleft = null;
    protected Vec3 upleft = null;
    protected Vec3 current = null;

    @Override
    protected boolean defaultGrowOn(BlockState state) {
        return state.is(BlockTags.SNOW) || state.is(BlockTags.ICE) || state.is((Block)BlockRegistry.frozenGrass.get()) || state.is((Block)BlockRegistry.frozenDirt.get());
    }

    @Override
    public boolean place(TreeConfig config, WorldGenLevel level, ChunkGenerator chunkGen, RandomSource random, BlockPos pos) {
        if (this.canBeHere(level, random, pos, config)) {
            boolean treeType;
            int treeHeight;
            if (level.getBlockState(pos.below()).is(BlockTags.SNOW)) {
                pos = pos.below();
            }
            if (this.heightCheck(level, pos, treeHeight = ((treeType = random.nextBoolean() ? true : random.nextBoolean()) ? 4 : 6) + random.nextInt(5), 1)) {
                BlockState packed_ice = config.log;
                this.grow(level, pos, packed_ice, treeHeight, true);
                BlockPos.MutableBlockPos position = pos.mutable();
                if (treeType) {
                    int shift = random.nextInt(2);
                    boolean rotation = random.nextBoolean();
                    boolean longBranches = random.nextBoolean();
                    for (int y = 0; y < treeHeight; ++y) {
                        if (y % 2 == shift) {
                            boolean turned = random.nextBoolean();
                            BlockState state = this.getState(config, turned);
                            if (rotation) {
                                this.setBlock(level, position.north(), state, false);
                                this.setBlock(level, position.south(), state, false);
                                if (!turned) {
                                    turned = random.nextBoolean();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.north(2).above(), state, false);
                                this.setBlock(level, position.south(2).above(), state, false);
                                if (!turned) {
                                    turned = random.nextBoolean();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.north(3).above(2), state, false);
                                this.setBlock(level, position.south(3).above(2), state, false);
                                if (longBranches) {
                                    if (!turned) {
                                        turned = random.nextBoolean();
                                        state = this.getState(config, turned);
                                    }
                                    this.setBlock(level, position.north(4).above(3), state, false);
                                    this.setBlock(level, position.south(4).above(3), state, false);
                                }
                            } else {
                                this.setBlock(level, position.east(), state, false);
                                this.setBlock(level, position.west(), state, false);
                                if (!turned) {
                                    turned = random.nextBoolean();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.east(2).above(), state, false);
                                this.setBlock(level, position.west(2).above(), state, false);
                                if (!turned) {
                                    turned = random.nextBoolean();
                                    state = this.getState(config, turned);
                                }
                                this.setBlock(level, position.east(3).above(2), state, false);
                                this.setBlock(level, position.west(3).above(2), state, false);
                                if (longBranches) {
                                    if (!turned) {
                                        turned = random.nextBoolean();
                                        state = this.getState(config, turned);
                                    }
                                    this.setBlock(level, position.east(4).above(3), state, false);
                                    this.setBlock(level, position.west(4).above(3), state, false);
                                }
                            }
                            rotation = !rotation;
                        }
                        position.move(0, 1, 0);
                    }
                } else if (random.nextBoolean()) {
                    int shift = random.nextInt(2);
                    boolean rotation = random.nextBoolean();
                    for (int y = 0; y < treeHeight; ++y) {
                        if (y % 2 == shift) {
                            BlockState state = this.getState(config, random.nextBoolean());
                            if (rotation) {
                                this.setBlock(level, position.north(), state, false);
                                this.setBlock(level, position.south(), state, false);
                            } else {
                                this.setBlock(level, position.east(), state, false);
                                this.setBlock(level, position.west(), state, false);
                            }
                            rotation = !rotation;
                        }
                        position.move(0, 1, 0);
                    }
                } else {
                    position.move(0, treeHeight, 0);
                    for (int i = 0; i < 3; ++i) {
                        position.move(0, -2, 0);
                        for (BlockPos p : this.fullSnowflake((BlockPos)position, (double)treeHeight / ((double)i + 0.9), 2)) {
                            this.setBlock(level, p, this.getState(config, random.nextBoolean()), false);
                        }
                        this.grow(level, (BlockPos)position, this.getState(config, random.nextBoolean()), 1, 1);
                        if (i >= 2) continue;
                        this.grow(level, (BlockPos)position, this.getState(config, random.nextBoolean()), 2, 2);
                        if (i != 0) continue;
                        this.grow(level, (BlockPos)position, this.getState(config, random.nextBoolean()), 3, 3);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected BlockState getState(TreeConfig config, boolean b) {
        return b ? config.leaves : config.log;
    }

    protected ArrayList<BlockPos> fullSnowflake(BlockPos center, double size, int detail) {
        this.pos = center.getCenter().add(-size / 1.55, 0.0, -size / 3.0);
        this.left = new Vec3(-1.0, 0.0, 0.0);
        this.right = new Vec3(1.0, 0.0, 0.0);
        this.upright = new Vec3(0.5, 0.0, Math.sqrt(3.0) / 2.0);
        this.downright = new Vec3(0.5, 0.0, -Math.sqrt(3.0) / 2.0);
        this.downleft = new Vec3(-0.5, 0.0, -Math.sqrt(3.0) / 2.0);
        this.upleft = new Vec3(-0.5, 0.0, Math.sqrt(3.0) / 2.0);
        this.current = this.upright;
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        this.snowflake(result, size, detail);
        this.turnRight();
        this.snowflake(result, size, detail);
        this.turnRight();
        this.snowflake(result, size, detail);
        return result;
    }

    protected void snowflake(ArrayList<BlockPos> map, double sideLength, int level) {
        if (level == 0) {
            Vec3 movement = this.current.multiply(sideLength, 0.0, sideLength);
            if (movement.x >= 1.0 || movement.z >= 1.0) {
                BlockPos position;
                int steps = (int)(movement.x > movement.z ? movement.x * 2.0 : movement.z * 2.0);
                Vec3 step = new Vec3(movement.x / (double)steps, 0.0, movement.z / (double)steps);
                for (int i = 0; i < steps; ++i) {
                    position = new BlockPos((int)this.pos.x, (int)this.pos.y, (int)this.pos.z);
                    if (!map.contains(position)) {
                        map.add(position);
                    }
                    this.pos = this.pos.add(step);
                }
                position = new BlockPos((int)this.pos.x, (int)this.pos.y, (int)this.pos.z);
                if (!map.contains(position)) {
                    map.add(position);
                }
            } else {
                BlockPos position = new BlockPos((int)this.pos.x, (int)this.pos.y, (int)this.pos.z);
                if (!map.contains(position)) {
                    map.add(position);
                }
                this.pos = this.pos.add(movement);
                position = new BlockPos((int)this.pos.x, (int)this.pos.y, (int)this.pos.z);
                if (!map.contains(position)) {
                    map.add(position);
                }
            }
        } else {
            this.snowflake(map, sideLength /= 3.0, --level);
            this.turnLeft();
            this.snowflake(map, sideLength, level);
            this.turnRight();
            this.snowflake(map, sideLength, level);
            this.turnLeft();
            this.snowflake(map, sideLength, level);
        }
    }

    protected void turnLeft() {
        this.current = this.current.equals((Object)this.right) ? this.upright : (this.current.equals((Object)this.upright) ? this.upleft : (this.current.equals((Object)this.upleft) ? this.left : (this.current.equals((Object)this.left) ? this.downleft : (this.current.equals((Object)this.downleft) ? this.downright : this.right))));
    }

    protected void turnRight() {
        this.current = this.current.equals((Object)this.right) ? this.downleft : (this.current.equals((Object)this.downleft) ? this.upleft : (this.current.equals((Object)this.upleft) ? this.right : (this.current.equals((Object)this.left) ? this.upright : (this.current.equals((Object)this.upright) ? this.downright : this.left))));
    }
}

