/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.registries.PlacementModifierRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class ChunkMargin
extends PlacementFilter {
    public static final MapCodec<ChunkMargin> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("margin").forGetter(config -> config.margin)).apply((Applicative)instance, ChunkMargin::new));
    public final int margin;

    public ChunkMargin(int margin) {
        this.margin = margin;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource source, BlockPos pos) {
        int x = pos.getX() & 0xF;
        int y = pos.getY() & 0xF;
        return x >= this.margin && x < 16 - this.margin && y >= this.margin && y < 16 - this.margin;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementModifierRegistry.CHUNK_MARGIN.get();
    }
}

