/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world.placement;

import com.mojang.serialization.MapCodec;
import divinerpg.registries.PlacementModifierRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class Underground
extends PlacementFilter {
    private static final Underground INSTANCE = new Underground();
    public static final MapCodec<Underground> CODEC = MapCodec.unit(() -> INSTANCE);

    private Underground() {
    }

    public static Underground underground() {
        return INSTANCE;
    }

    protected boolean shouldPlace(PlacementContext context, RandomSource source, BlockPos pos) {
        return Underground.isUnderground((LevelAccessor)context.getLevel(), pos);
    }

    public static boolean isUnderground(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mut = pos.mutable();
        while (mut.getY() < level.getMaxBuildHeight() - 1) {
            BlockState state = level.getBlockState((BlockPos)mut.move(Direction.UP));
            if (!state.canOcclude() || state.is(BlockTags.LEAVES) || state.is(Blocks.SNOW_BLOCK)) continue;
            return level.getBrightness(LightLayer.SKY, pos.above()) < 7;
        }
        return false;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementModifierRegistry.UNDERGROUND.get();
    }
}

