/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mcreator.desertsanddunes.DesertsAndDunesFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PalmFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PalmFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> PalmFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PalmFoliagePlacer::new));

    public PalmFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return DesertsAndDunesFoliagePlacers.PALM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader reader, FoliagePlacer.FoliageSetter replacer, RandomSource random, TreeConfiguration config, int foliageHeight, FoliagePlacer.FoliageAttachment attachment, int radius, int offset, int foliageOffset) {
        BlockPos pos = attachment.pos();
        int frondCount = 8;
        int frondLength = 4;
        for (int i = 0; i < frondCount; ++i) {
            double angle = Math.PI * 2 / (double)frondCount * (double)i;
            for (int j = 1; j <= frondLength; ++j) {
                int dx = (int)Math.round(Math.cos(angle) * (double)j);
                int dz = (int)Math.round(Math.sin(angle) * (double)j);
                int dy = (int)Math.floor((double)j * 0.5);
                BlockPos leafPos = pos.offset(dx, -dy, dz);
                replacer.set(leafPos, config.foliageProvider.getState(random, leafPos));
            }
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return 2;
    }

    protected boolean shouldSkipLocation(RandomSource random, int dx, int dy, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

