/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mcreator.desertsanddunes.DesertsAndDunesFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class PalmTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<PalmTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("baseHeight").forGetter(placer -> placer.baseHeight), (App)Codec.intRange((int)0, (int)16).fieldOf("heightVariance").forGetter(placer -> placer.heightVariance)).apply((Applicative)instance, PalmTrunkPlacer::new));
    private final int baseHeight;
    private final int heightVariance;

    public PalmTrunkPlacer(int baseHeight, int heightVariance) {
        super(0, 0, 0);
        this.baseHeight = baseHeight;
        this.heightVariance = heightVariance;
    }

    protected TrunkPlacerType<?> type() {
        return DesertsAndDunesFoliagePlacers.PALM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> replacer, RandomSource random, int totalHeight, BlockPos startPos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int trunkHeight = this.baseHeight + random.nextInt(this.heightVariance + 1);
        double angle = random.nextDouble() * Math.PI * 2.0;
        int maxOffset = 3;
        for (int y = 0; y < trunkHeight; ++y) {
            double factor = (double)y / (double)trunkHeight;
            int dx = (int)Math.round(factor * (double)maxOffset * Math.cos(angle));
            int dz = (int)Math.round(factor * (double)maxOffset * Math.sin(angle));
            BlockPos pos = startPos.offset(dx, y, dz);
            replacer.accept(pos, config.trunkProvider.getState(random, pos));
        }
        int finalDx = (int)Math.round((double)maxOffset * Math.cos(angle));
        int finalDz = (int)Math.round((double)maxOffset * Math.sin(angle));
        BlockPos attachmentPos = startPos.offset(finalDx, trunkHeight, finalDz);
        attachments.add(new FoliagePlacer.FoliageAttachment(attachmentPos, 0, true));
        return attachments;
    }
}

