/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.mcreator.desertsanddunes.DesertsAndDunesFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class RingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<RingTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> RingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, RingTrunkPlacer::new));

    public RingTrunkPlacer(int baseHeight, int heightA, int heightB) {
        super(baseHeight, heightA, heightB);
    }

    protected TrunkPlacerType<?> type() {
        return DesertsAndDunesFoliagePlacers.RING_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, RandomSource randomSource, int totalHeight, BlockPos startPos, TreeConfiguration treeConfig) {
        int[][] branchOffsets;
        ArrayList<FoliagePlacer.FoliageAttachment> foliageNodes = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int y = 0; y < totalHeight; ++y) {
            BlockPos trunkPos = startPos.above(y);
            this.placeTrunkBlock(level, replacer, randomSource, trunkPos, treeConfig);
        }
        int midLevel = totalHeight / 2;
        BlockPos midPos = startPos.above(midLevel);
        int baseBranchLength = 3;
        for (int[] offset : branchOffsets = new int[][]{{0, -1}, {1, -1}, {1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}}) {
            boolean isDiagonal = offset[0] != 0 && offset[1] != 0;
            int extraLength = randomSource.nextInt(2);
            int branchLength = baseBranchLength + extraLength;
            BlockPos currentPos = midPos;
            int iterations = isDiagonal ? branchLength - 1 : branchLength;
            int curvatureThreshold = iterations / 2 + randomSource.nextInt(2);
            for (int i = 1; i <= iterations; ++i) {
                int verticalOffset = 0;
                if (i >= curvatureThreshold || randomSource.nextFloat() < 0.2f) {
                    verticalOffset = 1;
                }
                currentPos = currentPos.offset(offset[0], verticalOffset, offset[1]);
                this.placeTrunkBlock(level, replacer, randomSource, currentPos, treeConfig);
            }
            if (isDiagonal) {
                currentPos = currentPos.above(1);
                this.placeTrunkBlock(level, replacer, randomSource, currentPos, treeConfig);
            } else {
                currentPos = currentPos.above(1);
                this.placeTrunkBlock(level, replacer, randomSource, currentPos, treeConfig);
            }
            foliageNodes.add(new FoliagePlacer.FoliageAttachment(currentPos, 0, false));
        }
        BlockPos extraBranchPos = startPos.above(totalHeight);
        this.placeTrunkBlock(level, replacer, randomSource, extraBranchPos, treeConfig);
        foliageNodes.add(new FoliagePlacer.FoliageAttachment(extraBranchPos, 0, false));
        return foliageNodes;
    }

    private void placeTrunkBlock(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> replacer, RandomSource randomSource, BlockPos pos, TreeConfiguration treeConfig) {
        BlockState state = treeConfig.trunkProvider.getState(randomSource, pos);
        replacer.accept(pos, state);
    }
}

