/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelantlion<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"desertsanddunes", (String)"modelantlion"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart topleft;
    public final ModelPart topright;
    public final ModelPart left;
    public final ModelPart right;

    public Modelantlion(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.topleft = root.getChild("topleft");
        this.topright = root.getChild("topright");
        this.left = root.getChild("left");
        this.right = root.getChild("right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(36, 40).addBox(-2.0f, 1.0f, -8.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)-3.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(28, 20).addBox(0.5f, -0.5f, -8.0f, 3.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.2849f, (float)-0.274f, (float)0.8249f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(29, 29).addBox(-3.5f, -0.5f, -8.0f, 3.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)-0.2849f, (float)0.274f, (float)-0.8249f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -5.0f, 3.0f, 10.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-3.0f, -1.5f, -1.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)-3.0f));
        PartDefinition topleft = partdefinition.addOrReplaceChild("topleft", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)21.0f, (float)-2.5f));
        PartDefinition cube_r3 = topleft.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(38, 38).addBox(0.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.3927f));
        PartDefinition topright = partdefinition.addOrReplaceChild("topright", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)21.0f, (float)-2.5f));
        PartDefinition cube_r4 = topright.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 40).addBox(-8.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)-0.3927f));
        PartDefinition left = partdefinition.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)21.0f, (float)-0.5f));
        PartDefinition cube_r5 = left.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(20, 38).addBox(0.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.3927f));
        PartDefinition right = partdefinition.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)21.0f, (float)-0.5f));
        PartDefinition cube_r6 = right.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(18, 40).addBox(-8.0f, -0.5f, -0.5f, 8.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)-0.3927f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.topleft.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.topright.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.topleft.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.topright.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

