/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelcoyote<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"desertsanddunes", (String)"modelcoyote"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart topleft;
    public final ModelPart topright;
    public final ModelPart left;
    public final ModelPart right;
    public final ModelPart tail;

    public Modelcoyote(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.topleft = root.getChild("topleft");
        this.topright = root.getChild("topright");
        this.left = root.getChild("left");
        this.right = root.getChild("right");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.37f, -3.5f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 14).addBox(1.0f, -5.37f, -1.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(16, 14).addBox(-3.0f, -5.37f, -1.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-1.5f, -0.39f, -6.5f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.87f, (float)-5.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.75f, (float)0.75f));
        PartDefinition mane_rotation_r1 = body.addOrReplaceChild("mane_rotation_r1", CubeListBuilder.create().texOffs(21, 0).addBox(-4.0f, -18.0f, -1.0f, 8.0f, 6.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(18, 14).addBox(-3.0f, -12.0f, -1.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.25f, (float)11.25f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition topleft = partdefinition.addOrReplaceChild("topleft", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)17.0f, (float)-4.0f));
        PartDefinition topright = partdefinition.addOrReplaceChild("topright", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)17.0f, (float)-4.0f));
        PartDefinition left = partdefinition.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 18).addBox(2.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)17.0f, (float)7.0f));
        PartDefinition right = partdefinition.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)17.0f, (float)7.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.0f, (float)8.0f));
        PartDefinition tail_r1 = tail.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(43, 17).addBox(-1.5f, -0.4092f, -1.1738f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4974f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.topleft.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.topright.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.topleft.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.topright.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.tail.zRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.right.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

