/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Modellizard<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"desertsanddunes", (String)"modellizard"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart leftarm;
    public final ModelPart rightarm;
    public final ModelPart leftleg;
    public final ModelPart rightleg;
    public final ModelPart tail;

    public Modellizard(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftarm = root.getChild("leftarm");
        this.rightarm = root.getChild("rightarm");
        this.leftleg = root.getChild("leftleg");
        this.rightleg = root.getChild("rightleg");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 15).addBox(-3.0f, -3.0f, -7.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)-5.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 29).addBox(-4.0f, 0.0f, -4.5f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(26, 24).addBox(-4.0f, -1.0f, 3.5f, 8.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-3.0f, -2.0f, -5.0f, 6.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition leftarm = partdefinition.addOrReplaceChild("leftarm", CubeListBuilder.create().texOffs(10, 38).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 5).addBox(-2.0f, 3.0f, -3.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)21.0f, (float)-3.5f));
        PartDefinition rightarm = partdefinition.addOrReplaceChild("rightarm", CubeListBuilder.create().texOffs(18, 38).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 9).addBox(-2.0f, 3.0f, -3.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)21.0f, (float)-3.5f));
        PartDefinition leftleg = partdefinition.addOrReplaceChild("leftleg", CubeListBuilder.create().texOffs(34, 33).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(16, 33).addBox(-2.0f, 4.0f, -3.5f, 4.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)20.0f, (float)5.0f));
        PartDefinition rightleg = partdefinition.addOrReplaceChild("rightleg", CubeListBuilder.create().texOffs(0, 35).addBox(-1.0f, 0.0f, -1.5f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(34, 0).addBox(-2.0f, 4.0f, -3.5f, 4.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)20.0f, (float)5.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(26, 15).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-1.0f, -0.75f, 6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.25f, (float)6.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightarm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.leftleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.rightleg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.tail.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
    }
}

