/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.desertsanddunes.client.model.Modelroadrunner;
import net.mcreator.desertsanddunes.client.model.animations.roadrunnerAnimation;
import net.mcreator.desertsanddunes.entity.RoadrunnerEntity;
import net.mcreator.desertsanddunes.procedures.RoadrunnerDisplayConditionProcedure;
import net.mcreator.desertsanddunes.procedures.RoadrunnerModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RoadrunnerRenderer
extends MobRenderer<RoadrunnerEntity, Modelroadrunner<RoadrunnerEntity>> {
    public RoadrunnerRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelroadrunner.LAYER_LOCATION)), 0.3f);
        this.addLayer((RenderLayer)new RenderLayer<RoadrunnerEntity, Modelroadrunner<RoadrunnerEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"desertsanddunes:textures/entities/the_roadrunner.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RoadrunnerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (RoadrunnerDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelroadrunner)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(RoadrunnerEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)RoadrunnerModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(RoadrunnerEntity entity) {
        return ResourceLocation.parse((String)"desertsanddunes:textures/entities/roadrunner.png");
    }

    private static final class AnimatedModel
    extends Modelroadrunner<RoadrunnerEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RoadrunnerEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RoadrunnerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(roadrunnerAnimation.roadrunner_walk, limbSwing, limbSwingAmount, 2.5f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RoadrunnerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

