/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.desertsanddunes.client.model.Modeltortoise;
import net.mcreator.desertsanddunes.client.model.animations.tortoiseAnimation;
import net.mcreator.desertsanddunes.entity.TortoiseEntity;
import net.mcreator.desertsanddunes.procedures.TortoiseDisplayCondition1Procedure;
import net.mcreator.desertsanddunes.procedures.TortoiseDisplayConditionProcedure;
import net.mcreator.desertsanddunes.procedures.TortoiseModelVisualScaleProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TortoiseRenderer
extends MobRenderer<TortoiseEntity, Modeltortoise<TortoiseEntity>> {
    public TortoiseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeltortoise.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<TortoiseEntity, Modeltortoise<TortoiseEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"desertsanddunes:textures/entities/tortuga_.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, TortoiseEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (TortoiseDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeltortoise)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<TortoiseEntity, Modeltortoise<TortoiseEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"desertsanddunes:textures/entities/mine_tortoise.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, TortoiseEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (TortoiseDisplayCondition1Procedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeltortoise)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    protected void scale(TortoiseEntity entity, PoseStack poseStack, float f) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        float scale = (float)TortoiseModelVisualScaleProcedure.execute((Entity)entity);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(TortoiseEntity entity) {
        return ResourceLocation.parse((String)"desertsanddunes:textures/entities/tortoise.png");
    }

    private static final class AnimatedModel
    extends Modeltortoise<TortoiseEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<TortoiseEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(TortoiseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(tortoiseAnimation.tortoise_walk, limbSwing, limbSwingAmount, 10.0f, 4.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(TortoiseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

