/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.desertsanddunes.network;

import net.mcreator.desertsanddunes.DesertsanddunesMod;
import net.mcreator.desertsanddunes.procedures.AlchemyTableCrafting1Procedure;
import net.mcreator.desertsanddunes.procedures.AlchemyTableCrafting2Procedure;
import net.mcreator.desertsanddunes.procedures.AlchemyTableCraftingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record AlchemyTableGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AlchemyTableGUISlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"desertsanddunes", (String)"alchemy_table_gui_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AlchemyTableGUISlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new AlchemyTableGUISlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<AlchemyTableGUISlotMessage> type() {
        return TYPE;
    }

    public static void handleData(AlchemyTableGUISlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> AlchemyTableGUISlotMessage.handleSlotAction(context.player(), message.slotID, message.changeType, message.meta, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        int amount;
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            AlchemyTableCrafting1Procedure.execute((Entity)entity);
        }
        if (slot == 0 && changeType == 2) {
            amount = meta;
            AlchemyTableCrafting1Procedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 0) {
            AlchemyTableCraftingProcedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 2) {
            amount = meta;
            AlchemyTableCraftingProcedure.execute((Entity)entity);
        }
        if (slot == 2 && changeType == 1) {
            amount = meta;
            AlchemyTableCrafting2Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DesertsanddunesMod.addNetworkMessage(TYPE, STREAM_CODEC, AlchemyTableGUISlotMessage::handleData);
    }
}

