/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1317;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import net.minecraft.class_9168;
import net.minecraft.class_9169;
import net.minecraft.class_9463;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import potatowolfie.earth_and_water.block.ModBlocks;
import potatowolfie.earth_and_water.block.entity.ModBlockEntities;
import potatowolfie.earth_and_water.datagen.ModLootTableModifier;
import potatowolfie.earth_and_water.effect.ModEffects;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.entity.bore.BoreEntity;
import potatowolfie.earth_and_water.entity.brine.BrineEntity;
import potatowolfie.earth_and_water.item.ModItems;
import potatowolfie.earth_and_water.sound.ModSounds;
import potatowolfie.earth_and_water.structure.ModStructurePieceTypes;
import potatowolfie.earth_and_water.structure.ModStructureTypes;
import potatowolfie.earth_and_water.world.feature.ModFeatures;
import potatowolfie.earth_and_water.world.gen.ModWorldGeneration;

public class EarthWater
implements ModInitializer {
    public static final String MOD_ID = "earth-and-water";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"earth-and-water");
    public static final class_2400 LIGHT_UP = FabricParticleTypes.simple();
    public static final class_2400 REINFORCED_SPAWNER_DETECTION = FabricParticleTypes.simple();
    public static final class_2400 REINFORCED_SPAWNER_DETECTION_OUTWARD = FabricParticleTypes.simple();
    public static final class_2400 REINFORCED_SPAWNER_DETECTION_INNER = FabricParticleTypes.simple();

    public void onInitialize() {
        ModItems.registerModItems();
        ModBlocks.registerModBlocks();
        ModEffects.registerEffects();
        ModEntities.registerModEntities();
        ModBlockEntities.registerBlockEntities();
        ModSounds.registerSounds();
        ModFeatures.registerModFeatures();
        ModWorldGeneration.init();
        ModStructureTypes.registerStructureTypes();
        ModStructurePieceTypes.registerStructurePieceTypes();
        ModLootTableModifier.modifyLootTables();
        this.registerChunkLoadEvent();
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"light_up"), (Object)LIGHT_UP);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"reinforced_spawner_detection"), (Object)REINFORCED_SPAWNER_DETECTION);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"reinforced_spawner_detection_outward"), (Object)REINFORCED_SPAWNER_DETECTION_OUTWARD);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)class_2960.method_60655((String)MOD_ID, (String)"reinforced_spawner_detection_inner"), (Object)REINFORCED_SPAWNER_DETECTION_INNER);
        this.registerDispenserBehaviors();
        FabricDefaultAttributeRegistry.register(ModEntities.BORE, (class_5132.class_5133)BoreEntity.createBoreAttributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BRINE, (class_5132.class_5133)BrineEntity.createBrineAttributes());
        class_1317.method_20637(ModEntities.BRINE, (class_9168)class_9169.field_48743, (class_2902.class_2903)class_2902.class_2903.field_13200, BrineEntity::canSpawn);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            server.method_30002().method_64310(class_2338.field_10980, class_2246.field_10593, 1);
            server.method_30002().method_64310(class_2338.field_10980, class_2246.field_27098, 1);
            server.method_30002().method_64310(class_2338.field_10980, class_2246.field_27097, 1);
            server.method_30002().method_64310(class_2338.field_10980, class_2246.field_27878, 1);
        });
        LOGGER.info("Earth and Water mod initialized!");
    }

    private void registerDispenserBehaviors() {
        this.registerProjectileDispenserBehavior(ModItems.WATER_CHARGE);
        this.registerProjectileDispenserBehavior(ModItems.EARTH_CHARGE);
    }

    private void registerChunkLoadEvent() {
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> this.scheduleBlockTicksForChunk(world, chunk));
    }

    private void scheduleBlockTicksForChunk(class_3218 world, class_2818 chunk) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int minY = world.method_31607();
                int maxY = minY + world.method_31605();
                for (int y = minY; y < maxY; ++y) {
                    pos.method_10103(chunk.method_12004().method_8326() + x, y, chunk.method_12004().method_8328() + z);
                    class_2680 state = chunk.method_8320((class_2338)pos);
                    class_2248 block = state.method_26204();
                    if (block != ModBlocks.CHISELED_DARK_PRISMARINE && block != ModBlocks.CHISELED_PRISMARINE_BRICKS && block != ModBlocks.CHISELED_DARK_DRIPSTONE_BRICKS && block != ModBlocks.CHISELED_DRIPSTONE_BRICKS && block != ModBlocks.REINFORCED_SPAWNER) continue;
                    world.method_64310(pos.method_10062(), block, 2);
                }
            }
        }
    }

    private void registerProjectileDispenserBehavior(class_1792 item) {
        class_2315.method_10009((class_1935)item, (pointer, stack) -> {
            class_3218 world = pointer.comp_1967();
            class_2374 position = class_2315.method_58682((class_2342)pointer);
            class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_9463 projectileItem = (class_9463)stack.method_7909();
            class_1676 projectileEntity = projectileItem.method_58648((class_1937)world, position, stack, direction);
            projectileEntity.method_7485((double)direction.method_10148(), (double)((float)direction.method_10164() + 0.1f), (double)direction.method_10165(), 1.5f, 0.1f);
            world.method_8649((class_1297)projectileEntity);
            stack.method_7934(1);
            return stack;
        });
    }
}

