/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.block.entity.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import potatowolfie.earth_and_water.EarthWater;
import potatowolfie.earth_and_water.block.custom.ReinforcedSpawnerBlock;
import potatowolfie.earth_and_water.block.entity.ModBlockEntities;
import potatowolfie.earth_and_water.item.custom.ReinforcedKeyItem;

public class ReinforcedSpawnerBlockEntity
extends class_2586 {
    private static final int DETECTION_RADIUS = 14;
    private static final int SPAWN_DELAY = 20;
    private static final int BASE_WAVE_SIZE = 3;
    private static final int ADDITIONAL_MOBS_PER_PLAYER = 2;
    private static final int KEY_DETECTION_RADIUS = 3;
    private static final int KEY_USAGE_COOLDOWN = 28;
    private static final int WAVE_DELAY = 60;
    private static final float DISPLAY_ROTATION_SPEED = 1.5f;
    private static final int MOB_SPAWN_INTERVAL = 5;
    private static final double MOB_TRACKING_RANGE = 64.0;
    private static final int ACTIVATION_PARTICLE_DURATION = 5;
    private static final int WAVE_PARTICLE_DURATION = 5;
    private class_1299<?> entityType = null;
    private boolean isActive = false;
    private int spawnDelay = 0;
    private Set<UUID> currentWaveMobs = new HashSet<UUID>();
    private Random random = new Random();
    private boolean isWaveActive = false;
    private int currentWaveSize = 0;
    private int waveDelayCounter = 0;
    private int currentWaveNumber = 1;
    private int pendingSpawns = 0;
    private int nextSpawnDelay = 0;
    private class_1297 cachedDisplayEntity = null;
    private double rotation = 0.0;
    private double lastRotation = 0.0;
    private long lastKeyUsageTime = 0L;
    private boolean wasInCooldown = false;
    private int activationParticleTimer = 0;
    private boolean isActivating = false;
    private int waveParticleTimer = 0;
    private boolean isSpawningWave = false;
    private int deactivationParticleTimer = 0;
    private boolean isDeactivating = false;

    public ReinforcedSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.REINFORCED_SPAWNER_BLOCK_ENTITY, pos, state);
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, ReinforcedSpawnerBlockEntity spawner) {
        if (!world.method_8608()) {
            spawner.updateDisplayRotation();
            spawner.checkForNearbyKeyHolders(world, pos, state);
            spawner.cleanupWaveMobs((class_3218)world);
            if (spawner.activationParticleTimer > 0) {
                if (spawner.activationParticleTimer == 5) {
                    spawner.spawnActivationParticles((class_3218)world, pos);
                }
                --spawner.activationParticleTimer;
                if (spawner.activationParticleTimer == 0) {
                    spawner.isActivating = false;
                }
            }
            if (spawner.deactivationParticleTimer > 0) {
                if (spawner.deactivationParticleTimer == 5) {
                    spawner.spawnDeactivationParticles((class_3218)world, pos);
                }
                --spawner.deactivationParticleTimer;
                if (spawner.deactivationParticleTimer == 0) {
                    spawner.isDeactivating = false;
                }
            }
            if (spawner.waveParticleTimer > 0) {
                if (spawner.waveParticleTimer == 5) {
                    spawner.spawnWaveParticles((class_3218)world, pos);
                }
                --spawner.waveParticleTimer;
                if (spawner.waveParticleTimer == 0) {
                    spawner.isSpawningWave = false;
                }
            }
            if (((Boolean)state.method_11654((class_2769)ReinforcedSpawnerBlock.ACTIVE)).booleanValue()) {
                spawner.tick((class_3218)world);
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, ReinforcedSpawnerBlockEntity spawner) {
        if (world.method_8608()) {
            spawner.updateDisplayRotation();
            if (((Boolean)state.method_11654((class_2769)ReinforcedSpawnerBlock.ACTIVE)).booleanValue()) {
                spawner.tickClient(world, pos);
            }
        }
    }

    public class_1297 getDisplayEntity(class_1937 world) {
        if (this.entityType == null) {
            return null;
        }
        if (this.cachedDisplayEntity == null || this.cachedDisplayEntity.method_5864() != this.entityType) {
            this.cachedDisplayEntity = this.entityType.method_5883(world, class_3730.field_16469);
        }
        return this.cachedDisplayEntity;
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getLastRotation() {
        return this.lastRotation;
    }

    public float getDisplayRotation(float tickDelta) {
        return (float)(this.lastRotation + (this.rotation - this.lastRotation) * (double)tickDelta);
    }

    private void updateDisplayRotation() {
        this.lastRotation = this.rotation;
        this.rotation += 1.5;
    }

    private void checkForNearbyKeyHolders(class_1937 world, class_2338 pos, class_2680 state) {
        boolean currentKeyhole;
        boolean isInCooldown;
        long currentTime = world.method_75260();
        boolean bl = isInCooldown = currentTime - this.lastKeyUsageTime < 28L;
        if (this.wasInCooldown && !isInCooldown) {
            this.wasInCooldown = false;
        } else {
            if (isInCooldown) {
                this.wasInCooldown = true;
                return;
            }
            this.wasInCooldown = false;
        }
        class_238 detectionBox = new class_238(pos).method_1014(3.0);
        List nearbyPlayers = world.method_8390(class_1657.class, detectionBox, player -> player.method_5805() && !player.method_7325());
        boolean hasKeyHolder = false;
        for (class_1657 player2 : nearbyPlayers) {
            if (!(player2.method_6047().method_7909() instanceof ReinforcedKeyItem) && !(player2.method_6079().method_7909() instanceof ReinforcedKeyItem)) continue;
            hasKeyHolder = true;
            break;
        }
        if ((currentKeyhole = ((Boolean)state.method_11654((class_2769)ReinforcedSpawnerBlock.KEYHOLE)).booleanValue()) != hasKeyHolder) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)ReinforcedSpawnerBlock.KEYHOLE, (Comparable)Boolean.valueOf(hasKeyHolder)));
            if (hasKeyHolder) {
                world.method_8396(null, pos, class_3417.field_48796, class_3419.field_15245, 1.0f, 1.0f);
            } else {
                world.method_8396(null, pos, class_3417.field_48800, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
    }

    private void tickClient(class_1937 world, class_2338 pos) {
        if (this.waveDelayCounter > 0) {
            this.emitIdleParticles(world, pos);
        }
        if (this.random.nextFloat() < 0.3f) {
            double d = (double)pos.method_10263() + 0.5 + (this.random.nextDouble() - 0.5) * 0.6;
            double e = (double)pos.method_10264() + 0.5 + (this.random.nextDouble() - 0.5) * 0.6;
            double f = (double)pos.method_10260() + 0.5 + (this.random.nextDouble() - 0.5) * 0.6;
            world.method_8406((class_2394)class_2398.field_11240, d, e, f, 0.0, 0.0, 0.0);
        }
        if (this.random.nextFloat() <= 0.02f) {
            world.method_8396(null, pos, class_3417.field_47208, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    private void emitIdleParticles(class_1937 world, class_2338 pos) {
        if (this.random.nextFloat() < 0.3f) {
            double d = (double)pos.method_10263() + 0.5 + (this.random.nextDouble() - 0.5) * 0.5;
            double e = (double)pos.method_10264() + 0.5 + (this.random.nextDouble() - 0.5) * 0.5;
            double f = (double)pos.method_10260() + 0.5 + (this.random.nextDouble() - 0.5) * 0.5;
            world.method_8406((class_2394)class_2398.field_27783, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    private void spawnActivationParticles(class_3218 world, class_2338 pos) {
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        int particleCount = 15;
        double radius = 0.3125;
        double topY = centerY + 0.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            world.method_65096((class_2394)EarthWater.REINFORCED_SPAWNER_DETECTION_INNER, x, topY, z, 2, 0.0, 0.6, 0.0, 0.0);
        }
        int outwardCount = 26 + this.random.nextInt(6);
        for (int i = 0; i < outwardCount; ++i) {
            world.method_65096((class_2394)EarthWater.REINFORCED_SPAWNER_DETECTION_OUTWARD, centerX, centerY, centerZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnDeactivationParticles(class_3218 world, class_2338 pos) {
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        int particleCount = 10;
        double radius = 0.3125;
        double topY = centerY + 0.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            world.method_65096((class_2394)EarthWater.REINFORCED_SPAWNER_DETECTION, x, topY, z, 1, 0.0, 0.3, 0.0, 0.0);
        }
        int outwardCount = 26 + this.random.nextInt(6);
        for (int i = 0; i < outwardCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)outwardCount;
            double velX = Math.cos(angle);
            double velZ = Math.sin(angle);
            world.method_65096((class_2394)EarthWater.REINFORCED_SPAWNER_DETECTION_OUTWARD, centerX, centerY, centerZ, 1, velX * 0.08, 0.0, velZ * 0.08, 0.0);
        }
    }

    private void spawnWaveParticles(class_3218 world, class_2338 pos) {
        double centerX = (double)pos.method_10263() + 0.5;
        double centerY = (double)pos.method_10264() + 0.5;
        double centerZ = (double)pos.method_10260() + 0.5;
        int particleCount = 10;
        double radius = 0.3125;
        double topY = centerY + 0.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = centerX + radius * Math.cos(angle);
            double z = centerZ + radius * Math.sin(angle);
            world.method_65096((class_2394)EarthWater.REINFORCED_SPAWNER_DETECTION, x, topY, z, 1, 0.0, 0.3, 0.0, 0.0);
        }
    }

    private void tick(class_3218 world) {
        if (!this.isActive || this.entityType == null) {
            return;
        }
        List<class_1657> nearbyPlayers = this.getNearbyPlayers(world);
        if (nearbyPlayers.isEmpty()) {
            return;
        }
        this.cleanupWaveMobs(world);
        if (this.pendingSpawns > 0) {
            if (this.nextSpawnDelay > 0) {
                --this.nextSpawnDelay;
            } else {
                if (this.trySpawnMob(world)) {
                    --this.pendingSpawns;
                }
                this.nextSpawnDelay = 5;
            }
        }
        if (this.waveDelayCounter > 0) {
            --this.waveDelayCounter;
            return;
        }
        if (this.isWaveActive && this.pendingSpawns == 0 && this.currentWaveMobs.isEmpty()) {
            this.isWaveActive = false;
            this.waveDelayCounter = 60;
            ++this.currentWaveNumber;
            world.method_8396(null, this.field_11867, class_3417.field_47206, class_3419.field_15245, 1.0f, 1.5f);
        }
        if (!this.isWaveActive && this.spawnDelay <= 0) {
            this.startNewWave(world, nearbyPlayers.size());
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
    }

    private void cleanupWaveMobs(class_3218 world) {
        this.currentWaveMobs.removeIf(uuid -> {
            class_1297 entity = world.method_66347(uuid);
            if (entity == null || !entity.method_5805()) {
                return true;
            }
            double distance = entity.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5);
            return distance > 4096.0;
        });
    }

    private void startNewWave(class_3218 world, int playerCount) {
        this.currentWaveSize = 3 + (playerCount - 1) * 2;
        this.isWaveActive = true;
        this.pendingSpawns = this.currentWaveSize;
        this.nextSpawnDelay = 0;
        if (!this.isActivating && !this.isDeactivating) {
            this.isSpawningWave = true;
            this.waveParticleTimer = 5;
        }
        world.method_8396(null, this.field_11867, class_3417.field_47208, class_3419.field_15245, 1.0f, 0.8f);
        this.spawnDelay = 20;
    }

    private List<class_1657> getNearbyPlayers(class_3218 world) {
        class_238 detectionBox = new class_238(this.field_11867).method_1014(14.0);
        return world.method_8390(class_1657.class, detectionBox, player -> player.method_5805() && !player.method_7325() && !player.method_68878());
    }

    private boolean trySpawnMob(class_3218 world) {
        for (int i = 0; i < 4; ++i) {
            class_1297 entity;
            double z;
            double y;
            double x = (double)this.field_11867.method_10263() + (this.random.nextDouble() - 0.5) * 8.0;
            class_2338 spawnPos = class_2338.method_49637((double)x, (double)(y = (double)(this.field_11867.method_10264() + this.random.nextInt(3) - 1)), (double)(z = (double)this.field_11867.method_10260() + (this.random.nextDouble() - 0.5) * 8.0));
            if (!world.method_18026(new class_238(spawnPos).method_1014(0.5)) || !((entity = this.entityType.method_5883((class_1937)world, class_3730.field_16469)) instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            mob.method_5808(x, y, z, this.random.nextFloat() * 360.0f, 0.0f);
            mob.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16469, null);
            if (!world.method_8649((class_1297)mob)) continue;
            this.currentWaveMobs.add(mob.method_5667());
            world.method_8396(null, spawnPos, class_3417.field_47206, class_3419.field_15245, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void activate() {
        this.isActive = true;
        this.spawnDelay = 0;
        this.isWaveActive = false;
        this.waveDelayCounter = 0;
        this.currentWaveNumber = 1;
        this.pendingSpawns = 0;
        this.nextSpawnDelay = 0;
        this.isActivating = true;
        this.activationParticleTimer = 5;
        this.method_5431();
    }

    public void deactivate() {
        this.isActive = false;
        this.spawnDelay = 0;
        this.isWaveActive = false;
        this.waveDelayCounter = 0;
        this.pendingSpawns = 0;
        this.nextSpawnDelay = 0;
        this.isDeactivating = true;
        this.deactivationParticleTimer = 5;
        this.method_5431();
    }

    public void setEntityType(class_1299<?> entityType) {
        this.entityType = entityType;
        this.cachedDisplayEntity = null;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public void onKeyUsed(class_1937 world) {
        this.lastKeyUsageTime = world.method_75260();
        this.method_5431();
    }

    public boolean canUseKey(class_1937 world) {
        return world.method_75260() - this.lastKeyUsageTime >= 28L;
    }

    public int getCurrentWaveNumber() {
        return this.currentWaveNumber;
    }

    public boolean isWaveActive() {
        return this.isWaveActive;
    }

    public int getRemainingMobs() {
        return this.currentWaveMobs.size();
    }

    public boolean isInWaveDelay() {
        return this.waveDelayCounter > 0;
    }

    public int getPendingSpawns() {
        return this.pendingSpawns;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_58692(registries);
    }

    public void method_11014(class_11368 readView) {
        super.method_11014(readView);
        readView.method_71441("EntityType").ifPresent(entityTypeId -> {
            this.entityType = (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)entityTypeId));
        });
        this.isActive = readView.method_71433("Active", false);
        this.spawnDelay = readView.method_71424("SpawnDelay", 0);
        this.rotation = readView.method_71422("Rotation", 0.0);
        this.lastRotation = readView.method_71422("LastRotation", 0.0);
        this.lastKeyUsageTime = 0L;
        this.wasInCooldown = readView.method_71433("WasInCooldown", false);
        this.isWaveActive = readView.method_71433("IsWaveActive", false);
        this.currentWaveSize = readView.method_71424("CurrentWaveSize", 0);
        this.waveDelayCounter = readView.method_71424("WaveDelayCounter", 0);
        this.currentWaveNumber = readView.method_71424("CurrentWaveNumber", 1);
        this.pendingSpawns = readView.method_71424("PendingSpawns", 0);
        this.nextSpawnDelay = readView.method_71424("NextSpawnDelay", 0);
        this.activationParticleTimer = readView.method_71424("ActivationParticleTimer", 0);
        this.isActivating = readView.method_71433("IsActivating", false);
        this.waveParticleTimer = readView.method_71424("WaveParticleTimer", 0);
        this.isSpawningWave = readView.method_71433("IsSpawningWave", false);
        this.deactivationParticleTimer = readView.method_71424("DeactivationParticleTimer", 0);
        this.isDeactivating = readView.method_71433("IsDeactivating", false);
        this.currentWaveMobs.clear();
        int mobCount = readView.method_71424("CurrentWaveMobsCount", 0);
        for (int i = 0; i < mobCount; ++i) {
            readView.method_71441("CurrentWaveMob_" + i).ifPresent(uuidString -> {
                try {
                    UUID uuid = UUID.fromString(uuidString);
                    this.currentWaveMobs.add(uuid);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
        }
        this.cachedDisplayEntity = null;
    }

    public void method_11007(class_11372 writeView) {
        super.method_11007(writeView);
        if (this.entityType != null) {
            class_2960 entityTypeId = class_7923.field_41177.method_10221(this.entityType);
            writeView.method_71469("EntityType", entityTypeId.toString());
        }
        writeView.method_71472("Active", this.isActive);
        writeView.method_71465("SpawnDelay", this.spawnDelay);
        writeView.method_71463("Rotation", this.rotation);
        writeView.method_71463("LastRotation", this.lastRotation);
        writeView.method_71466("LastKeyUsageTime", this.lastKeyUsageTime);
        writeView.method_71472("WasInCooldown", this.wasInCooldown);
        writeView.method_71472("IsWaveActive", this.isWaveActive);
        writeView.method_71465("CurrentWaveSize", this.currentWaveSize);
        writeView.method_71465("WaveDelayCounter", this.waveDelayCounter);
        writeView.method_71465("CurrentWaveNumber", this.currentWaveNumber);
        writeView.method_71465("PendingSpawns", this.pendingSpawns);
        writeView.method_71465("NextSpawnDelay", this.nextSpawnDelay);
        writeView.method_71465("ActivationParticleTimer", this.activationParticleTimer);
        writeView.method_71472("IsActivating", this.isActivating);
        writeView.method_71465("WaveParticleTimer", this.waveParticleTimer);
        writeView.method_71472("IsSpawningWave", this.isSpawningWave);
        writeView.method_71465("DeactivationParticleTimer", this.deactivationParticleTimer);
        writeView.method_71472("IsDeactivating", this.isDeactivating);
        writeView.method_71465("CurrentWaveMobsCount", this.currentWaveMobs.size());
        int index = 0;
        for (UUID uuid : this.currentWaveMobs) {
            writeView.method_71469("CurrentWaveMob_" + index, uuid.toString());
            ++index;
        }
    }
}

