/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.entity.bore;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import potatowolfie.earth_and_water.entity.earth_charge.EarthChargeProjectileEntity;
import potatowolfie.earth_and_water.sound.ModSounds;

public class BoreEntity
extends class_1588 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shootingAnimationState = new class_7094();
    public final class_7094 burrowingAnimationState = new class_7094();
    public final class_7094 unburrowingAnimationState = new class_7094();
    public final class_7094 whileburrowingAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private boolean isIdleAnimationRunning = false;
    private class_2338 burrowDestination = null;
    private boolean isWalkingWhileBurrowed = false;
    private int burrowCooldown = 0;
    private int nextBurrowTime = 0;
    private int burrowCooldownTimer = 0;
    private static final int BURROW_COOLDOWN_TICKS = 80;
    private boolean burrowAnimPlayed = false;
    private boolean animationStartedThisTick = false;
    private boolean whileburrowAnimPlayed = false;
    private int shootingDelay = 0;
    private static final double PROJECTILE_DANGER_RADIUS = 6.0;
    private static final double FRIENDLY_PROJECTILE_AVOIDANCE_RADIUS = 8.0;
    private boolean isInCombat = false;
    private int combatStartTime = 0;
    private class_1309 lastTarget = null;
    private class_243 circlingCenter = null;
    private double circlingAngle = 0.0;
    private int circlingDirection = 1;
    private class_243 stuckCheckPosition = null;
    private int stuckTimer = 0;
    private static final int STUCK_TIME_THRESHOLD = 60;
    private static final double STUCK_AREA_SIZE = 2.5;
    private static final class_2940<Integer> DATA_ID_TYPE_VARIANT = class_2945.method_12791(BoreEntity.class, (class_2941)class_2943.field_13327);
    private BoreState boreState = BoreState.IDLE;
    private BoreState previousState = BoreState.IDLE;
    private int animationTick = 0;
    private int stateTimer = 0;
    private int shootCooldown = 0;
    private class_2338 relocateTarget = null;
    private class_243 lastShootPosition = null;
    private boolean hasMovedEnoughToShoot = true;
    private boolean isChangingState = false;
    private static final class_2940<Integer> DATA_ID_STATE = class_2945.method_12791(BoreEntity.class, (class_2941)class_2943.field_13327);

    protected int getXpToDrop() {
        return 8 + this.field_5974.method_43048(5);
    }

    public class_7094 getAnimationState(String name) {
        return switch (name) {
            case "BORE_SHOOTING" -> this.shootingAnimationState;
            case "BORE_BURROWING" -> this.burrowingAnimationState;
            case "BORE_WHILE_BURROWING" -> this.whileburrowingAnimationState;
            case "BORE_UNBURROWING" -> this.unburrowingAnimationState;
            default -> this.idleAnimationState;
        };
    }

    public BoreEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 8;
    }

    public static class_5132.class_5133 createBoreAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23717, 32.0).method_26868(class_5134.field_23728, 0.42);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BoreAvoidProjectileGoal(this));
        this.field_6201.method_6277(1, (class_1352)new BoreBurrowingMovementGoal(this));
        this.field_6201.method_6277(2, (class_1352)new BoreShootGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BoreCircleGoal(this));
        this.field_6201.method_6277(4, (class_1352)new BoreRelocateGoal(this));
        this.field_6201.method_6277(5, (class_1352)new BoreFleeGoal(this));
        this.field_6201.method_6277(6, (class_1352)new BoreSmartPositioningGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[]{BoreEntity.class}));
    }

    public void method_5773() {
        if (this.method_31481() || this.method_73183() == null) {
            return;
        }
        this.animationStartedThisTick = false;
        super.method_5773();
        ++this.animationTick;
        ++this.stateTimer;
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.shootingDelay > 0) {
            --this.shootingDelay;
        }
        if (this.burrowCooldownTimer > 0) {
            --this.burrowCooldownTimer;
        }
        try {
            this.updateCombatState();
            this.updateMovementTracking();
            this.updateMovementSpeed();
            this.handleStateTransitions();
            this.updateAnimations();
            if (this.method_73183().method_8608()) {
                switch (this.getBoreState().ordinal()) {
                    case 2: {
                        if (this.stateTimer >= 20) break;
                        this.addBurrowParticles(this.burrowingAnimationState);
                        break;
                    }
                    case 3: {
                        if (this.stateTimer >= 10) break;
                        this.addBurrowParticles(this.unburrowingAnimationState);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class_3414 method_6002() {
        return ModSounds.BORE_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.BORE_HURT;
    }

    protected class_3414 method_5994() {
        return ModSounds.BORE_AMBIENT;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.method_56912(DATA_ID_STATE, (Object)BoreState.IDLE.ordinal());
    }

    private void updateCombatState() {
        class_1309 target = this.method_5968();
        boolean wasInCombat = this.isInCombat;
        if (target != null && target.method_5805() && !target.method_31481() && target != this.lastTarget) {
            this.isInCombat = true;
            this.combatStartTime = this.field_6012;
            this.lastTarget = target;
            this.circlingCenter = target.method_73189();
            this.circlingAngle = this.field_5974.method_43058() * Math.PI * 2.0;
            this.circlingDirection = this.field_5974.method_43056() ? 1 : -1;
        } else if (target == null || !target.method_5805() || target.method_31481()) {
            this.isInCombat = false;
            this.lastTarget = null;
            this.circlingCenter = null;
            this.shootingDelay = 0;
            this.burrowCooldown = 0;
            this.nextBurrowTime = 0;
        }
        if (this.isInCombat && target != null && target.method_5805() && !target.method_31481()) {
            this.circlingCenter = target.method_73189();
            this.handleCombatBurrowing();
        }
    }

    private boolean isStuckInSmallArea() {
        if (this.boreState != BoreState.BURROWING || !this.isWalkingWhileBurrowed) {
            this.stuckCheckPosition = null;
            this.stuckTimer = 0;
            return false;
        }
        class_243 currentPos = this.method_73189();
        if (this.stuckCheckPosition == null) {
            this.stuckCheckPosition = currentPos;
            this.stuckTimer = 0;
            return false;
        }
        double distance = currentPos.method_1022(this.stuckCheckPosition);
        if (distance <= 2.5) {
            ++this.stuckTimer;
            return this.stuckTimer >= 60;
        }
        this.stuckCheckPosition = currentPos;
        this.stuckTimer = 0;
        return false;
    }

    private void handleCombatBurrowing() {
        class_1309 target;
        if (this.burrowCooldown > 0) {
            --this.burrowCooldown;
        }
        if ((target = this.method_5968()) != null && target.method_5805() && !target.method_31481()) {
            boolean withinLimit;
            double distanceToTarget = this.method_5739((class_1297)target);
            List nearbyBurrowers = this.method_73183().method_8390(BoreEntity.class, this.method_5829().method_1014(16.0), bore -> bore != this && bore.getBoreState() == BoreState.BURROWING);
            boolean bl = withinLimit = nearbyBurrowers.size() < 4;
            if (distanceToTarget <= 4.0 && this.burrowCooldown <= 0 && this.burrowCooldownTimer <= 0 && this.boreState == BoreState.IDLE && !this.isNearbyProjectileDangerous() && withinLimit) {
                this.startBurrowing();
                this.burrowCooldown = 200 + this.field_5974.method_43048(100);
                for (BoreEntity bore2 : nearbyBurrowers) {
                    class_243 away = bore2.method_73189().method_1020(target.method_73189()).method_1029();
                    class_243 retreatPos = bore2.method_73189().method_1019(away.method_1021(6.0));
                    bore2.method_5942().method_6337(retreatPos.field_1352, retreatPos.field_1351, retreatPos.field_1350, 1.3);
                }
            }
        }
    }

    private void updateAnimations() {
        if (this.method_73183().method_8608()) {
            if (this.boreState == BoreState.IDLE) {
                if (!this.isIdleAnimationRunning) {
                    --this.idleAnimationTimeout;
                    if (this.idleAnimationTimeout <= 0) {
                        this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                        this.idleAnimationState.method_41322(this.field_6012);
                        this.isIdleAnimationRunning = true;
                    }
                }
            } else {
                this.idleAnimationTimeout = 0;
                this.isIdleAnimationRunning = false;
                this.idleAnimationState.method_41325();
            }
        }
    }

    private void updateMovementTracking() {
        double distanceMoved;
        class_243 currentPos;
        if (this.lastShootPosition != null && (currentPos = this.method_73189()) != null && (distanceMoved = currentPos.method_1022(this.lastShootPosition)) >= 4.0) {
            this.hasMovedEnoughToShoot = true;
        }
    }

    private void updateMovementSpeed() {
        double baseSpeed = 0.23;
        if (this.isInCombat && this.method_5968() != null) {
            int timeSinceCombatStart = this.field_6012 - this.combatStartTime;
            double progressionFactor = Math.min((double)timeSinceCombatStart / 120.0, 1.0);
            progressionFactor = this.easeInOutQuad(progressionFactor);
            double targetSpeed = 0.35;
            baseSpeed += (targetSpeed - baseSpeed) * progressionFactor;
        }
        switch (this.boreState.ordinal()) {
            case 2: {
                if (this.isWalkingWhileBurrowed) {
                    if (this.isInCombat && this.method_5968() != null) {
                        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.35);
                        break;
                    }
                    Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(0.6);
                    break;
                }
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(baseSpeed * 0.1);
                break;
            }
            case 3: {
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(baseSpeed * 0.1);
                break;
            }
            default: {
                Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192(baseSpeed);
            }
        }
    }

    private double easeInOutQuad(double t) {
        return t < 0.5 ? 2.0 * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 2.0) / 2.0;
    }

    public boolean method_64397(class_3218 world, class_1282 damageSource, float amount) {
        if (damageSource.method_49708(class_8111.field_42345) && this.boreState == BoreState.BURROWING) {
            return false;
        }
        if (this.getBoreState() == BoreState.BURROWING) {
            class_1309 living;
            class_1799 weapon;
            if (damageSource.method_49708(class_8111.field_42347) || damageSource.method_49708(class_8111.field_44869)) {
                return super.method_64397(world, damageSource, amount);
            }
            class_1297 attacker = damageSource.method_5529();
            if (attacker instanceof class_1309 && (weapon = (living = (class_1309)attacker).method_6047()).method_7909().toString().contains("pickaxe")) {
                this.forceUnburrow();
                this.burrowCooldownTimer = 80;
                return super.method_64397(world, damageSource, amount);
            }
            return false;
        }
        return super.method_64397(world, damageSource, amount);
    }

    private void handleStateTransitions() {
        switch (this.boreState.ordinal()) {
            case 1: {
                if (this.stateTimer == 20 && !this.method_73183().method_8608()) {
                    this.fireEarthCharge();
                }
                if (this.stateTimer < 40) break;
                this.setBoreState(BoreState.IDLE);
                this.setRelocationTarget();
                break;
            }
            case 2: {
                if (this.stateTimer == 20 && !this.isWalkingWhileBurrowed) {
                    this.setBurrowDestination();
                    this.isWalkingWhileBurrowed = true;
                    if (this.method_73183().method_8608() && this.burrowDestination != null && !this.whileburrowAnimPlayed) {
                        this.burrowingAnimationState.method_41325();
                        this.whileburrowingAnimationState.method_41322(this.field_6012);
                        this.whileburrowAnimPlayed = true;
                    } else if (this.method_73183().method_8608() && this.burrowDestination == null) {
                        this.forceUnburrow();
                        return;
                    }
                }
                if (this.isWalkingWhileBurrowed && this.burrowDestination != null) {
                    double distanceToDestination;
                    if (this.method_5942().method_6357()) {
                        this.method_5942().method_6337((double)this.burrowDestination.method_10263(), this.method_23318(), (double)this.burrowDestination.method_10260(), this.isInCombat && this.method_5968() != null ? 1.2 : 1.4);
                    }
                    if (!((distanceToDestination = Math.sqrt(this.method_5649(this.burrowDestination.method_10263(), this.burrowDestination.method_10264(), this.burrowDestination.method_10260()))) < 1.5) && this.stateTimer < 300) break;
                    this.forceUnburrow();
                    break;
                }
                if (this.stateTimer < 70) break;
                this.forceUnburrow();
                break;
            }
            case 3: {
                if (this.stateTimer < 40) break;
                this.setBoreState(BoreState.IDLE);
                this.burrowCooldownTimer = 80;
            }
        }
    }

    private void forceUnburrow() {
        if (this.method_73183().method_8608()) {
            this.whileburrowingAnimationState.method_41325();
            this.burrowingAnimationState.method_41325();
        }
        this.setBoreState(BoreState.UNBURROWING);
        this.burrowDestination = null;
        this.isWalkingWhileBurrowed = false;
        this.stuckCheckPosition = null;
        this.stuckTimer = 0;
    }

    private void setBurrowDestination() {
        double targetZ;
        double targetX;
        double offsetZ;
        double offsetX;
        double distance;
        double angle;
        double variance;
        double baseAngle;
        int attempts;
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            this.setBurrowDestinationRandom();
            return;
        }
        double currentY = this.method_23318();
        class_243 targetPos = target.method_73189();
        class_243 currentPos = this.method_73189();
        class_243 awayDirection = currentPos.method_1020(targetPos).method_1029();
        class_2338 bestDestination = null;
        double bestScore = Double.MAX_VALUE;
        for (attempts = 0; attempts < 24; ++attempts) {
            class_2338 targetPosBlock;
            baseAngle = Math.atan2(awayDirection.field_1350, awayDirection.field_1352);
            variance = (this.field_5974.method_43058() - 0.5) * Math.PI * 0.6;
            angle = baseAngle + variance;
            distance = 8.0 + this.field_5974.method_43058() * 6.0;
            offsetX = Math.cos(angle) * distance;
            offsetZ = Math.sin(angle) * distance;
            targetX = this.method_23317() + offsetX;
            double groundY = this.findGroundLevel(targetX, targetZ = this.method_23321() + offsetZ);
            if (groundY == -1.0 || groundY < currentY || !this.isPositionSafeForBurrowing(targetPosBlock = new class_2338((int)targetX, (int)groundY, (int)targetZ))) continue;
            double distanceFromTarget = Math.sqrt(Math.pow(targetX - targetPos.field_1352, 2.0) + Math.pow(targetZ - targetPos.field_1350, 2.0));
            double score = Math.abs(groundY - currentY) + distance * 0.1 - distanceFromTarget * 0.2;
            if (!this.isPathBlocked(new class_243((double)targetPosBlock.method_10263(), (double)targetPosBlock.method_10264(), (double)targetPosBlock.method_10260()))) {
                score -= 5.0;
            }
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestDestination = targetPosBlock;
        }
        if (bestDestination != null) {
            this.burrowDestination = bestDestination;
            return;
        }
        for (attempts = 0; attempts < 16; ++attempts) {
            baseAngle = Math.atan2(awayDirection.field_1350, awayDirection.field_1352);
            variance = (this.field_5974.method_43058() - 0.5) * Math.PI * 0.8;
            angle = baseAngle + variance;
            distance = 4.0 + this.field_5974.method_43058() * 4.0;
            offsetX = Math.cos(angle) * distance;
            offsetZ = Math.sin(angle) * distance;
            targetX = this.method_23317() + offsetX;
            class_2338 targetPosBlock = new class_2338((int)targetX, (int)currentY, (int)(targetZ = this.method_23321() + offsetZ));
            if (targetPosBlock.method_10264() < this.method_31478() || !this.isPositionSafe(targetPosBlock)) continue;
            this.burrowDestination = targetPosBlock;
            return;
        }
        this.burrowDestination = null;
    }

    private void setBurrowDestinationRandom() {
        double targetZ;
        double targetX;
        double offsetZ;
        double offsetX;
        double distance;
        double angle;
        int attempts;
        double currentY = this.method_23318();
        class_2338 bestDestination = null;
        double bestScore = Double.MAX_VALUE;
        for (attempts = 0; attempts < 24; ++attempts) {
            class_2338 targetPos;
            angle = this.field_5974.method_43058() * 2.0 * Math.PI;
            distance = 8.0 + this.field_5974.method_43058() * 6.0;
            offsetX = Math.cos(angle) * distance;
            offsetZ = Math.sin(angle) * distance;
            targetX = this.method_23317() + offsetX;
            double groundY = this.findGroundLevel(targetX, targetZ = this.method_23321() + offsetZ);
            if (groundY == -1.0 || !this.isPositionSafeForBurrowing(targetPos = new class_2338((int)targetX, (int)groundY, (int)targetZ))) continue;
            double score = Math.abs(groundY - currentY) + distance * 0.1;
            if (!this.isPathBlocked(new class_243((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260()))) {
                score -= 5.0;
            }
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestDestination = targetPos;
        }
        if (bestDestination != null) {
            this.burrowDestination = bestDestination;
            return;
        }
        for (attempts = 0; attempts < 16; ++attempts) {
            angle = this.field_5974.method_43058() * 2.0 * Math.PI;
            distance = 4.0 + this.field_5974.method_43058() * 4.0;
            offsetX = Math.cos(angle) * distance;
            offsetZ = Math.sin(angle) * distance;
            targetX = this.method_23317() + offsetX;
            class_2338 targetPos = new class_2338((int)targetX, (int)currentY, (int)(targetZ = this.method_23321() + offsetZ));
            if (!this.isPositionSafe(targetPos)) continue;
            this.burrowDestination = targetPos;
            return;
        }
        this.burrowDestination = null;
    }

    private boolean isPositionSafeForBurrowing(class_2338 pos) {
        if (this.method_73183() == null || pos == null) {
            return false;
        }
        if (this.method_73183().method_8320(pos).method_26204().toString().contains("lava") || this.method_73183().method_8320(pos).method_26204().toString().contains("water")) {
            return false;
        }
        int topY = this.method_73183().method_31607() + this.method_73183().method_31605() - 1;
        if (pos.method_10264() <= this.method_73183().method_31607() || pos.method_10264() >= topY - 2) {
            return false;
        }
        class_2338 belowPos = pos.method_10074();
        if (!this.method_73183().method_8320(belowPos).method_26212((class_1922)this.method_73183(), belowPos)) {
            return false;
        }
        return !this.method_73183().method_8320(pos).method_26212((class_1922)this.method_73183(), pos) && !this.method_73183().method_8320(pos.method_10084()).method_26212((class_1922)this.method_73183(), pos.method_10084());
    }

    private boolean isNavigationStuck() {
        return this.method_5942().method_6357() && this.boreState == BoreState.BURROWING && this.isWalkingWhileBurrowed && this.burrowDestination != null;
    }

    private boolean wouldFallOffEdge(class_243 targetPos) {
        if (this.method_73183() == null || targetPos == null) {
            return true;
        }
        class_2338 blockPos = new class_2338((int)targetPos.field_1352, (int)targetPos.field_1351, (int)targetPos.field_1350);
        class_2338 belowPos = blockPos.method_10074();
        for (int i = 1; i <= 3; ++i) {
            class_2338 checkPos = belowPos.method_10087(i);
            if (!this.method_73183().method_8320(checkPos).method_26212((class_1922)this.method_73183(), checkPos)) continue;
            return false;
        }
        return true;
    }

    private void setRelocationTarget() {
        for (int attempts = 0; attempts < 10; ++attempts) {
            double angle = this.field_5974.method_43058() * 2.0 * Math.PI;
            double distance = 10.0 + this.field_5974.method_43058() * 2.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            class_2338 targetPos = new class_2338((int)(this.method_23317() + offsetX), (int)this.method_23318(), (int)(this.method_23321() + offsetZ));
            if (!this.isPositionSafe(targetPos)) continue;
            this.relocateTarget = targetPos;
            break;
        }
    }

    private boolean isPositionSafe(class_2338 pos) {
        if (this.method_73183() == null || pos == null) {
            return false;
        }
        return this.method_73183().method_22347(pos) && this.method_73183().method_22347(pos.method_10084()) && this.method_73183().method_8320(pos.method_10074()).method_26212((class_1922)this.method_73183(), pos.method_10074());
    }

    public class_243 getCirclingPosition() {
        double z;
        double y;
        if (this.circlingCenter == null) {
            return null;
        }
        double radius = 8.0;
        double x = this.circlingCenter.field_1352 + Math.cos(this.circlingAngle) * radius;
        class_2338 testPos = new class_2338((int)x, (int)(y = this.circlingCenter.field_1351), (int)(z = this.circlingCenter.field_1350 + Math.sin(this.circlingAngle) * radius));
        if (!this.isPositionSafe(testPos)) {
            for (int yOffset = -2; yOffset <= 3; ++yOffset) {
                class_2338 adjustedPos = testPos.method_10069(0, yOffset, 0);
                if (!this.isPositionSafe(adjustedPos)) continue;
                y = adjustedPos.method_10264();
                break;
            }
        }
        return new class_243(x, y, z);
    }

    public void method_6091(class_243 movementInput) {
        if (this.getBoreState() == BoreState.BURROWING && this.isWalkingWhileBurrowed) {
            class_243 currentPos = this.method_73189();
            class_243 targetPos = currentPos.method_1019(movementInput);
            class_2338 currentBlock = class_2338.method_49638((class_2374)currentPos);
            class_2338 targetBlock = class_2338.method_49638((class_2374)targetPos);
            if (targetBlock.method_10264() < currentBlock.method_10264()) {
                this.method_18800(0.0, 0.0, 0.0);
                return;
            }
            class_243 flatMovement = new class_243(movementInput.field_1352, 0.0, movementInput.field_1350);
            super.method_6091(flatMovement);
            return;
        }
        super.method_6091(movementInput);
    }

    private double findGroundLevel(double x, double z) {
        class_2338 aboveAbove;
        class_2338 abovePos;
        class_2338 checkPos;
        int y;
        if (this.method_73183() == null) {
            return -1.0;
        }
        int blockX = (int)Math.floor(x);
        int blockZ = (int)Math.floor(z);
        int startY = (int)this.method_23318();
        int topY = this.method_73183().method_31607() + this.method_73183().method_31605() - 1;
        for (y = startY; y >= this.method_73183().method_31607(); --y) {
            checkPos = new class_2338(blockX, y, blockZ);
            abovePos = checkPos.method_10084();
            if (!this.method_73183().method_8320(checkPos).method_26212((class_1922)this.method_73183(), checkPos) || this.method_73183().method_8320(abovePos).method_26212((class_1922)this.method_73183(), abovePos) && !this.method_73183().method_22347(abovePos)) continue;
            aboveAbove = abovePos.method_10084();
            if (this.method_73183().method_8320(aboveAbove).method_26212((class_1922)this.method_73183(), aboveAbove) && !this.method_73183().method_22347(aboveAbove)) continue;
            return (double)y + 1.0;
        }
        for (y = startY + 1; y <= topY - 2; ++y) {
            checkPos = new class_2338(blockX, y, blockZ);
            abovePos = checkPos.method_10084();
            if (!this.method_73183().method_8320(checkPos).method_26212((class_1922)this.method_73183(), checkPos) || this.method_73183().method_8320(abovePos).method_26212((class_1922)this.method_73183(), abovePos) && !this.method_73183().method_22347(abovePos)) continue;
            aboveAbove = abovePos.method_10084();
            if (this.method_73183().method_8320(aboveAbove).method_26212((class_1922)this.method_73183(), aboveAbove) && !this.method_73183().method_22347(aboveAbove)) continue;
            return (double)y + 1.0;
        }
        return -1.0;
    }

    protected float method_6106() {
        if (this.boreState == BoreState.BURROWING) {
            return 0.0f;
        }
        return super.method_6106();
    }

    public boolean method_6101() {
        return super.method_6101() && this.boreState != BoreState.BURROWING;
    }

    public void updateCirclingAngle() {
        double angularSpeed = 0.05;
        this.circlingAngle += (double)this.circlingDirection * angularSpeed;
        while (this.circlingAngle > Math.PI * 2) {
            this.circlingAngle -= Math.PI * 2;
        }
        while (this.circlingAngle < 0.0) {
            this.circlingAngle += Math.PI * 2;
        }
    }

    public boolean isInCombat() {
        return this.isInCombat;
    }

    public int getCombatDuration() {
        return this.isInCombat ? this.field_6012 - this.combatStartTime : 0;
    }

    private boolean isNearbyProjectileDangerous() {
        if (this.method_73183() == null) {
            return false;
        }
        try {
            List projectiles = this.method_73183().method_8390(EarthChargeProjectileEntity.class, this.method_5829().method_1014(6.0), projectile -> projectile != null && projectile.method_24921() != this);
            return !projectiles.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isNearFriendlyProjectile() {
        if (this.method_73183() == null) {
            return false;
        }
        try {
            List friendlyProjectiles = this.method_73183().method_8390(EarthChargeProjectileEntity.class, this.method_5829().method_1014(8.0), projectile -> projectile != null && projectile.method_24921() instanceof BoreEntity && projectile.method_24921() != this);
            return !friendlyProjectiles.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private class_243 getProjectileAvoidanceDirection() {
        if (this.method_73183() == null) {
            return null;
        }
        try {
            List projectiles = this.method_73183().method_8390(EarthChargeProjectileEntity.class, this.method_5829().method_1014(Math.max(6.0, 8.0)), projectile -> projectile != null && projectile.method_24921() != this);
            if (projectiles.isEmpty()) {
                return null;
            }
            class_243 avoidanceDirection = class_243.field_1353;
            for (EarthChargeProjectileEntity projectile2 : projectiles) {
                if (projectile2 == null || projectile2.method_73189() == null) continue;
                class_243 directionAway = this.method_73189().method_1020(projectile2.method_73189()).method_1029();
                double weight = projectile2.method_24921() instanceof BoreEntity ? 1.5 : 1.0;
                avoidanceDirection = avoidanceDirection.method_1019(directionAway.method_1021(weight));
            }
            return avoidanceDirection.method_1029();
        }
        catch (Exception e) {
            return null;
        }
    }

    private int countNearbyShootingAllies() {
        if (this.method_73183() == null) {
            return 0;
        }
        try {
            List nearbyAllies = this.method_73183().method_8390(BoreEntity.class, this.method_5829().method_1014(16.0), bore -> bore != null && bore != this && bore.method_5805() && !bore.method_31481());
            int shootingCount = 0;
            for (BoreEntity ally : nearbyAllies) {
                if (!((double)this.method_5739((class_1297)ally) <= 16.0) || ally.getBoreState() != BoreState.SHOOTING && ally.shootCooldown <= 45) continue;
                ++shootingCount;
            }
            return shootingCount;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public class_2338 getRelocationTarget() {
        return this.relocateTarget;
    }

    public void clearRelocationTarget() {
        this.relocateTarget = null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    public BoreState getBoreState() {
        return this.boreState;
    }

    public BoreState getPreviousState() {
        return this.previousState;
    }

    public void setBoreState(BoreState newState) {
        if (this.boreState != newState && !this.isChangingState) {
            if (!this.isValidStateTransition(this.boreState, newState)) {
                return;
            }
            this.isChangingState = true;
            this.previousState = this.boreState;
            this.boreState = newState;
            this.animationTick = 0;
            this.stateTimer = 0;
            if (!this.method_73183().method_8608()) {
                this.field_6011.method_12778(DATA_ID_STATE, (Object)newState.ordinal());
            } else {
                this.startStateAnimation(newState);
            }
            if (newState == BoreState.IDLE && this.previousState == BoreState.UNBURROWING) {
                this.burrowAnimPlayed = false;
                this.whileburrowAnimPlayed = false;
            }
            this.isChangingState = false;
        }
    }

    private void startStateAnimation(BoreState state) {
        if (!this.method_73183().method_8608() || this.animationStartedThisTick) {
            return;
        }
        this.animationStartedThisTick = true;
        switch (state.ordinal()) {
            case 0: {
                if (this.previousState == BoreState.UNBURROWING) {
                    this.burrowingAnimationState.method_41325();
                    this.whileburrowingAnimationState.method_41325();
                    this.unburrowingAnimationState.method_41325();
                    this.burrowAnimPlayed = false;
                    this.whileburrowAnimPlayed = false;
                }
                if (this.previousState == BoreState.SHOOTING) {
                    this.shootingAnimationState.method_41325();
                }
                this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                this.idleAnimationState.method_41322(this.field_6012);
                this.isIdleAnimationRunning = true;
                break;
            }
            case 1: {
                this.stopAllAnimations();
                this.shootingAnimationState.method_41322(this.field_6012);
                this.isIdleAnimationRunning = false;
                break;
            }
            case 2: {
                this.idleAnimationState.method_41325();
                this.shootingAnimationState.method_41325();
                this.unburrowingAnimationState.method_41325();
                if (!this.burrowAnimPlayed) {
                    this.burrowingAnimationState.method_41322(this.field_6012);
                    this.burrowAnimPlayed = true;
                }
                this.isIdleAnimationRunning = false;
                break;
            }
            case 3: {
                this.whileburrowingAnimationState.method_41325();
                this.burrowingAnimationState.method_41325();
                this.idleAnimationState.method_41325();
                this.shootingAnimationState.method_41325();
                this.unburrowingAnimationState.method_41322(this.field_6012);
                this.isIdleAnimationRunning = false;
            }
        }
    }

    private boolean isValidStateTransition(BoreState from, BoreState to) {
        switch (from.ordinal()) {
            case 0: {
                return to == BoreState.SHOOTING || to == BoreState.BURROWING;
            }
            case 1: {
                return to == BoreState.IDLE;
            }
            case 2: {
                return to == BoreState.UNBURROWING;
            }
            case 3: {
                return to == BoreState.IDLE;
            }
        }
        return false;
    }

    private boolean isPathBlocked(class_243 targetPos) {
        if (this.method_73183() == null || targetPos == null) {
            return true;
        }
        class_243 currentPos = this.method_73189();
        class_243 direction = targetPos.method_1020(currentPos).method_1029();
        for (double step = 1.0; step <= 3.0; step += 0.5) {
            class_243 checkPos = currentPos.method_1019(direction.method_1021(step));
            class_2338 blockPos = new class_2338((int)checkPos.field_1352, (int)checkPos.field_1351, (int)checkPos.field_1350);
            if (!this.method_73183().method_8320(blockPos).method_26212((class_1922)this.method_73183(), blockPos) && !this.method_73183().method_8320(blockPos.method_10084()).method_26212((class_1922)this.method_73183(), blockPos.method_10084())) continue;
            return true;
        }
        return false;
    }

    private class_2338 findAlternativeBurrowDestination() {
        double currentY = this.method_23318();
        for (int attempts = 0; attempts < 24; ++attempts) {
            double angle = Math.PI * 2 * (double)attempts / 24.0;
            double distance = 8.0 + this.field_5974.method_43058() * 4.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            class_2338 targetPos = new class_2338((int)(this.method_23317() + offsetX), (int)currentY, (int)(this.method_23321() + offsetZ));
            if (!this.isPositionSafeForBurrowing(targetPos) || this.isPathBlocked(new class_243((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260()))) continue;
            return targetPos;
        }
        return null;
    }

    private void stopAllAnimations() {
        if (this.method_73183().method_8608()) {
            this.idleAnimationState.method_41325();
            this.shootingAnimationState.method_41325();
            this.burrowingAnimationState.method_41325();
            this.whileburrowingAnimationState.method_41325();
            this.unburrowingAnimationState.method_41325();
        }
    }

    public boolean canShoot() {
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return false;
        }
        if (this.boreState == BoreState.BURROWING || this.boreState == BoreState.UNBURROWING) {
            return false;
        }
        try {
            double distance = this.method_5739((class_1297)target);
            if (distance < 4.0) {
                return false;
            }
            if (!this.hasMovedEnoughToShoot || this.isNearbyProjectileDangerous()) {
                return false;
            }
            if (this.isNearFriendlyProjectile()) {
                return false;
            }
            if (this.isStuckInSmallArea() && distance < 6.0) {
                return false;
            }
            return this.shootingDelay <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void tryShootAtPlayer() {
        if (this.shootCooldown > 0 || !this.canShoot()) {
            return;
        }
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return;
        }
        int nearbyShooters = this.method_73183().method_8390(BoreEntity.class, this.method_5829().method_1014(16.0), bore -> bore != this && bore.getBoreState() == BoreState.SHOOTING).size();
        if (nearbyShooters >= 2) {
            return;
        }
        this.method_73183().method_8390(BoreEntity.class, this.method_5829().method_1014(8.0), bore -> bore != this && bore.isInCombat()).forEach(ally -> {
            class_243 away = ally.method_73189().method_1020(this.method_73189()).method_1029();
            ally.method_5942().method_6337(ally.method_23317() + away.field_1352 * 6.0, ally.method_23318(), ally.method_23321() + away.field_1350 * 6.0, 1.4);
        });
        this.shootCooldown = 40 + this.field_5974.method_43048(20);
        this.setBoreState(BoreState.SHOOTING);
        this.lastShootPosition = this.method_73189();
        this.hasMovedEnoughToShoot = false;
        this.shootingDelay = 5 + this.field_5974.method_43048(10);
    }

    public void startBurrowing() {
        if (this.boreState == BoreState.IDLE && !this.isWalkingWhileBurrowed) {
            boolean canBurrow = false;
            for (int quickCheck = 0; quickCheck < 8; ++quickCheck) {
                double angle = Math.PI * 2 * (double)quickCheck / 8.0;
                double distance = 6.0 + this.field_5974.method_43058() * 4.0;
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                class_2338 testPos = new class_2338((int)(this.method_23317() + offsetX), (int)this.method_23318(), (int)(this.method_23321() + offsetZ));
                if (!this.isPositionSafeForBurrowing(testPos)) continue;
                canBurrow = true;
                break;
            }
            if (canBurrow) {
                this.setBoreState(BoreState.BURROWING);
            }
        }
    }

    private void fireEarthCharge() {
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return;
        }
        class_243 targetPos = this.predictTargetPosition(target);
        if (targetPos == null) {
            return;
        }
        class_243 direction = targetPos.method_1020(this.method_73189()).method_1029();
        try {
            EarthChargeProjectileEntity charge = new EarthChargeProjectileEntity(this.method_73183(), (class_1309)this);
            charge.method_5814(this.method_23317(), this.method_23320(), this.method_23321());
            charge.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, 1.2f, 0.05f);
            this.method_73183().method_8649((class_1297)charge);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class_243 predictTargetPosition(class_1309 target) {
        if (target == null || !target.method_5805() || target.method_31481()) {
            return this.method_73189();
        }
        try {
            class_243 targetVelocity = target.method_18798();
            if (targetVelocity == null) {
                targetVelocity = class_243.field_1353;
            }
            double projectileSpeed = 1.2;
            double distance = this.method_5739((class_1297)target);
            double timeToHit = distance / projectileSpeed;
            class_243 predictedPos = target.method_73189().method_1019(targetVelocity.method_1021(timeToHit));
            return predictedPos.method_1031(0.0, (double)target.method_5751() - 1.0, 0.0);
        }
        catch (Exception e) {
            return target.method_73189();
        }
    }

    public String getCurrentAnimation() {
        switch (this.boreState.ordinal()) {
            case 0: {
                return "BORE_IDLE";
            }
            case 1: {
                return "BORE_SHOOTING";
            }
            case 2: {
                return "BORE_BURROWING";
            }
            case 3: {
                return "BORE_UNBURROWING";
            }
        }
        return "BORE_IDLE";
    }

    private int getTypeVariant() {
        return (Integer)this.field_6011.method_12789(DATA_ID_TYPE_VARIANT);
    }

    public BoreVariant getVariant() {
        return BoreVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setVariant(BoreVariant variant) {
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean isDarkVariant() {
        return this.getVariant() == BoreVariant.DARK;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        BoreVariant variant = world.method_8409().method_43057() < 0.005f ? BoreVariant.DARK : BoreVariant.NORMAL;
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71469("BoreState", this.boreState.name());
        nbt.method_71465("StateTimer", this.stateTimer);
        nbt.method_71465("Variant", this.getTypeVariant());
        nbt.method_71472("HasMovedEnoughToShoot", this.hasMovedEnoughToShoot);
        nbt.method_71472("IsInCombat", this.isInCombat);
        nbt.method_71465("CombatStartTime", this.combatStartTime);
        nbt.method_71463("CirclingAngle", this.circlingAngle);
        nbt.method_71465("CirclingDirection", this.circlingDirection);
        nbt.method_71465("ShootingDelay", this.shootingDelay);
        nbt.method_71465("StuckTimer", this.stuckTimer);
        nbt.method_71465("BurrowCooldownTimer", this.burrowCooldownTimer);
        if (this.stuckCheckPosition != null) {
            nbt.method_71463("StuckCheckX", this.stuckCheckPosition.field_1352);
            nbt.method_71463("StuckCheckY", this.stuckCheckPosition.field_1351);
            nbt.method_71463("StuckCheckZ", this.stuckCheckPosition.field_1350);
        }
        if (this.relocateTarget != null) {
            nbt.method_71466("RelocateTarget", this.relocateTarget.method_10063());
        }
        if (this.lastShootPosition != null) {
            nbt.method_71463("LastShootX", this.lastShootPosition.field_1352);
            nbt.method_71463("LastShootY", this.lastShootPosition.field_1351);
            nbt.method_71463("LastShootZ", this.lastShootPosition.field_1350);
        }
        if (this.circlingCenter != null) {
            nbt.method_71463("CirclingCenterX", this.circlingCenter.field_1352);
            nbt.method_71463("CirclingCenterY", this.circlingCenter.field_1351);
            nbt.method_71463("CirclingCenterZ", this.circlingCenter.field_1350);
        }
    }

    public void method_5749(class_11368 nbt) {
        double circlingCenterX;
        double lastShootX;
        long relocateTargetLong;
        super.method_5749(nbt);
        String stateString = nbt.method_71428("BoreState", "IDLE");
        if (!stateString.equals("IDLE")) {
            try {
                BoreState loadedState;
                this.boreState = loadedState = BoreState.valueOf(stateString);
                if (!this.method_73183().method_8608()) {
                    this.field_6011.method_12778(DATA_ID_STATE, (Object)loadedState.ordinal());
                }
            }
            catch (IllegalArgumentException e) {
                this.boreState = BoreState.IDLE;
            }
        }
        this.stateTimer = nbt.method_71424("StateTimer", 0);
        this.field_6011.method_12778(DATA_ID_TYPE_VARIANT, (Object)nbt.method_71424("Variant", 0));
        this.hasMovedEnoughToShoot = nbt.method_71433("HasMovedEnoughToShoot", false);
        this.isInCombat = nbt.method_71433("IsInCombat", false);
        this.combatStartTime = nbt.method_71424("CombatStartTime", 0);
        this.circlingAngle = nbt.method_71422("CirclingAngle", 0.0);
        this.circlingDirection = nbt.method_71424("CirclingDirection", 1);
        this.shootingDelay = nbt.method_71424("ShootingDelay", 0);
        this.stuckTimer = nbt.method_71424("StuckTimer", 0);
        this.burrowCooldownTimer = nbt.method_71424("BurrowCooldownTimer", 0);
        double stuckCheckX = nbt.method_71422("StuckCheckX", Double.NaN);
        if (!Double.isNaN(stuckCheckX)) {
            this.stuckCheckPosition = new class_243(stuckCheckX, nbt.method_71422("StuckCheckY", 0.0), nbt.method_71422("StuckCheckZ", 0.0));
        }
        if ((relocateTargetLong = nbt.method_71425("RelocateTarget", Long.MIN_VALUE)) != Long.MIN_VALUE) {
            this.relocateTarget = class_2338.method_10092((long)relocateTargetLong);
        }
        if (!Double.isNaN(lastShootX = nbt.method_71422("LastShootX", Double.NaN))) {
            this.lastShootPosition = new class_243(lastShootX, nbt.method_71422("LastShootY", 0.0), nbt.method_71422("LastShootZ", 0.0));
        }
        if (!Double.isNaN(circlingCenterX = nbt.method_71422("CirclingCenterX", Double.NaN))) {
            this.circlingCenter = new class_243(circlingCenterX, nbt.method_71422("CirclingCenterY", 0.0), nbt.method_71422("CirclingCenterZ", 0.0));
        }
    }

    private void syncStateToClients() {
        if (!this.method_73183().method_8608()) {
            this.field_6011.method_12778(DATA_ID_STATE, (Object)this.boreState.ordinal());
        }
    }

    public void method_5674(class_2940<?> data) {
        BoreState newState;
        if (DATA_ID_STATE.equals(data) && this.method_73183().method_8608() && this.boreState != (newState = BoreState.values()[(Integer)this.field_6011.method_12789(DATA_ID_STATE)]) && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.boreState;
            this.boreState = newState;
            this.animationTick = 0;
            this.stateTimer = 0;
            this.startStateAnimation(newState);
            this.isChangingState = false;
        }
        super.method_5674(data);
    }

    private void addBurrowParticles(class_7094 animationState) {
        class_2680 blockState;
        if (this.method_73183().method_8608() && animationState.method_41327() && (blockState = this.method_25936()).method_26217() != class_2464.field_11455) {
            class_5819 random = this.method_59922();
            for (int i = 0; i < 7; ++i) {
                double d = this.method_23317() + (double)class_3532.method_32750((class_5819)random, (float)-0.3f, (float)0.3f);
                double e = this.method_23318();
                double f = this.method_23321() + (double)class_3532.method_32750((class_5819)random, (float)-0.3f, (float)0.3f);
                this.method_73183().method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public static enum BoreState {
        IDLE,
        SHOOTING,
        BURROWING,
        UNBURROWING;

    }

    private static class BoreAvoidProjectileGoal
    extends class_1352 {
        private final BoreEntity bore;
        private class_243 avoidanceDirection;

        public BoreAvoidProjectileGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.bore.getBoreState() != BoreState.IDLE) {
                return false;
            }
            this.avoidanceDirection = this.bore.getProjectileAvoidanceDirection();
            return this.avoidanceDirection != null;
        }

        public void method_6268() {
            if (this.avoidanceDirection != null) {
                class_243 targetPos = this.bore.method_73189().method_1019(this.avoidanceDirection.method_1021(6.0));
                this.bore.method_5942().method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.5);
            }
        }

        public boolean method_6266() {
            return (this.bore.isNearbyProjectileDangerous() || this.bore.isNearFriendlyProjectile()) && this.bore.getBoreState() == BoreState.IDLE;
        }
    }

    private static class BoreBurrowingMovementGoal
    extends class_1352 {
        private final BoreEntity bore;
        private int stuckCounter = 0;
        private class_243 lastPosition = null;
        private int forceMovementTimer = 0;

        public BoreBurrowingMovementGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.bore.getBoreState() == BoreState.BURROWING && this.bore.isWalkingWhileBurrowed && this.bore.burrowDestination != null;
        }

        public void method_6269() {
            this.stuckCounter = 0;
            this.forceMovementTimer = 0;
            this.lastPosition = this.bore.method_73189();
        }

        public void method_6268() {
            if (this.bore.burrowDestination != null) {
                double currentY = this.bore.method_23318();
                double moveSpeed = this.bore.isInCombat() && this.bore.method_5968() != null ? 1.2 : 1.4;
                class_243 currentPos = this.bore.method_73189();
                if (this.lastPosition != null && currentPos.method_1022(this.lastPosition) < 0.1) {
                    class_2338 alternative;
                    ++this.stuckCounter;
                    ++this.forceMovementTimer;
                    if (this.stuckCounter > 10 && (alternative = this.bore.findAlternativeBurrowDestination()) != null) {
                        if (alternative.method_10264() < this.bore.method_31478()) {
                            this.bore.forceUnburrow();
                            return;
                        }
                        this.bore.burrowDestination = alternative;
                        this.bore.method_5942().method_6340();
                        this.bore.method_5942().method_6337((double)alternative.method_10263(), currentY, (double)alternative.method_10260(), moveSpeed);
                        this.stuckCounter = 0;
                        this.forceMovementTimer = 0;
                    }
                    if (this.forceMovementTimer > 5 && this.bore.burrowDestination != null) {
                        class_243 direction = new class_243((double)this.bore.burrowDestination.method_10263(), currentY, (double)this.bore.burrowDestination.method_10260()).method_1020(currentPos).method_1029();
                        class_243 forceMovement = direction.method_1021(0.15);
                        this.bore.method_18799(this.bore.method_18798().method_1019(forceMovement));
                        this.forceMovementTimer = 0;
                    }
                } else {
                    this.stuckCounter = 0;
                    this.forceMovementTimer = 0;
                }
                this.lastPosition = currentPos;
                if (this.bore.method_5942().method_6357()) {
                    if (this.bore.burrowDestination.method_10264() < this.bore.method_31478()) {
                        this.bore.forceUnburrow();
                        return;
                    }
                    this.bore.method_5942().method_6337((double)this.bore.burrowDestination.method_10263(), currentY, (double)this.bore.burrowDestination.method_10260(), moveSpeed);
                }
            }
        }

        public boolean method_6266() {
            return this.bore.getBoreState() == BoreState.BURROWING && this.bore.isWalkingWhileBurrowed && this.bore.burrowDestination != null;
        }
    }

    private static class BoreShootGoal
    extends class_1352 {
        private final BoreEntity bore;
        private int aimTimer = 0;

        public BoreShootGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.bore.method_5968();
            return target != null && this.bore.shootCooldown <= 0 && this.bore.canShoot() && (double)this.bore.method_5739((class_1297)target) >= 4.0 && this.bore.method_5739((class_1297)target) <= 16.0f && this.bore.getBoreState() == BoreState.IDLE && this.bore.getCombatDuration() >= 40;
        }

        public void method_6269() {
            this.aimTimer = 15;
        }

        public void method_6268() {
            class_1309 target = this.bore.method_5968();
            if (target != null && target.method_5805() && !target.method_31481()) {
                try {
                    this.bore.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                    if (--this.aimTimer <= 0) {
                        this.bore.tryShootAtPlayer();
                        this.aimTimer = 60;
                    }
                }
                catch (Exception e) {
                    this.aimTimer = 60;
                }
            }
        }

        public boolean method_6266() {
            class_1309 target = this.bore.method_5968();
            return target != null && this.bore.getBoreState() != BoreState.SHOOTING && (double)this.bore.method_5739((class_1297)target) >= 4.0 && this.bore.method_5739((class_1297)target) <= 16.0f;
        }

        public void method_6270() {
            this.aimTimer = 0;
        }
    }

    private static class BoreCircleGoal
    extends class_1352 {
        private final BoreEntity bore;
        private class_243 targetPosition;
        private int repositionTimer = 0;

        public BoreCircleGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 target = this.bore.method_5968();
            return this.bore.isInCombat() && target != null && target.method_5805() && !target.method_31481() && this.bore.getBoreState() == BoreState.IDLE && this.bore.getCombatDuration() < 120;
        }

        public void method_6269() {
            this.targetPosition = this.bore.getCirclingPosition();
            this.repositionTimer = 0;
        }

        public void method_6268() {
            class_1309 target;
            ++this.repositionTimer;
            this.bore.updateCirclingAngle();
            if (this.repositionTimer >= 10 || this.targetPosition != null && this.bore.method_5707(this.targetPosition) < 2.0) {
                this.targetPosition = this.bore.getCirclingPosition();
                this.repositionTimer = 0;
            }
            if (this.targetPosition != null) {
                this.bore.method_5942().method_6337(this.targetPosition.field_1352, this.targetPosition.field_1351, this.targetPosition.field_1350, 1.2);
            }
            if ((target = this.bore.method_5968()) != null && target.method_5805() && !target.method_31481()) {
                try {
                    this.bore.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean method_6266() {
            class_1309 target = this.bore.method_5968();
            return this.bore.isInCombat() && target != null && target.method_5805() && !target.method_31481() && this.bore.getBoreState() == BoreState.IDLE && this.bore.getCombatDuration() < 120;
        }
    }

    private static class BoreRelocateGoal
    extends class_1352 {
        private final BoreEntity bore;

        public BoreRelocateGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.bore.getRelocationTarget() != null && this.bore.getBoreState() == BoreState.IDLE;
        }

        public boolean method_6266() {
            class_2338 target = this.bore.getRelocationTarget();
            return target != null && this.bore.method_5649(target.method_10263(), target.method_10264(), target.method_10260()) > 4.0;
        }

        public void method_6268() {
            class_2338 target = this.bore.getRelocationTarget();
            if (target != null) {
                this.bore.method_5942().method_6337((double)target.method_10263(), (double)target.method_10264(), (double)target.method_10260(), 1.0);
            }
        }

        public void method_6270() {
            this.bore.clearRelocationTarget();
        }
    }

    private static class BoreFleeGoal
    extends class_1338<class_1657> {
        private final BoreEntity bore;

        public BoreFleeGoal(BoreEntity bore) {
            super((class_1314)bore, class_1657.class, 6.0f, 1.2, 1.5);
            this.bore = bore;
        }

        public boolean method_6264() {
            class_1309 target = this.bore.method_5968();
            return super.method_6264() && this.bore.getBoreState() != BoreState.SHOOTING && this.bore.getBoreState() != BoreState.BURROWING && this.bore.getBoreState() != BoreState.UNBURROWING && target != null && target.method_5805() && !target.method_31481() && (double)this.bore.method_5739((class_1297)target) < 4.0 && (this.bore.burrowCooldown > 0 || this.bore.burrowCooldownTimer > 0);
        }
    }

    private static class BoreSmartPositioningGoal
    extends class_1352 {
        private final BoreEntity bore;
        private class_243 optimalPosition;

        public BoreSmartPositioningGoal(BoreEntity bore) {
            this.bore = bore;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 target = this.bore.method_5968();
            if (target == null || target.method_31481() || !target.method_5805() || this.bore.getBoreState() != BoreState.IDLE) {
                return false;
            }
            try {
                double distance = this.bore.method_5739((class_1297)target);
                if (distance < 6.0 || distance > 12.0) {
                    this.optimalPosition = this.findOptimalPosition(target);
                    return this.optimalPosition != null;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        private class_243 findOptimalPosition(class_1309 target) {
            if (target == null || target.method_31481() || !target.method_5805()) {
                return null;
            }
            try {
                class_243 targetPos = target.method_73189();
                if (targetPos == null) {
                    return null;
                }
                double optimalDistance = 8.0;
                for (int attempts = 0; attempts < 8; ++attempts) {
                    double z;
                    double angle = Math.PI * 2 * (double)attempts / 8.0;
                    double x = targetPos.field_1352 + Math.cos(angle) * optimalDistance;
                    class_2338 testPos = new class_2338((int)x, (int)targetPos.field_1351, (int)(z = targetPos.field_1350 + Math.sin(angle) * optimalDistance));
                    if (!this.bore.isPositionSafe(testPos)) continue;
                    return new class_243(x, targetPos.field_1351, z);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public void method_6268() {
            if (this.optimalPosition != null) {
                this.bore.method_5942().method_6337(this.optimalPosition.field_1352, this.optimalPosition.field_1351, this.optimalPosition.field_1350, 1.0);
            }
        }

        public boolean method_6266() {
            return this.optimalPosition != null && this.bore.method_5707(this.optimalPosition) > 4.0 && this.bore.getBoreState() == BoreState.IDLE;
        }
    }

    public static enum BoreVariant {
        NORMAL(0),
        DARK(1);

        private final int id;

        private BoreVariant(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static BoreVariant byId(int id) {
            for (BoreVariant variant : BoreVariant.values()) {
                if (variant.getId() != id) continue;
                return variant;
            }
            return NORMAL;
        }
    }
}

