/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.entity.brine;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.entity.brine.BrineNavigation;
import potatowolfie.earth_and_water.entity.custom.HostileWaterCreatureEntity;
import potatowolfie.earth_and_water.entity.water_charge.WaterChargeProjectileEntity;
import potatowolfie.earth_and_water.sound.ModSounds;

public class BrineEntity
extends HostileWaterCreatureEntity {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 underwaterAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private boolean isIdleAnimationRunning = false;
    private boolean isUnderwaterAnimationRunning = false;
    private boolean isAttackAnimationRunning = false;
    private boolean animationStartedThisTick = false;
    private int shootingDelay = 0;
    private int shootingStateTimer = 0;
    private static final double PROJECTILE_DANGER_RADIUS = 6.0;
    private static final double FRIENDLY_PROJECTILE_AVOIDANCE_RADIUS = 8.0;
    private int shootCooldown = 0;
    private class_243 lastShootPosition = null;
    private boolean hasMovedEnoughToShoot = true;
    private class_2338 homePos = null;
    private static final int MAX_DISTANCE_FROM_HOME = 30;
    private static final class_2940<Integer> DATA_ID_STATE = class_2945.method_12791(BrineEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> MOVING = class_2945.method_12791(BrineEntity.class, (class_2941)class_2943.field_13323);
    private BrineState brineState = BrineState.UNDERWATER_IDLE;
    private BrineState previousState = BrineState.UNDERWATER_IDLE;
    private boolean isChangingState = false;

    public BrineEntity(class_1299<? extends BrineEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new BrineHybridMoveControl(this);
    }

    public static class_5132.class_5133 createBrineAttributes() {
        return class_1480.method_26828().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23719, (double)0.23f);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new BrineAvoidProjectileGoal(this));
        this.field_6201.method_6277(1, (class_1352)new BrineSeekWaterGoal(this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new BrineHybridSwimGoal(this, 1.25));
        this.field_6201.method_6277(3, (class_1352)new BrineShootGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 1.0, 80));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
    }

    protected class_3414 method_6002() {
        return this.field_5957 ? ModSounds.BRINE_UNDERWATER_DEATH : ModSounds.BRINE_DEATH;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.field_5957 ? ModSounds.BRINE_UNDERWATER_DEATH : ModSounds.BRINE_DEATH;
    }

    protected class_3414 method_5994() {
        return this.field_5957 ? ModSounds.BRINE_UNDERWATER_AMBIENT : ModSounds.BRINE_AMBIENT;
    }

    public void setHomePosition(class_2338 pos) {
        this.homePos = pos;
    }

    private boolean isWithinHomeBounds(class_2338 pos) {
        if (this.homePos == null) {
            return true;
        }
        return this.homePos.method_19771((class_2382)pos, 30.0);
    }

    private boolean isWithinHomeBounds(class_243 pos) {
        if (this.homePos == null) {
            return true;
        }
        return this.homePos.method_19769((class_2374)pos, 30.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        return new BrineNavigation((class_1308)this, world);
    }

    public static boolean canSpawn(class_1299<BrineEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8316(pos).method_15767(class_3486.field_15517);
    }

    public boolean isMoving() {
        return (Boolean)this.field_6011.method_12789(MOVING);
    }

    void setMoving(boolean moving) {
        this.field_6011.method_12778(MOVING, (Object)moving);
    }

    private void updateAnimations() {
        if (this.method_73183().method_8608()) {
            if (this.brineState == BrineState.SHOOTING) {
                if (!this.isAttackAnimationRunning) {
                    this.attackAnimationState.method_41322(this.field_6012);
                    this.isAttackAnimationRunning = true;
                    this.isIdleAnimationRunning = false;
                    this.isUnderwaterAnimationRunning = false;
                }
            } else if (this.brineState == BrineState.IDLE) {
                if (!this.isIdleAnimationRunning) {
                    --this.idleAnimationTimeout;
                    if (this.idleAnimationTimeout <= 0) {
                        this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                        this.idleAnimationState.method_41322(this.field_6012);
                        this.isIdleAnimationRunning = true;
                        this.isAttackAnimationRunning = false;
                        this.isUnderwaterAnimationRunning = false;
                    }
                }
            } else if (this.brineState == BrineState.UNDERWATER_IDLE && !this.isUnderwaterAnimationRunning) {
                this.underwaterAnimationState.method_41322(this.field_6012);
                this.isUnderwaterAnimationRunning = true;
                this.isIdleAnimationRunning = false;
                this.isAttackAnimationRunning = false;
            }
            if (this.brineState != BrineState.IDLE && this.isIdleAnimationRunning) {
                this.idleAnimationState.method_41325();
                this.isIdleAnimationRunning = false;
                this.idleAnimationTimeout = 0;
            }
            if (this.brineState != BrineState.UNDERWATER_IDLE && this.isUnderwaterAnimationRunning) {
                this.underwaterAnimationState.method_41325();
                this.isUnderwaterAnimationRunning = false;
            }
            if (this.brineState != BrineState.SHOOTING && this.isAttackAnimationRunning) {
                this.attackAnimationState.method_41325();
                this.isAttackAnimationRunning = false;
            }
        }
    }

    public BrineState getBrineState() {
        return this.brineState;
    }

    public BrineState getPreviousState() {
        return this.previousState;
    }

    public void setBrineState(BrineState newState) {
        if (this.brineState != newState && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.brineState;
            this.brineState = newState;
            if (!this.method_73183().method_8608()) {
                this.field_6011.method_12778(DATA_ID_STATE, (Object)newState.ordinal());
            } else {
                this.startStateAnimation(newState);
            }
            this.isChangingState = false;
        }
    }

    private void startStateAnimation(BrineState state) {
        if (!this.method_73183().method_8608() || this.animationStartedThisTick) {
            return;
        }
        this.animationStartedThisTick = true;
        switch (state.ordinal()) {
            case 0: {
                this.stopAllAnimations();
                this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                this.idleAnimationState.method_41322(this.field_6012);
                this.isIdleAnimationRunning = true;
                this.isUnderwaterAnimationRunning = false;
                this.isAttackAnimationRunning = false;
                break;
            }
            case 1: {
                this.stopAllAnimations();
                this.underwaterAnimationState.method_41322(this.field_6012);
                this.isUnderwaterAnimationRunning = true;
                this.isIdleAnimationRunning = false;
                this.isAttackAnimationRunning = false;
                break;
            }
            case 2: {
                this.stopAllAnimations();
                this.attackAnimationState.method_41322(this.field_6012);
                this.isAttackAnimationRunning = true;
                this.isIdleAnimationRunning = false;
                this.isUnderwaterAnimationRunning = false;
            }
        }
    }

    private void stopAllAnimations() {
        if (this.method_73183().method_8608()) {
            this.idleAnimationState.method_41325();
            this.underwaterAnimationState.method_41325();
            this.attackAnimationState.method_41325();
        }
    }

    public void method_5674(class_2940<?> data) {
        BrineState newState;
        if (DATA_ID_STATE.equals(data) && this.method_73183().method_8608() && this.brineState != (newState = BrineState.values()[(Integer)this.field_6011.method_12789(DATA_ID_STATE)]) && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.brineState;
            this.brineState = newState;
            this.startStateAnimation(newState);
            this.isChangingState = false;
        }
        super.method_5674(data);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_ID_STATE, (Object)BrineState.UNDERWATER_IDLE.ordinal());
        builder.method_56912(MOVING, (Object)false);
    }

    @Override
    public boolean method_5675() {
        return false;
    }

    @Override
    public boolean method_5931() {
        return false;
    }

    @Override
    public int method_5748() {
        return 300;
    }

    @Override
    protected int method_6130(int air) {
        return this.method_5748();
    }

    @Override
    protected int method_6064(int air) {
        return this.method_5748();
    }

    public boolean canBreatheFluids() {
        return true;
    }

    @Override
    public void method_5670() {
        int maxAir = this.method_5748();
        if (this.method_5669() < maxAir) {
            this.method_5855(maxAir);
        }
        super.method_5670();
    }

    @Override
    protected int getXpToDrop() {
        return 8 + this.field_5974.method_43048(5);
    }

    @Override
    public boolean shouldDropXp() {
        return true;
    }

    public void method_5773() {
        if (this.method_31481() || this.method_73183() == null) {
            return;
        }
        this.animationStartedThisTick = false;
        super.method_5773();
        if (this.shootCooldown > 0) {
            --this.shootCooldown;
        }
        if (this.shootingDelay > 0) {
            --this.shootingDelay;
        }
        if (this.getBrineState() == BrineState.SHOOTING) {
            ++this.shootingStateTimer;
            if (this.shootingStateTimer == 20 && !this.method_73183().method_8608()) {
                this.fireWaterCharge();
            }
            if (this.shootingStateTimer >= 40) {
                this.setBrineState(this.isFullySubmerged() ? BrineState.UNDERWATER_IDLE : BrineState.IDLE);
                this.shootingStateTimer = 0;
            }
        } else {
            this.shootingStateTimer = 0;
        }
        try {
            this.updateMovementTracking();
            this.updateAnimations();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5799()) {
            this.method_5855(300);
        }
        if (this.method_5777(class_3486.field_15517) || this.field_5957) {
            this.handleUnderwaterAnimationState();
        } else {
            this.handleOutOfWaterAnimationState();
        }
    }

    private void handleUnderwaterAnimationState() {
        if (this.isFullySubmerged()) {
            if (this.brineState != BrineState.UNDERWATER_IDLE && this.brineState != BrineState.SHOOTING) {
                this.setBrineState(BrineState.UNDERWATER_IDLE);
            }
        } else if (this.brineState != BrineState.IDLE && this.brineState != BrineState.SHOOTING) {
            this.setBrineState(BrineState.IDLE);
        }
    }

    private void handleOutOfWaterAnimationState() {
        if (this.brineState != BrineState.IDLE) {
            this.setBrineState(BrineState.IDLE);
        }
    }

    @Override
    public void method_6091(class_243 movementInput) {
        if (this.isFullySubmerged()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (!this.isMoving() && this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.003, 0.0));
            }
        } else if (this.method_5799()) {
            this.method_5724(0.1f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.8));
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean isKelpCovered() {
        return true;
    }

    public float getLeftVisionAngle() {
        return this.method_36454() - 90.0f;
    }

    private void updateMovementTracking() {
        double distanceMoved;
        class_243 currentPos;
        if (this.lastShootPosition != null && (currentPos = this.method_73189()) != null && (distanceMoved = currentPos.method_1022(this.lastShootPosition)) >= 4.0) {
            this.hasMovedEnoughToShoot = true;
        }
    }

    private boolean isNearbyProjectileDangerous() {
        if (this.method_73183() == null) {
            return false;
        }
        try {
            List projectiles = this.method_73183().method_8390(WaterChargeProjectileEntity.class, this.method_5829().method_1014(6.0), projectile -> projectile != null && projectile.method_24921() != this);
            return !projectiles.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isNearFriendlyProjectile() {
        if (this.method_73183() == null) {
            return false;
        }
        try {
            List friendlyProjectiles = this.method_73183().method_8390(WaterChargeProjectileEntity.class, this.method_5829().method_1014(8.0), projectile -> projectile != null && projectile.method_24921() instanceof BrineEntity && projectile.method_24921() != this);
            return !friendlyProjectiles.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private class_243 getProjectileAvoidanceDirection() {
        if (this.method_73183() == null) {
            return null;
        }
        try {
            List projectiles = this.method_73183().method_8390(WaterChargeProjectileEntity.class, this.method_5829().method_1014(Math.max(6.0, 8.0)), projectile -> projectile != null && projectile.method_24921() != this);
            if (projectiles.isEmpty()) {
                return null;
            }
            class_243 avoidanceDirection = class_243.field_1353;
            for (WaterChargeProjectileEntity projectile2 : projectiles) {
                if (projectile2 == null || projectile2.method_73189() == null) continue;
                class_243 directionAway = this.method_73189().method_1020(projectile2.method_73189()).method_1029();
                double weight = projectile2.method_24921() instanceof BrineEntity ? 1.5 : 1.0;
                avoidanceDirection = avoidanceDirection.method_1019(directionAway.method_1021(weight));
            }
            return avoidanceDirection.method_1029();
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean canShoot() {
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return false;
        }
        if (!this.isFullySubmerged()) {
            return false;
        }
        if (this.brineState == BrineState.SHOOTING) {
            return false;
        }
        try {
            double distance = this.method_5739((class_1297)target);
            if (distance < 4.0 || distance > 16.0) {
                return false;
            }
            if (!this.hasMovedEnoughToShoot || this.isNearbyProjectileDangerous()) {
                return false;
            }
            if (this.isNearFriendlyProjectile()) {
                return false;
            }
            return this.shootingDelay <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void tryShootAtTarget() {
        if (this.shootCooldown > 0 || !this.canShoot()) {
            return;
        }
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return;
        }
        this.shootCooldown = 40 + this.field_5974.method_43048(20);
        this.setBrineState(BrineState.SHOOTING);
        this.lastShootPosition = this.method_73189();
        this.hasMovedEnoughToShoot = false;
        this.shootingDelay = 5 + this.field_5974.method_43048(10);
    }

    private void fireWaterCharge() {
        class_1309 target = this.method_5968();
        if (target == null || !target.method_5805() || target.method_31481()) {
            return;
        }
        class_243 targetPos = this.predictTargetPosition(target);
        if (targetPos == null) {
            return;
        }
        class_243 direction = targetPos.method_1020(this.method_73189()).method_1029();
        try {
            WaterChargeProjectileEntity charge = new WaterChargeProjectileEntity(ModEntities.WATER_CHARGE, this.method_73183());
            charge.method_7432((class_1297)this);
            charge.method_5814(this.method_23317(), this.method_23320(), this.method_23321());
            charge.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, 1.2f, 0.05f);
            this.method_73183().method_8649((class_1297)charge);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class_243 predictTargetPosition(class_1309 target) {
        if (target == null || !target.method_5805() || target.method_31481()) {
            return this.method_73189();
        }
        try {
            class_243 targetVelocity = target.method_18798();
            if (targetVelocity == null) {
                targetVelocity = class_243.field_1353;
            }
            double projectileSpeed = 1.2;
            double distance = this.method_5739((class_1297)target);
            double timeToHit = distance / projectileSpeed;
            class_243 predictedPos = target.method_73189().method_1019(targetVelocity.method_1021(timeToHit));
            return predictedPos.method_1031(0.0, (double)target.method_5751() - 1.0, 0.0);
        }
        catch (Exception e) {
            return target.method_73189();
        }
    }

    @Override
    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71469("BrineState", this.brineState.name());
        nbt.method_71472("HasMovedEnoughToShoot", this.hasMovedEnoughToShoot);
        nbt.method_71465("ShootingDelay", this.shootingDelay);
        nbt.method_71465("ShootCooldown", this.shootCooldown);
        if (this.lastShootPosition != null) {
            nbt.method_71463("LastShootX", this.lastShootPosition.field_1352);
            nbt.method_71463("LastShootY", this.lastShootPosition.field_1351);
            nbt.method_71463("LastShootZ", this.lastShootPosition.field_1350);
        }
        if (this.homePos != null) {
            nbt.method_71465("HomeX", this.homePos.method_10263());
            nbt.method_71465("HomeY", this.homePos.method_10264());
            nbt.method_71465("HomeZ", this.homePos.method_10260());
        }
    }

    @Override
    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
        String stateString = nbt.method_71428("BrineState", "UNDERWATER_IDLE");
        if (!stateString.equals("UNDERWATER_IDLE")) {
            try {
                BrineState loadedState;
                this.brineState = loadedState = BrineState.valueOf(stateString);
                if (!this.method_73183().method_8608()) {
                    this.field_6011.method_12778(DATA_ID_STATE, (Object)loadedState.ordinal());
                }
            }
            catch (IllegalArgumentException e) {
                this.brineState = BrineState.UNDERWATER_IDLE;
            }
        }
        this.hasMovedEnoughToShoot = nbt.method_71433("HasMovedEnoughToShoot", false);
        this.shootingDelay = nbt.method_71424("ShootingDelay", 0);
        this.shootCooldown = nbt.method_71424("ShootCooldown", 0);
        double lastShootX = nbt.method_71422("LastShootX", Double.NaN);
        if (!Double.isNaN(lastShootX)) {
            this.lastShootPosition = new class_243(lastShootX, nbt.method_71422("LastShootY", 0.0), nbt.method_71422("LastShootZ", 0.0));
        }
        if (nbt.contains("HomeX")) {
            this.homePos = new class_2338(nbt.method_71424("HomeX", 0), nbt.method_71424("HomeY", 0), nbt.method_71424("HomeZ", 0));
        }
    }

    public static enum BrineState {
        IDLE,
        UNDERWATER_IDLE,
        SHOOTING;

    }

    static class BrineHybridMoveControl
    extends class_1335 {
        private final BrineEntity brine;

        public BrineHybridMoveControl(BrineEntity brine) {
            super((class_1308)brine);
            this.brine = brine;
        }

        public void method_6240() {
            double dz;
            double dy;
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.brine.setMoving(false);
                this.brine.method_6125(0.0f);
                return;
            }
            double dx = this.field_6370 - this.brine.method_23317();
            double distanceSquared = dx * dx + (dy = this.field_6369 - this.brine.method_23318()) * dy + (dz = this.field_6367 - this.brine.method_23321()) * dz;
            if (distanceSquared < 0.25) {
                this.brine.method_6125(0.0f);
                this.brine.setMoving(false);
                return;
            }
            double distance = Math.sqrt(distanceSquared);
            float targetYaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
            this.brine.method_36456(this.method_6238(this.brine.method_36454(), targetYaw, 90.0f));
            this.brine.field_6283 = this.brine.method_36454();
            float baseSpeed = (float)(this.field_6372 * this.brine.method_45325(class_5134.field_23719));
            float lerpedSpeed = class_3532.method_16439((float)0.125f, (float)this.brine.method_6029(), (float)baseSpeed);
            this.brine.method_6125(lerpedSpeed);
            if (this.brine.isFullySubmerged()) {
                double nx = dx / distance;
                double ny = dy / distance;
                double nz = dz / distance;
                double wave1 = Math.sin((double)(this.brine.field_6012 + this.brine.method_5628()) * 0.5) * 0.05;
                double wave2 = Math.sin((double)(this.brine.field_6012 + this.brine.method_5628()) * 0.75) * 0.05;
                double yawCos = Math.cos(this.brine.method_36454() * ((float)Math.PI / 180));
                double yawSin = Math.sin(this.brine.method_36454() * ((float)Math.PI / 180));
                class_243 currentVel = this.brine.method_18798();
                this.brine.method_18799(currentVel.method_1031(nx * (double)baseSpeed * 0.1 + wave1 * yawCos, ny * (double)baseSpeed * 0.1 + wave2 * (yawSin + yawCos) * 0.25, nz * (double)baseSpeed * 0.1 + wave1 * yawSin));
                this.brine.method_5988().method_6230(this.field_6370, this.field_6369, this.field_6367, 10.0f, 40.0f);
                this.brine.setMoving(true);
            } else {
                this.brine.method_5930(lerpedSpeed);
                this.brine.setMoving(true);
            }
        }
    }

    private static class BrineAvoidProjectileGoal
    extends class_1352 {
        private final BrineEntity brine;
        private class_243 avoidanceDirection;

        public BrineAvoidProjectileGoal(BrineEntity brine) {
            this.brine = brine;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.brine.getBrineState() != BrineState.UNDERWATER_IDLE && this.brine.getBrineState() != BrineState.IDLE) {
                return false;
            }
            this.avoidanceDirection = this.brine.getProjectileAvoidanceDirection();
            return this.avoidanceDirection != null;
        }

        public void method_6268() {
            if (this.avoidanceDirection != null) {
                class_243 targetPos = this.brine.method_73189().method_1019(this.avoidanceDirection.method_1021(6.0));
                this.brine.method_5962().method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.5);
            }
        }

        public boolean method_6266() {
            return !(!this.brine.isNearbyProjectileDangerous() && !this.brine.isNearFriendlyProjectile() || this.brine.getBrineState() != BrineState.UNDERWATER_IDLE && this.brine.getBrineState() != BrineState.IDLE);
        }
    }

    public static class BrineSeekWaterGoal
    extends class_1352 {
        private final BrineEntity brine;
        private final double speed;
        private class_2338 targetWaterPos;

        public BrineSeekWaterGoal(BrineEntity brine, double speed) {
            this.brine = brine;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.brine.method_5799()) {
                return false;
            }
            this.targetWaterPos = this.findDeepWater();
            return this.targetWaterPos != null;
        }

        public boolean method_6266() {
            return !this.brine.method_5799() && this.targetWaterPos != null && !this.brine.method_5942().method_6357();
        }

        public void method_6269() {
            if (this.targetWaterPos != null) {
                this.brine.method_5942().method_6337((double)this.targetWaterPos.method_10263() + 0.5, (double)this.targetWaterPos.method_10264() + 0.5, (double)this.targetWaterPos.method_10260() + 0.5, this.speed);
            }
        }

        public void method_6270() {
            this.targetWaterPos = null;
        }

        private class_2338 findDeepWater() {
            class_2338 entityPos = this.brine.method_24515();
            int searchRange = 16;
            for (int range = 4; range <= searchRange; range += 4) {
                for (int x = -range; x <= range; x += 2) {
                    for (int y = -8; y <= 8; y += 2) {
                        for (int z = -range; z <= range; z += 2) {
                            class_2338 checkPos = entityPos.method_10069(x, y, z);
                            if (!this.isDeepWater(checkPos)) continue;
                            return checkPos;
                        }
                    }
                }
            }
            return null;
        }

        private boolean isDeepWater(class_2338 pos) {
            class_1937 world = this.brine.method_73183();
            return world.method_8316(pos).method_15767(class_3486.field_15517) && world.method_8316(pos.method_10084()).method_15767(class_3486.field_15517);
        }
    }

    public static class BrineHybridSwimGoal
    extends class_1352 {
        private final BrineEntity brine;
        private final double speed;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int retargetTimer;
        private boolean usingVelocityMode;

        public BrineHybridSwimGoal(BrineEntity brine, double speed) {
            this.brine = brine;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!this.brine.method_5799() || this.brine.method_5968() != null) {
                return false;
            }
            return this.brine.method_59922().method_43048(40) == 0;
        }

        public boolean method_6266() {
            return this.brine.method_5799() && this.retargetTimer > 0;
        }

        public void method_6269() {
            this.pickNewTarget();
            this.retargetTimer = 200;
        }

        public void method_6270() {
            this.retargetTimer = 0;
            this.brine.method_5962().method_6239(this.brine.method_23317(), this.brine.method_23318(), this.brine.method_23321(), this.speed);
        }

        public void method_6268() {
            boolean nowFullySubmerged;
            --this.retargetTimer;
            double distSq = this.brine.method_5649(this.targetX, this.targetY, this.targetZ);
            if (distSq < 2.0 || this.retargetTimer <= 0 || this.retargetTimer % 80 == 0) {
                this.pickNewTarget();
                this.retargetTimer = 200;
            }
            if ((nowFullySubmerged = this.brine.isFullySubmerged()) != this.usingVelocityMode) {
                this.usingVelocityMode = nowFullySubmerged;
                this.applyMovement();
            }
        }

        private void pickNewTarget() {
            class_243 pos = this.brine.method_73189();
            int range = 15;
            for (int i = 0; i < 30; ++i) {
                class_2338 testPos;
                double ox = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0;
                double oy = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0;
                double oz = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0;
                double px = pos.field_1352 + ox;
                double py = pos.field_1351 + oy;
                double pz = pos.field_1350 + oz;
                if (ox * ox + oy * oy + oz * oz < 49.0 || !this.brine.isWithinHomeBounds(testPos = new class_2338((int)px, (int)py, (int)pz)) || !this.brine.method_73183().method_8316(testPos).method_15767(class_3486.field_15517)) continue;
                this.targetX = px;
                this.targetY = py;
                this.targetZ = pz;
                this.usingVelocityMode = this.brine.isFullySubmerged();
                this.applyMovement();
                return;
            }
        }

        private void applyMovement() {
            if (this.usingVelocityMode) {
                this.brine.method_5962().method_6239(this.targetX, this.targetY, this.targetZ, this.speed);
            } else {
                this.brine.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
            }
        }
    }

    private static class BrineShootGoal
    extends class_1352 {
        private final BrineEntity brine;
        private int aimTimer = 0;

        public BrineShootGoal(BrineEntity brine) {
            this.brine = brine;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 target = this.brine.method_5968();
            return target != null && this.brine.shootCooldown <= 0 && this.brine.canShoot() && (double)this.brine.method_5739((class_1297)target) >= 4.0 && this.brine.method_5739((class_1297)target) <= 16.0f && (this.brine.getBrineState() == BrineState.UNDERWATER_IDLE || this.brine.getBrineState() == BrineState.IDLE);
        }

        public void method_6269() {
            this.aimTimer = 15;
        }

        public void method_6268() {
            class_1309 target = this.brine.method_5968();
            if (target != null && target.method_5805() && !target.method_31481() && this.brine.getBrineState() != BrineState.SHOOTING) {
                try {
                    this.brine.method_5988().method_20248(target.method_23317(), target.method_23320(), target.method_23321());
                    if (--this.aimTimer <= 0) {
                        this.brine.tryShootAtTarget();
                        this.aimTimer = 60;
                    }
                }
                catch (Exception e) {
                    this.aimTimer = 60;
                }
            }
        }

        public boolean method_6266() {
            class_1309 target = this.brine.method_5968();
            return target != null && this.brine.getBrineState() != BrineState.SHOOTING && (double)this.brine.method_5739((class_1297)target) >= 4.0 && this.brine.method_5739((class_1297)target) <= 16.0f;
        }

        public void method_6270() {
            this.aimTimer = 0;
        }
    }

    static class BrineMoveControl
    extends class_1335 {
        private final BrineEntity brine;

        public BrineMoveControl(BrineEntity brine) {
            super((class_1308)brine);
            this.brine = brine;
        }

        public void method_6240() {
            if (this.brine.isFullySubmerged() && this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - this.brine.method_23317(), this.field_6369 - this.brine.method_23318(), this.field_6367 - this.brine.method_23321());
                double d = vec3d.method_1033();
                if (d < 0.5) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    this.brine.setMoving(false);
                    return;
                }
                double e = vec3d.field_1352 / d;
                double f = vec3d.field_1351 / d;
                double g = vec3d.field_1350 / d;
                float h = (float)(class_3532.method_15349((double)vec3d.field_1350, (double)vec3d.field_1352) * 57.2957763671875) - 90.0f;
                this.brine.method_36456(this.method_6238(this.brine.method_36454(), h, 90.0f));
                this.brine.field_6283 = this.brine.method_36454();
                float i = (float)(this.field_6372 * this.brine.method_45325(class_5134.field_23719));
                float j = class_3532.method_16439((float)0.125f, (float)this.brine.method_6029(), (float)i);
                this.brine.method_6125(j);
                double k = Math.sin((double)(this.brine.field_6012 + this.brine.method_5628()) * 0.5) * 0.05;
                double l = Math.cos(this.brine.method_36454() * ((float)Math.PI / 180));
                double m = Math.sin(this.brine.method_36454() * ((float)Math.PI / 180));
                double n = Math.sin((double)(this.brine.field_6012 + this.brine.method_5628()) * 0.75) * 0.05;
                this.brine.method_18799(this.brine.method_18798().method_1031(k * l, n * (m + l) * 0.25 + (double)j * f * 0.1, k * m));
                class_1333 lookControl = this.brine.method_5988();
                double o = this.brine.method_23317() + e * 2.0;
                double p = this.brine.method_23320() + f / d;
                double q = this.brine.method_23321() + g * 2.0;
                double r = lookControl.method_6225();
                double s = lookControl.method_6227();
                double t = lookControl.method_6228();
                if (!lookControl.method_38970()) {
                    r = o;
                    s = p;
                    t = q;
                }
                this.brine.method_5988().method_6230(class_3532.method_16436((double)0.125, (double)r, (double)o), class_3532.method_16436((double)0.125, (double)s, (double)p), class_3532.method_16436((double)0.125, (double)t, (double)q), 10.0f, 40.0f);
                this.brine.setMoving(true);
            } else {
                super.method_6240();
                if (this.field_6374 == class_1335.class_1336.field_6378) {
                    this.brine.setMoving(true);
                } else {
                    this.brine.setMoving(false);
                }
            }
        }
    }

    public static class BrineSwimInWaterGoal
    extends class_1352 {
        private final BrineEntity brine;
        private final double speed;
        private final int chance;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int ticksSinceLastTarget = 0;

        public BrineSwimInWaterGoal(BrineEntity brine, double speed, int chance) {
            this.brine = brine;
            this.speed = speed;
            this.chance = chance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.brine.method_5782() || this.brine.method_5968() != null) {
                return false;
            }
            if (this.brine.method_59922().method_43048(this.chance) != 0) {
                return false;
            }
            return this.brine.method_5799();
        }

        public void method_6269() {
            this.chooseWaterTarget();
            this.ticksSinceLastTarget = 0;
        }

        public boolean method_6266() {
            return this.brine.method_5799();
        }

        public void method_6270() {
            if (!this.brine.isFullySubmerged()) {
                this.brine.method_5942().method_6340();
            }
        }

        public void method_6268() {
            ++this.ticksSinceLastTarget;
            if (this.ticksSinceLastTarget >= 150 || this.brine.method_5649(this.targetX, this.targetY, this.targetZ) < 1.0) {
                this.chooseWaterTarget();
                this.ticksSinceLastTarget = 0;
            }
        }

        private void chooseWaterTarget() {
            class_243 currentPos = this.brine.method_73189();
            int range = 15;
            int minDistance = 7;
            for (int attempts = 0; attempts < 50; ++attempts) {
                class_2338 checkPos;
                double offsetZ;
                double potentialZ;
                double dz;
                double offsetY;
                double potentialY;
                double dy;
                double offsetX = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0;
                double potentialX = currentPos.field_1352 + offsetX;
                double dx = potentialX - currentPos.field_1352;
                double distanceSquared = dx * dx + (dy = (potentialY = currentPos.field_1351 + (offsetY = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0)) - currentPos.field_1351) * dy + (dz = (potentialZ = currentPos.field_1350 + (offsetZ = (this.brine.method_59922().method_43058() - 0.5) * (double)range * 2.0)) - currentPos.field_1350) * dz;
                if (distanceSquared < (double)(minDistance * minDistance) || !this.brine.isWithinHomeBounds(checkPos = new class_2338((int)potentialX, (int)potentialY, (int)potentialZ)) || !this.brine.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) continue;
                this.targetX = potentialX;
                this.targetY = potentialY;
                this.targetZ = potentialZ;
                if (this.brine.isFullySubmerged()) {
                    this.brine.method_5962().method_6239(this.targetX, this.targetY, this.targetZ, this.speed);
                } else {
                    this.brine.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
                }
                return;
            }
            this.targetX = currentPos.field_1352;
            this.targetY = currentPos.field_1351;
            this.targetZ = currentPos.field_1350;
        }
    }
}

