/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.entity.custom;

import java.util.EnumSet;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7;

public abstract class HostileWaterCreatureEntity
extends class_1588 {
    protected HostileWaterCreatureEntity(class_1299<? extends HostileWaterCreatureEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new class_1335((class_1308)this);
    }

    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public int method_5970() {
        return 120;
    }

    protected int getXpToDrop() {
        return 1 + this.method_73183().field_9229.method_43048(3);
    }

    public int method_5748() {
        return 300;
    }

    protected int method_6130(int air) {
        return this.method_5748();
    }

    protected int method_6064(int air) {
        return this.method_5748();
    }

    protected void tickWaterBreathingAir(int air) {
        this.method_5855(this.method_5748());
    }

    public void method_5670() {
        int i = this.method_5669();
        super.method_5670();
        this.tickWaterBreathingAir(i);
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5931() {
        return false;
    }

    private boolean hasAI() {
        return !this.method_5987() && this.method_73183().method_8407() != class_1267.field_5801;
    }

    public void method_6091(class_243 movementInput) {
        if (this.hasAI() && this.method_5799()) {
            this.method_5724(this.method_6029(), movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null && this.method_5942().method_6357()) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    public boolean shouldSwim() {
        return this.method_5799() && this.method_18798().method_1027() > 1.0E-4;
    }

    public abstract boolean shouldDropXp();

    public boolean isFullySubmerged() {
        double entityHeight = this.method_17682();
        class_243 pos = this.method_73189();
        boolean bottomSubmerged = this.method_73183().method_8316(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350)).method_15767(class_3486.field_15517);
        boolean middleSubmerged = this.method_73183().method_8316(new class_2338((int)pos.field_1352, (int)(pos.field_1351 + entityHeight * 0.5), (int)pos.field_1350)).method_15767(class_3486.field_15517);
        boolean topSubmerged = this.method_73183().method_8316(new class_2338((int)pos.field_1352, (int)(pos.field_1351 + entityHeight), (int)pos.field_1350)).method_15767(class_3486.field_15517);
        return bottomSubmerged && middleSubmerged && topSubmerged;
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
    }

    public void method_5749(class_11368 nbt) {
        super.method_5749(nbt);
    }

    public static boolean canSpawn(class_1299<? extends HostileWaterCreatureEntity> type, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8316(pos).method_15767(class_3486.field_15517) && world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && world.method_8316(pos.method_10084()).method_15767(class_3486.field_15517) && world.method_8407() != class_1267.field_5801;
    }

    public boolean method_26319(class_3610 state) {
        return false;
    }

    public boolean method_5681() {
        return this.shouldSwim();
    }

    public static class BrineSwimGoal
    extends class_1352 {
        private final HostileWaterCreatureEntity entity;

        public BrineSwimGoal(HostileWaterCreatureEntity entity) {
            this.entity = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return true;
        }

        public boolean method_6266() {
            return true;
        }

        public void method_6268() {
            class_2338 waterPos;
            class_2338 targetPos;
            if (this.entity.method_5968() != null) {
                return;
            }
            if (this.entity.field_6012 % 80 == 0 && (targetPos = this.findRandomWaterBlock()) != null) {
                this.entity.method_5942().method_6337((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5, 1.0);
            }
            if (!this.entity.method_5799() && this.entity.field_6012 % 20 == 0 && (waterPos = this.findNearbyWater()) != null) {
                this.entity.method_5942().method_6337((double)waterPos.method_10263() + 0.5, (double)waterPos.method_10264() + 0.5, (double)waterPos.method_10260() + 0.5, 1.5);
            }
        }

        private class_2338 findRandomWaterBlock() {
            class_2338 entityPos = this.entity.method_24515();
            for (int attempt = 0; attempt < 30; ++attempt) {
                int offsetZ;
                int offsetY;
                int offsetX = this.entity.method_59922().method_43048(15) - 7;
                class_2338 testPos = entityPos.method_10069(offsetX, offsetY = this.entity.method_59922().method_43048(15) - 7, offsetZ = this.entity.method_59922().method_43048(15) - 7);
                if (!this.isDeepWater(testPos)) continue;
                return testPos;
            }
            return null;
        }

        private boolean isDeepWater(class_2338 pos) {
            return this.entity.method_73183().method_8316(pos).method_15767(class_3486.field_15517) && this.entity.method_73183().method_8316(pos.method_10084()).method_15767(class_3486.field_15517) && this.entity.method_73183().method_8316(pos.method_10086(2)).method_15767(class_3486.field_15517);
        }

        private class_2338 findNearbyWater() {
            class_2338 entityPos = this.entity.method_24515();
            for (int range = 4; range <= 16; range += 4) {
                for (int x = -range; x <= range; x += 2) {
                    for (int y = -8; y <= 8; y += 2) {
                        for (int z = -range; z <= range; z += 2) {
                            class_2338 testPos = entityPos.method_10069(x, y, z);
                            if (!this.entity.method_73183().method_8316(testPos).method_15767(class_3486.field_15517)) continue;
                            return testPos;
                        }
                    }
                }
            }
            return null;
        }
    }

    public static class SwimInWaterGoal
    extends class_1352 {
        private final HostileWaterCreatureEntity entity;
        private final double speed;
        private final int chance;
        private double targetX;
        private double targetY;
        private double targetZ;

        public SwimInWaterGoal(HostileWaterCreatureEntity entity, double speed, int chance) {
            this.entity = entity;
            this.speed = speed;
            this.chance = chance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.entity.method_5782() || this.entity.method_5968() != null) {
                return false;
            }
            if (this.entity.method_59922().method_43048(this.chance) != 0) {
                return false;
            }
            return this.entity.method_5799();
        }

        public void method_6269() {
            this.chooseWaterTarget();
        }

        public boolean method_6266() {
            return !this.entity.method_5942().method_6357() && this.entity.method_5799();
        }

        public void method_6270() {
            this.entity.method_5942().method_6340();
        }

        public void method_6268() {
            if (this.entity.method_59922().method_43048(150) == 0 || this.entity.method_5649(this.targetX, this.targetY, this.targetZ) < 1.0) {
                this.chooseWaterTarget();
            }
        }

        private void chooseWaterTarget() {
            class_243 currentPos = this.entity.method_73189();
            int range = 15;
            int minDistance = 8;
            for (int attempts = 0; attempts < 20; ++attempts) {
                double offsetZ;
                double potentialZ;
                double offsetY;
                double potentialY;
                double offsetX = (this.entity.method_59922().method_43058() - 0.5) * (double)range * 2.0;
                double potentialX = currentPos.field_1352 + offsetX;
                double distanceSquared = (potentialX - currentPos.field_1352) * (potentialX - currentPos.field_1352) + ((potentialY = currentPos.field_1351 + (offsetY = (this.entity.method_59922().method_43058() - 0.5) * (double)range * 2.0)) - currentPos.field_1351) * (potentialY - currentPos.field_1351) + ((potentialZ = currentPos.field_1350 + (offsetZ = (this.entity.method_59922().method_43058() - 0.5) * (double)range * 2.0)) - currentPos.field_1350) * (potentialZ - currentPos.field_1350);
                if (distanceSquared < (double)(minDistance * minDistance)) continue;
                class_2338 checkPos = new class_2338((int)potentialX, (int)potentialY, (int)potentialZ);
                if (!this.entity.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) continue;
                this.targetX = potentialX;
                this.targetY = potentialY;
                this.targetZ = potentialZ;
                this.entity.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
                return;
            }
            this.targetX = currentPos.field_1352;
            this.targetY = currentPos.field_1351;
            this.targetZ = currentPos.field_1350;
        }
    }

    public static class SeekWaterGoal
    extends class_1352 {
        private final HostileWaterCreatureEntity entity;
        private final double speed;
        private class_2338 targetWaterPos;

        public SeekWaterGoal(HostileWaterCreatureEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.entity.method_5799()) {
                return false;
            }
            this.targetWaterPos = this.findNearbyWater();
            return this.targetWaterPos != null;
        }

        public boolean method_6266() {
            return !this.entity.method_5799() && this.targetWaterPos != null && !this.entity.method_5942().method_6357();
        }

        public void method_6269() {
            if (this.targetWaterPos != null) {
                this.entity.method_5942().method_6337((double)this.targetWaterPos.method_10263(), (double)this.targetWaterPos.method_10264(), (double)this.targetWaterPos.method_10260(), this.speed);
            }
        }

        public void method_6270() {
            this.targetWaterPos = null;
        }

        private class_2338 findNearbyWater() {
            class_2338 entityPos = this.entity.method_24515();
            int searchRange = 16;
            for (int range = 4; range <= searchRange; range += 4) {
                for (int x = -range; x <= range; x += 2) {
                    for (int y = -8; y <= 8; y += 2) {
                        for (int z = -range; z <= range; z += 2) {
                            class_2338 checkPos = entityPos.method_10069(x, y, z);
                            if (!this.entity.method_73183().method_8316(checkPos).method_15767(class_3486.field_15517)) continue;
                            return checkPos;
                        }
                    }
                }
            }
            return null;
        }
    }
}

