/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.entity.earth_charge;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5611;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import potatowolfie.earth_and_water.damage.ModDamageTypes;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.item.ModItems;
import potatowolfie.earth_and_water.util.ExplosionUtil;

public class EarthChargeProjectileEntity
extends class_1665 {
    private float rotation;
    public class_5611 groundedOffset;
    private static final float DAMAGE_RADIUS = 1.5f;
    private static final float BASE_DAMAGE = 14.0f;
    private static final float KNOCKBACK_MULTIPLIER = 0.2f;

    public EarthChargeProjectileEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5875(false);
    }

    public EarthChargeProjectileEntity(class_1937 world, class_1657 player) {
        super(ModEntities.EARTH_CHARGE, (class_1309)player, world, new class_1799((class_1935)ModItems.EARTH_CHARGE), null);
        this.method_5814(player.method_23317(), player.method_23320() - 0.3, player.method_23321());
        this.method_36457(0.0f);
        this.method_36456(player.method_36454());
        class_243 velocity = player.method_5720().method_1021(1.0);
        this.method_5750(velocity);
        this.method_5875(false);
    }

    public EarthChargeProjectileEntity(class_1937 world, double x, double y, double z, class_243 vec3d) {
        super(ModEntities.EARTH_CHARGE, world);
        this.method_5814(x, y - 0.2, z);
        if (vec3d != null) {
            this.method_18799(vec3d);
        }
        this.method_5875(false);
    }

    public EarthChargeProjectileEntity(class_1937 world, class_1309 owner) {
        super(ModEntities.EARTH_CHARGE, world);
        this.method_24919((class_1297)owner, owner.method_36455(), owner.method_36454(), 0.0f, 1.0f, 1.0f);
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)ModItems.EARTH_CHARGE);
    }

    public float getRenderingRotation() {
        return 0.0f;
    }

    public boolean isGrounded() {
        return this.method_65059();
    }

    private void applyDirectHitDamage(class_1297 hitEntity) {
        if (hitEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)hitEntity;
            if (!this.method_73183().method_8608()) {
                class_243 knockbackDir;
                class_1937 class_19372 = this.method_73183();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1282 earthChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.EARTH_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
                    livingEntity.method_64397(serverWorld, earthChargeDamage, 12.0f);
                }
                if ((knockbackDir = hitEntity.method_73189().method_1020(this.method_73189()).method_1029()).method_1027() < 0.001) {
                    knockbackDir = new class_243(0.0, 1.0, 0.0);
                }
                double directKnockback = 0.7000000104308128;
                hitEntity.method_5762(knockbackDir.field_1352 * directKnockback, knockbackDir.field_1351 * directKnockback + 0.2, knockbackDir.field_1350 * directKnockback);
                hitEntity.field_64356 = true;
            }
        }
    }

    private void applyAreaDamageExcluding(class_1297 excludedEntity) {
        class_1937 world = this.method_73183();
        class_243 pos = this.method_73189();
        if (!world.method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_1282 earthChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.EARTH_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
            ExplosionUtil.createSilentExplosion(serverWorld, pos, 1.5f, (class_1297)this, excludedEntity, earthChargeDamage, 26.0f, 0.4f);
        }
    }

    private void createExplosionEffects() {
        class_1937 world = this.method_73183();
        class_243 pos = this.method_73189();
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_28033, class_3419.field_15245, 1.0f, 0.8f);
        if (!world.method_8608() && world instanceof class_3218) {
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            class_3218 serverWorld = (class_3218)world;
            class_1282 waterChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.WATER_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
            ExplosionUtil.createSilentExplosion(serverWorld, this.method_73189(), 3.0f, (class_1297)this, null, waterChargeDamage, 13.0f, 2.0f);
            for (i = 0; i < 6; ++i) {
                angle = (double)i * Math.PI / 3.0;
                distance = 0.2;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                serverWorld.method_65096((class_2394)class_2398.field_46763, pos.field_1352 + offsetX, pos.field_1351 + 0.03, pos.field_1350 + offsetZ, 5, 0.05, 0.02, 0.05, 0.15);
            }
            for (i = 0; i < 6; ++i) {
                angle = world.method_8409().method_43058() * Math.PI * 2.0;
                distance = 0.1 + world.method_8409().method_43058() * 0.25;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                serverWorld.method_65096((class_2394)class_2398.field_46763, pos.field_1352 + offsetX * 0.3, pos.field_1351 + 0.05, pos.field_1350 + offsetZ * 0.3, 3, 0.03, 0.02, 0.03, 0.3);
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 hitEntity = entityHitResult.method_17782();
        this.applyDirectHitDamage(hitEntity);
        this.applyAreaDamageExcluding(hitEntity);
        if (!this.method_73183().method_8608()) {
            this.createExplosionEffects();
            this.method_73183().method_8421((class_1297)this, (byte)3);
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 result) {
        switch (result.method_17780()) {
            case field_11035: {
                this.groundedOffset = new class_5611(215.0f, 180.0f);
                break;
            }
            case field_11043: {
                this.groundedOffset = new class_5611(215.0f, 0.0f);
                break;
            }
            case field_11034: {
                this.groundedOffset = new class_5611(215.0f, -90.0f);
                break;
            }
            case field_11039: {
                this.groundedOffset = new class_5611(215.0f, 90.0f);
                break;
            }
            case field_11033: {
                this.groundedOffset = new class_5611(115.0f, 180.0f);
                break;
            }
            case field_11036: {
                this.groundedOffset = new class_5611(285.0f, 180.0f);
            }
        }
        this.applyAreaDamageExcluding(null);
        if (!this.method_73183().method_8608()) {
            this.createExplosionEffects();
            this.method_73183().method_8421((class_1297)this, (byte)3);
            this.method_31472();
        }
    }

    public void method_5773() {
        double horizontalSpeed;
        class_243 velocity;
        double length;
        if (!this.method_73183().method_8608() && !this.method_31481() && this.method_5799()) {
            class_243 currentVelocity = this.method_18798();
            this.method_18799(currentVelocity.method_1021(0.9));
        }
        super.method_5773();
        if (!this.method_65059() && (length = (velocity = this.method_18798()).method_1033()) < 0.5 && (Math.abs(velocity.field_1352) > 0.01 || Math.abs(velocity.field_1350) > 0.01) && (horizontalSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)) < 0.5) {
            double factor = 0.5 / horizontalSpeed;
            this.method_18800(velocity.field_1352 * factor, velocity.field_1351, velocity.field_1350 * factor);
        }
        if (this.method_73183().method_8608() && !this.method_65059()) {
            this.method_73183().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public boolean method_5799() {
        return this.method_73183().method_22351(this.method_24515());
    }

    protected float method_7436() {
        return 0.8f;
    }

    protected double method_7490() {
        return 0.05f;
    }
}

