/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.entity.water_charge;

import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import potatowolfie.earth_and_water.damage.ModDamageTypes;
import potatowolfie.earth_and_water.effect.ModEffects;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.item.ModItems;
import potatowolfie.earth_and_water.util.ExplosionUtil;

public class WaterChargeProjectileEntity
extends class_1665 {
    boolean isStuck = false;
    private class_1297 attachedEntity = null;
    private class_2338 attachedBlock = null;
    private class_2350 attachedFace = null;
    private class_243 exactHitPosition = null;
    private int stuckTicks = -1;
    private static final int TICKS_TO_EXPLODE = 40;
    private float initialEntityYaw = 0.0f;
    private class_243 initialDirection = null;
    private static final float DIRECT_DAMAGE = 4.5f;
    private static final float INDIRECT_KNOCKBACK_RADIUS = 5.0f;
    private static final float KNOCKBACK_STRENGTH = 0.5f;
    private static final int BUBBLE_EFFECT_DURATION = 60;
    private static final float WATER_BREATHING_DURATION = 2.5f;
    private static final float EXPLOSION_DAMAGE_FACTOR = 1.5f;
    private static final float MAX_EXPLOSION_DAMAGE = 4.5f;
    private static final float EXPLOSION_KNOCKBACK_MULTIPLIER = 1.2f;
    private int bubbleEffectTimer = 0;
    private boolean isPerformingBubbleEffect = false;
    private boolean isDirectHit = false;

    public WaterChargeProjectileEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.method_7433(false);
        this.method_7438(0.0);
        this.method_5875(false);
    }

    public WaterChargeProjectileEntity(class_1937 world, class_1657 player) {
        super(ModEntities.WATER_CHARGE, (class_1309)player, world, new class_1799((class_1935)ModItems.WATER_CHARGE), null);
        this.method_5814(player.method_23317(), player.method_23320() - 0.3, player.method_23321());
        this.method_36457(player.method_36455());
        this.method_36456(player.method_36454());
        float pitch = player.method_36455() * ((float)Math.PI / 180);
        float yaw = player.method_36454() * ((float)Math.PI / 180);
        float x = -class_3532.method_15374((double)yaw) * class_3532.method_15362((double)pitch);
        float y = -class_3532.method_15374((double)pitch);
        float z = class_3532.method_15362((double)yaw) * class_3532.method_15362((double)pitch);
        this.initialDirection = new class_243((double)x, (double)y, (double)z).method_1029();
        float speed = 1.5f;
        this.method_18800(x * speed, y * speed, z * speed);
        this.method_7433(false);
        this.method_7438(0.0);
        this.method_5875(false);
    }

    public WaterChargeProjectileEntity(class_1937 world, double x, double y, double z, class_243 vec3d) {
        super(ModEntities.WATER_CHARGE, world);
        this.method_5814(x, y - 0.2, z);
        if (vec3d != null) {
            this.method_18799(vec3d);
            this.initialDirection = vec3d.method_1029();
        }
        this.method_7433(false);
        this.method_7438(0.0);
        this.method_5875(false);
    }

    protected class_1799 method_57314() {
        return new class_1799((class_1935)ModItems.WATER_CHARGE);
    }

    public float getRenderingRotation() {
        if (!this.isStuck && this.initialDirection != null) {
            return (float)Math.toDegrees(Math.atan2(this.initialDirection.field_1352, this.initialDirection.field_1350));
        }
        return 0.0f;
    }

    public boolean isGrounded() {
        return this.method_65059();
    }

    private boolean isReallyInWater() {
        class_2338 pos = this.method_24515();
        class_1937 world = this.method_73183();
        if (world.method_22351(pos)) {
            return true;
        }
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_22351(pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    private void restoreOxygen(class_1309 entity) {
        if (!this.method_73183().method_8608() && entity instanceof class_1657) {
            class_3218 serverWorld = (class_3218)this.method_73183();
            serverWorld.method_65096((class_2394)class_2398.field_11247, entity.method_23317(), entity.method_23318() + (double)entity.method_17682() * 0.5, entity.method_23321(), 10, 0.3, 0.3, 0.3, 0.1);
        }
    }

    private void createWaterExplosionEffects() {
        class_1937 world = this.method_73183();
        class_243 pos = this.method_73189();
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_28033, class_3419.field_15245, 1.0f, 0.8f);
        if (!world.method_8608() && world instanceof class_3218) {
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            class_3218 serverWorld = (class_3218)world;
            class_1282 waterChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.WATER_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
            ExplosionUtil.createSilentExplosion(serverWorld, this.method_73189(), 3.0f, (class_1297)this, null, waterChargeDamage, 13.0f, 2.0f);
            serverWorld.method_65096((class_2394)class_2398.field_11247, pos.field_1352, pos.field_1351 + 0.05, pos.field_1350, 20, 0.2, 0.05, 0.2, 0.1);
            for (i = 0; i < 6; ++i) {
                angle = (double)i * Math.PI / 3.0;
                distance = 0.2;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                serverWorld.method_65096((class_2394)class_2398.field_11247, pos.field_1352 + offsetX, pos.field_1351 + 0.03, pos.field_1350 + offsetZ, 10, 0.05, 0.02, 0.05, 0.15);
            }
            for (i = 0; i < 6; ++i) {
                angle = world.method_8409().method_43058() * Math.PI * 2.0;
                distance = 0.1 + world.method_8409().method_43058() * 0.25;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                serverWorld.method_65096((class_2394)class_2398.field_11247, pos.field_1352 + offsetX * 0.3, pos.field_1351 + 0.05, pos.field_1350 + offsetZ * 0.3, 7, 0.03, 0.02, 0.03, 0.3);
            }
            if (world.method_22351(this.method_24515())) {
                serverWorld.method_65096((class_2394)class_2398.field_11238, pos.field_1352, pos.field_1351, pos.field_1350, 17, 0.7, 0.7, 0.7, 0.2);
                serverWorld.method_65096((class_2394)class_2398.field_11241, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 10, 1.2, 0.8, 1.2, 0.05);
                world.method_8503().execute(() -> serverWorld.method_65096((class_2394)class_2398.field_11247, pos.field_1352, pos.field_1351, pos.field_1350, 15, 2.0, 1.2, 2.0, 0.05));
            }
            float effectRadius = 6.0f;
            class_238 affectBox = new class_238(pos.field_1352 - (double)effectRadius - 0.5, pos.field_1351 - (double)effectRadius - 0.5, pos.field_1350 - (double)effectRadius - 0.5, pos.field_1352 + (double)effectRadius + 0.5, pos.field_1351 + (double)effectRadius + 0.5, pos.field_1350 + (double)effectRadius + 0.5);
            List nearbyEntities = world.method_8390(class_1297.class, affectBox, entity -> entity != this && entity != this.method_24921());
            for (class_1297 entity2 : nearbyEntities) {
                double distance2 = entity2.method_73189().method_1022(pos);
                if (!(distance2 <= (double)effectRadius)) continue;
                float distanceFactor = (float)(1.0 - distance2 / (double)effectRadius);
                float explosionFactor = (float)Math.pow(distanceFactor, 2.5) * 1.2f;
                class_243 knockbackDir = entity2.method_73189().method_1020(pos).method_1029();
                float knockbackStrength = 0.5f * explosionFactor;
                double upwardForce = 0.2 + 0.3 * (double)explosionFactor;
                entity2.method_5762(knockbackDir.field_1352 * (double)knockbackStrength, knockbackDir.field_1351 * (double)knockbackStrength + upwardForce, knockbackDir.field_1350 * (double)knockbackStrength);
                entity2.field_64356 = true;
                if (!(entity2 instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity2;
                float damage = distanceFactor * 1.5f * 4.5f;
                if (!(damage > 0.5f) || !(world instanceof class_3218)) continue;
                new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.WATER_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
                livingEntity.method_64397(serverWorld, waterChargeDamage, damage);
                this.restoreOxygen(livingEntity);
            }
        }
        this.isPerformingBubbleEffect = true;
        this.bubbleEffectTimer = 60;
    }

    private void createWaterShockwave() {
        this.createWaterExplosionEffects();
    }

    private void createDirectHitEffect(class_1297 hitEntity) {
        class_1937 world = this.method_73183();
        class_243 pos = hitEntity.method_73189();
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_24066, class_3419.field_15254, 0.8f, 1.2f);
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14737, class_3419.field_15245, 1.0f, 1.2f);
        if (hitEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)hitEntity;
            float damage = 4.5f;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                class_1282 waterChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.WATER_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
                livingEntity.method_64397(serverWorld, waterChargeDamage, damage);
            }
            int durationTicks = 50;
            class_1293 breathEffect = new class_1293(ModEffects.BREATH_GIVING, durationTicks, 1);
            livingEntity.method_6092(breathEffect);
            this.restoreOxygen(livingEntity);
        }
        if (!world.method_8608() && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            float entityWidth = hitEntity.method_17681();
            float entityHeight = hitEntity.method_17682();
            float entitySize = (entityWidth + entityHeight) / 2.0f;
            class_243 explosionPos = this.exactHitPosition != null ? this.exactHitPosition : this.method_73189();
            serverWorld.method_65096((class_2394)class_2398.field_11247, explosionPos.field_1352, explosionPos.field_1351 + 0.05, explosionPos.field_1350, (int)(15.0f * Math.max(1.0f, entitySize)), 0.2, 0.05, 0.2, 0.1);
            for (int i = 0; i < 6; ++i) {
                double angle = (double)i * Math.PI / 3.0;
                double distance = 0.2 * (double)Math.max(1.0f, entitySize);
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                serverWorld.method_65096((class_2394)class_2398.field_11247, explosionPos.field_1352 + offsetX, explosionPos.field_1351 + 0.03, explosionPos.field_1350 + offsetZ, 7, 0.05, 0.02, 0.05, 0.15);
            }
        }
        this.isPerformingBubbleEffect = true;
        this.isDirectHit = true;
        this.bubbleEffectTimer = 60;
        this.attachedEntity = hitEntity;
    }

    private void spawnBubbleParticles() {
        class_1937 world = this.method_73183();
        if (!world.method_8608()) {
            return;
        }
        if (this.isDirectHit && this.attachedEntity != null) {
            class_243 entityPos = this.attachedEntity.method_73189();
            float entityHeight = this.attachedEntity.method_17682();
            float entityWidth = this.attachedEntity.method_17681();
            int spiralLayers = 3;
            float timeMultiplier = 0.1f;
            for (int layer = 0; layer < spiralLayers; ++layer) {
                double spiralRadius = (double)entityWidth * (1.2 + (double)layer * 0.4);
                double baseHeight = (float)layer * entityHeight / (float)(spiralLayers + 1);
                float rotationDirection = layer % 2 == 0 ? 1.0f : -1.0f;
                double baseAngle = (float)this.field_6012 * timeMultiplier * rotationDirection;
                int spiralsPerLayer = 2;
                for (int spiral = 0; spiral < spiralsPerLayer; ++spiral) {
                    double spiralOffset = (double)spiral * (Math.PI * 2 / (double)spiralsPerLayer);
                    int particlesPerSpiral = 10;
                    for (int i = 0; i < particlesPerSpiral; ++i) {
                        double progress = (double)i / (double)particlesPerSpiral;
                        double angle = baseAngle + spiralOffset + progress * Math.PI * 2.0;
                        double posX = entityPos.field_1352 + Math.sin(angle) * spiralRadius;
                        double posY = entityPos.field_1351 + baseHeight + progress * (double)entityHeight * 0.8;
                        double posZ = entityPos.field_1350 + Math.cos(angle) * spiralRadius;
                        double jitter = 0.05;
                        posX += (this.field_5974.method_43058() - 0.5) * jitter;
                        posY += (this.field_5974.method_43058() - 0.5) * jitter;
                        posZ += (this.field_5974.method_43058() - 0.5) * jitter;
                        double velX = Math.cos(angle) * 0.1 * (double)rotationDirection;
                        double velY = 0.05 + (double)layer * 0.02;
                        double velZ = -Math.sin(angle) * 0.1 * (double)rotationDirection;
                        if (i % 2 == 0) {
                            world.method_8406((class_2394)class_2398.field_11247, posX, posY, posZ, velX, velY, velZ);
                        }
                        if (this.field_5974.method_43048(15) != 0) continue;
                        world.method_8406((class_2394)class_2398.field_11241, posX, posY + 0.2, posZ, velX * 1.5, velY * 1.5, velZ * 1.5);
                    }
                }
            }
        } else {
            class_243 pos = this.exactHitPosition != null ? this.exactHitPosition : this.method_73189();
            float explosionProgress = 1.0f - (float)this.bubbleEffectTimer / 60.0f;
            if ((double)this.bubbleEffectTimer > 18.0) {
                for (int i = 0; i < 2; ++i) {
                    double randX = (this.field_5974.method_43058() - 0.5) * (double)explosionProgress * 6.0;
                    double randY = (this.field_5974.method_43058() - 0.5) * (double)explosionProgress * 6.0;
                    double randZ = (this.field_5974.method_43058() - 0.5) * (double)explosionProgress * 6.0;
                    if (this.field_5974.method_43048(2) != 0) continue;
                    world.method_8406((class_2394)class_2398.field_11241, pos.field_1352 + randX * 0.5, pos.field_1351 + randY * 0.5, pos.field_1350 + randZ * 0.5, randX * 0.1, 0.3, randZ * 0.1);
                }
            }
            int spiralLayers = 2;
            double maxRadius = 1.0 + (double)(60 - this.bubbleEffectTimer) / 60.0 * 5.0 * 0.4;
            for (int layer = 0; layer < spiralLayers; ++layer) {
                double layerRadius = maxRadius * (0.4 + 0.6 * ((double)layer / (double)spiralLayers));
                double baseHeight = -1.0 + (double)layer * 0.7;
                double heightRange = 2.0 + (double)layer * 0.3;
                double baseAngle = (double)this.field_6012 * (0.05 + (double)layer * 0.02) * (double)(layer % 2 == 0 ? 1 : -1);
                int spiralsPerLayer = 1 + layer;
                for (int spiral = 0; spiral < spiralsPerLayer; ++spiral) {
                    double spiralOffset = (double)spiral * (Math.PI * 2 / (double)spiralsPerLayer);
                    int pointsPerSpiral = 7;
                    for (int i = 0; i < pointsPerSpiral; ++i) {
                        double progress = (double)i / (double)pointsPerSpiral;
                        double angle = baseAngle + spiralOffset + progress * Math.PI * 4.0;
                        double currentRadius = layerRadius * (0.3 + 0.7 * progress);
                        double offsetX = Math.sin(angle) * currentRadius;
                        double offsetY = baseHeight + progress * heightRange;
                        double offsetZ = Math.cos(angle) * currentRadius;
                        double spiralTightness = 0.12;
                        double upwardSpeed = 0.2;
                        double velX = Math.cos(angle) * spiralTightness * (double)(layer % 2 == 0 ? -1 : 1);
                        double velY = upwardSpeed;
                        double velZ = -Math.sin(angle) * spiralTightness * (double)(layer % 2 == 0 ? -1 : 1);
                        double rand = 0.03 * (double)(layer + 1);
                        double randX = (this.field_5974.method_43058() - 0.5) * rand;
                        double randY = (this.field_5974.method_43058() - 0.5) * rand;
                        double randZ = (this.field_5974.method_43058() - 0.5) * rand;
                        if (i % 2 == 0) {
                            world.method_8406((class_2394)class_2398.field_11247, pos.field_1352 + offsetX + randX, pos.field_1351 + offsetY + randY, pos.field_1350 + offsetZ + randZ, velX, velY, velZ);
                        }
                        if (this.field_5974.method_43048(20) != 0) continue;
                        world.method_8406((class_2394)class_2398.field_11241, pos.field_1352 + offsetX + randX, pos.field_1351 + offsetY + randY + 0.2, pos.field_1350 + offsetZ + randZ, velX * 1.5, velY * 1.5, velZ * 1.5);
                    }
                }
            }
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        if (entity instanceof class_1542 || !entity.method_5805()) {
            return;
        }
        if (!this.isReallyInWater()) {
            this.spawnAsItem();
            return;
        }
        this.exactHitPosition = entityHitResult.method_17784();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1937 class_19372 = this.method_73183();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_1282 waterChargeDamage = new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.WATER_CHARGE.method_29177()).get(), (class_1297)this, this.method_24921());
                livingEntity.method_64397(serverWorld, waterChargeDamage, 4.5f);
            }
            int durationTicks = 50;
            class_1293 breathEffect = new class_1293(ModEffects.BREATH_GIVING, durationTicks, 1);
            livingEntity.method_6092(breathEffect);
            this.restoreOxygen(livingEntity);
        }
        this.createWaterExplosionEffects();
        this.method_73183().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_24066, class_3419.field_15245, 1.0f, 1.2f);
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        if (!this.isReallyInWater()) {
            this.spawnAsItem();
            return;
        }
        class_243 hitPos = result.method_17784();
        class_2350 face = result.method_17780();
        double embedOffset = 0.05;
        class_243 embeddedPos = hitPos.method_1031((double)face.method_10148() * embedOffset, (double)face.method_10164() * embedOffset, (double)face.method_10165() * embedOffset);
        this.method_23327(embeddedPos.field_1352, embeddedPos.field_1351, embeddedPos.field_1350);
        this.method_18799(class_243.field_1353);
        this.method_5875(true);
        this.method_36456(0.0f);
        this.method_36457(0.0f);
        this.method_5847(0.0f);
        this.exactHitPosition = embeddedPos;
        this.attachedBlock = result.method_17777();
        this.attachedFace = face;
        this.isStuck = true;
        this.stuckTicks = 0;
        this.method_73183().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_24066, class_3419.field_15254, 1.0f, 1.2f);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        return class_1269.field_5811;
    }

    public void method_5694(class_1657 player) {
    }

    public class_1665.class_1666 getPickupType() {
        if (this.isStuck && this.isReallyInWater()) {
            return class_1665.class_1666.field_7592;
        }
        return class_1665.class_1666.field_7593;
    }

    public void method_5773() {
        if (this.isPerformingBubbleEffect) {
            --this.bubbleEffectTimer;
            this.spawnBubbleParticles();
            if (this.bubbleEffectTimer <= 0) {
                this.isPerformingBubbleEffect = false;
                this.method_31472();
                return;
            }
        }
        if (this.isStuck && this.stuckTicks >= 0 && !this.isPerformingBubbleEffect) {
            ++this.stuckTicks;
            if (this.stuckTicks > 20 && this.method_73183().method_8608()) {
                int particleChance;
                int n = this.stuckTicks > 35 ? 1 : (particleChance = this.stuckTicks > 30 ? 2 : 3);
                if (this.field_5974.method_43048(particleChance) == 0) {
                    class_243 pos = this.method_73189();
                    double spreadFactor = 0.1;
                    this.method_73183().method_8406((class_2394)class_2398.field_11247, pos.field_1352 + (this.field_5974.method_43058() - 0.5) * spreadFactor, pos.field_1351 + (this.field_5974.method_43058() - 0.5) * spreadFactor, pos.field_1350 + (this.field_5974.method_43058() - 0.5) * spreadFactor, (this.field_5974.method_43058() - 0.5) * 0.03, 0.1 + this.field_5974.method_43058() * 0.05, (this.field_5974.method_43058() - 0.5) * 0.03);
                }
            }
            if (this.stuckTicks >= 40) {
                this.method_5648(true);
                this.createWaterShockwave();
                if (!this.method_73183().method_8608()) {
                    this.method_31472();
                }
                this.stuckTicks = -1;
            }
        }
        if (!this.isStuck) {
            class_243 velocity;
            double length;
            class_243 velocity2;
            double speed;
            super.method_5773();
            if (this.method_5799() && this.method_73183().method_8608() && (speed = (velocity2 = this.method_18798()).method_1033()) > 0.1 && this.field_6012 % 2 == 0) {
                class_243 normalized = velocity2.method_1029();
                class_243 bubblePos = this.method_73189().method_1020(normalized.method_1021(0.3));
                double spreadFactor = 0.05;
                for (int i = 0; i < 2; ++i) {
                    this.method_73183().method_8406((class_2394)class_2398.field_11247, bubblePos.field_1352 + (this.field_5974.method_43058() - 0.5) * spreadFactor, bubblePos.field_1351 + (this.field_5974.method_43058() - 0.5) * spreadFactor, bubblePos.field_1350 + (this.field_5974.method_43058() - 0.5) * spreadFactor, (this.field_5974.method_43058() - 0.5) * 0.02, 0.05, (this.field_5974.method_43058() - 0.5) * 0.02);
                }
            }
            if (this.method_5799()) {
                class_243 currentVelocity = this.method_18798();
                this.method_18799(currentVelocity.method_1021(1.2));
            }
            if (this.initialDirection == null && (length = (velocity = this.method_18798()).method_1033()) > 0.1) {
                this.initialDirection = velocity.method_1029();
            }
        }
    }

    public void method_5652(class_11372 nbt) {
        super.method_5652(nbt);
        nbt.method_71472("IsStuck", this.isStuck);
        nbt.method_71465("StuckTicks", this.stuckTicks);
        if (this.attachedBlock != null) {
            nbt.method_71465("AttachedBlockX", this.attachedBlock.method_10263());
            nbt.method_71465("AttachedBlockY", this.attachedBlock.method_10264());
            nbt.method_71465("AttachedBlockZ", this.attachedBlock.method_10260());
        }
        if (this.attachedFace != null) {
            nbt.method_71465("AttachedFace", this.attachedFace.ordinal());
        }
        if (this.exactHitPosition != null) {
            nbt.method_71463("HitPosX", this.exactHitPosition.field_1352);
            nbt.method_71463("HitPosY", this.exactHitPosition.field_1351);
            nbt.method_71463("HitPosZ", this.exactHitPosition.field_1350);
        }
        if (this.initialDirection != null) {
            nbt.method_71463("InitialDirX", this.initialDirection.field_1352);
            nbt.method_71463("InitialDirY", this.initialDirection.field_1351);
            nbt.method_71463("InitialDirZ", this.initialDirection.field_1350);
        }
    }

    public void method_5749(class_11368 nbt) {
        double dirX;
        double hitX;
        int faceId;
        super.method_5749(nbt);
        this.isStuck = nbt.method_71433("IsStuck", false);
        this.stuckTicks = nbt.method_71424("StuckTicks", 0);
        int blockX = nbt.method_71424("AttachedBlockX", Integer.MIN_VALUE);
        if (blockX != Integer.MIN_VALUE) {
            int blockY = nbt.method_71424("AttachedBlockY", 0);
            int blockZ = nbt.method_71424("AttachedBlockZ", 0);
            this.attachedBlock = new class_2338(blockX, blockY, blockZ);
        }
        if ((faceId = nbt.method_71424("AttachedFace", -1)) != -1 && faceId < class_2350.values().length) {
            this.attachedFace = class_2350.values()[faceId];
        }
        if (!Double.isNaN(hitX = nbt.method_71422("HitPosX", Double.NaN))) {
            double hitY = nbt.method_71422("HitPosY", 0.0);
            double hitZ = nbt.method_71422("HitPosZ", 0.0);
            this.exactHitPosition = new class_243(hitX, hitY, hitZ);
        }
        if (!Double.isNaN(dirX = nbt.method_71422("InitialDirX", Double.NaN))) {
            double dirY = nbt.method_71422("InitialDirY", 0.0);
            double dirZ = nbt.method_71422("InitialDirZ", 0.0);
            this.initialDirection = new class_243(dirX, dirY, dirZ);
        }
        this.method_5875(this.isStuck);
    }

    private void spawnAsItem() {
        if (!this.method_73183().method_8608()) {
            class_1309 livingEntity;
            class_1542 itemEntity = new class_1542(this.method_73183(), this.method_23317(), this.method_23318(), this.method_23321(), new class_1799((class_1935)ModItems.WATER_CHARGE));
            this.method_73183().method_8649((class_1297)itemEntity);
            class_1297 class_12972 = this.attachedEntity;
            if (class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_5805()) {
                livingEntity.method_6097(Math.max(0, livingEntity.method_6022() - 1));
            }
            this.method_31472();
        }
    }

    public boolean isStuck() {
        return this.isStuck;
    }

    protected float method_7436() {
        return 0.99f;
    }

    public void method_7438(double damage) {
        super.method_7438(0.0);
    }

    public double getDamage() {
        return 0.0;
    }

    public static void registerDispenserBehavior() {
        class_2357 behavior = new class_2357(){

            public class_1799 dispense(class_2342 pointer, class_1799 stack) {
                class_3218 world = pointer.comp_1967();
                class_2338 pos = pointer.comp_1968();
                class_2350 direction = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2741.field_12525);
                double x = (double)pos.method_10263() + 0.5 + (double)direction.method_10148() * 0.5;
                double y = (double)pos.method_10264() + 0.5 + (double)direction.method_10164() * 0.5;
                double z = (double)pos.method_10260() + 0.5 + (double)direction.method_10165() * 0.5;
                float speed = 1.5f;
                class_243 velocity = new class_243((double)((float)direction.method_10148() * speed), (double)((float)direction.method_10164() * speed), (double)((float)direction.method_10165() * speed));
                WaterChargeProjectileEntity projectile = new WaterChargeProjectileEntity((class_1937)world, x, y, z, velocity);
                world.method_8649((class_1297)projectile);
                stack.method_7934(1);
                return stack;
            }
        };
        class_2315.method_10009((class_1935)ModItems.WATER_CHARGE, (class_2357)behavior);
    }

    public void method_5768(class_3218 serverWorld) {
        if (!this.isPerformingBubbleEffect && !this.method_73183().method_8608()) {
            class_243 pos = this.method_73189();
            serverWorld.method_65096((class_2394)class_2398.field_11238, pos.field_1352, pos.field_1351, pos.field_1350, 20, 1.0, 1.0, 1.0, 0.2);
        }
        super.method_5768(serverWorld);
    }

    public boolean isStuckToEntity() {
        return this.isStuck && this.attachedEntity != null;
    }
}

