/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.item.custom;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9886;
import potatowolfie.earth_and_water.damage.ModDamageTypes;
import potatowolfie.earth_and_water.sound.ModSounds;

public class BattleAxeItem
extends class_1743 {
    private static final int DASH_COOLDOWN = 45;
    private static final int CREATIVE_DASH_COOLDOWN = 10;
    private static final float DASH_STRENGTH = 1.1383f;
    private static final float MIDAIR_DASH_STRENGTH = 0.6f;
    private static final int DASH_DISTANCE = 4;
    private static final float DASH_DAMAGE = 5.0f;
    private static final float MAX_HORIZONTAL_MULTIPLIER = 1.414f;
    private static final float MAX_VERTICAL_MULTIPLIER = 0.5f;

    public BattleAxeItem(class_9886 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        super.method_7873(stack, target, attacker);
    }

    private float calculateHorizontalAngleMultiplier(class_243 lookVec) {
        double horizontalMagnitude = Math.sqrt(lookVec.field_1352 * lookVec.field_1352 + lookVec.field_1350 * lookVec.field_1350);
        if (horizontalMagnitude < 0.001) {
            return 1.0f;
        }
        double angle = Math.atan2(lookVec.field_1350, lookVec.field_1352) * 180.0 / Math.PI;
        if (angle < 0.0) {
            angle += 360.0;
        }
        double distanceFromCardinal = Math.min(Math.min(Math.abs(angle), Math.abs(angle - 360.0)), Math.min(Math.min(Math.abs(angle - 90.0), Math.abs(angle - 180.0)), Math.abs(angle - 270.0)));
        double normalizedDistance = Math.min(distanceFromCardinal, 45.0) / 45.0;
        return (float)(1.0 + 0.4140000343322754 * normalizedDistance);
    }

    private float calculateVerticalAngleMultiplier(class_243 lookVec) {
        double horizontalMagnitude = Math.sqrt(lookVec.field_1352 * lookVec.field_1352 + lookVec.field_1350 * lookVec.field_1350);
        double verticalComponent = lookVec.field_1351;
        double pitchAngle = Math.atan2(Math.abs(verticalComponent), horizontalMagnitude) * 180.0 / Math.PI;
        double distanceFromCardinal = pitchAngle <= 45.0 ? pitchAngle : 90.0 - pitchAngle;
        double normalizedDistance = distanceFromCardinal / 45.0;
        return (float)(1.0 + -0.5 * normalizedDistance);
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_7357().method_7904(itemStack)) {
            return class_1269.field_5811;
        }
        if (!world.method_8608() && world instanceof class_3218) {
            float verticalScalingFactor;
            float currentDashStrength;
            class_3218 serverWorld = (class_3218)world;
            class_243 lookVec = player.method_5720();
            boolean isInAir = !player.method_24828();
            float horizontalMultiplier = this.calculateHorizontalAngleMultiplier(lookVec);
            float verticalMultiplier = this.calculateVerticalAngleMultiplier(lookVec);
            if (isInAir) {
                float upwardBoost = (float)((double)0.18f * Math.max(0.0, lookVec.field_1351));
                currentDashStrength = 0.6f + upwardBoost;
                currentDashStrength *= horizontalMultiplier * verticalMultiplier;
                verticalScalingFactor = 1.0f;
            } else {
                currentDashStrength = 1.1383f;
                currentDashStrength *= horizontalMultiplier * Math.min(verticalMultiplier, 1.2f);
                verticalScalingFactor = (float)(1.0 - (double)0.3f * Math.max(0.0, lookVec.field_1351));
            }
            class_243 dashVec = new class_243(lookVec.field_1352 * (double)currentDashStrength, lookVec.field_1351 * (double)currentDashStrength * (double)verticalScalingFactor, lookVec.field_1350 * (double)currentDashStrength);
            player.method_18799(dashVec);
            player.field_64356 = true;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
            }
            class_243 playerPos = player.method_73189();
            class_243 dashEnd = playerPos.method_1019(dashVec.method_1021(4.0));
            class_238 collisionBox = new class_238(Math.min(playerPos.field_1352, dashEnd.field_1352) - 1.0, Math.min(playerPos.field_1351, dashEnd.field_1351) - 1.0, Math.min(playerPos.field_1350, dashEnd.field_1350) - 1.0, Math.max(playerPos.field_1352, dashEnd.field_1352) + 1.0, Math.max(playerPos.field_1351, dashEnd.field_1351) + 1.0, Math.max(playerPos.field_1350, dashEnd.field_1350) + 1.0);
            List entities = world.method_8390(class_1309.class, collisionBox, entity -> entity != player && !entity.method_7325());
            boolean hitAnyMob = false;
            for (class_1309 entity2 : entities) {
                class_1282 battleAxeDamage = new class_1282((class_6880)world.method_30349().method_30530(class_7924.field_42534).method_10223(ModDamageTypes.BATTLE_AXE.method_29177()).get(), (class_1297)player);
                entity2.method_64397(serverWorld, battleAxeDamage, 5.0f);
                entity2.method_6005(0.5, -lookVec.field_1352, -lookVec.field_1350);
                hitAnyMob = true;
            }
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSounds.BATTLE_AXE_DASH, class_3419.field_15248, 0.5f, 1.0f);
            int cooldown = player.method_31549().field_7477 ? 10 : 45;
            player.method_7357().method_62835(itemStack, cooldown);
        }
        return class_1269.field_5812;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type) {
        textConsumer.accept((class_2561)class_2561.method_43471((String)"tooltip.earth-and-water.tooltipempty"));
        textConsumer.accept((class_2561)class_2561.method_43471((String)"tooltip.earth-and-water.battle_axe.tooltip1"));
        textConsumer.accept((class_2561)class_2561.method_43471((String)"tooltip.earth-and-water.battle_axe.tooltip2"));
        super.method_67187(stack, context, displayComponent, textConsumer, type);
    }
}

