/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.structure.ancient_ruins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import potatowolfie.earth_and_water.block.custom.ReinforcedSpawnerBlock;
import potatowolfie.earth_and_water.block.entity.custom.ReinforcedSpawnerBlockEntity;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.structure.ModStructurePieceTypes;
import potatowolfie.earth_and_water.structure.ancient_ruins.AncientRuinsStructure;

public class AncientRuinsGenerator {
    private static final class_2960 INNER_WALLS = class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/inner_walls");
    private static final class_2960[] OUTER_WALL_PIECES = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_2"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_3")};
    private static final class_2960 OUTER_WALL_ENTRANCE = class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_entrance");
    private static final class_2960[] OUTER_WALL_CORNERS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_corner_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/walls_corner_2")};
    private static final class_2960[] CENTER_PIECES = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/center_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/center_2")};
    private static final class_2960[] STATUES = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/statue_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/statue_2"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/statue_3")};
    private static final class_2960[] SMALL_RUINS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/small_ruins_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/small_ruins/small_ruins_2"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/small_ruins_3"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/small_ruins_4"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/small_ruins_5")};
    private static final class_2960[] MEDIUM_RUINS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/medium_ruins_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/medium_ruins_2"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/medium_ruins_3")};
    private static final class_2960[] LARGE_RUINS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/large_ruins_1"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/large_ruins_2"), class_2960.method_60655((String)"earth-and-water", (String)"ancient_ruins/large_ruins_3")};
    private static final int WALL_LENGTH = 45;
    private static final int WALL_WIDTH = 3;
    private static final int CORNER_SIZE = 24;
    private static final int TOTAL_PERIMETER = 93;
    private static final int INTERIOR_SIZE = 88;
    private static final int CENTER_EXCLUSION_SIZE = 40;
    private static final int SMALL_RUIN_MAX_SIZE = 9;
    private static final int MEDIUM_RUIN_MAX_SIZE = 15;
    private static final int LARGE_RUIN_MAX_SIZE = 21;
    private static final int SMALL_RUIN_SPACING = 2;
    private static final int MEDIUM_RUIN_SPACING = 2;
    private static final int LARGE_RUIN_SPACING = 3;

    public static void addPieces(class_3485 manager, class_2338 pos, class_2470 rotation, class_6130 holder, class_5819 random, AncientRuinsStructure structure) {
        int centerIndex = random.method_43048(CENTER_PIECES.length);
        int statueIndex = random.method_43048(STATUES.length);
        class_2470 noRotation = class_2470.field_11467;
        AncientRuinsGenerator.addOuterWallPieces(manager, pos, holder, random);
        class_2338 innerGroupOffset = pos.method_10069(-11, 0, -4);
        holder.method_35462((class_3443)new Piece(manager, INNER_WALLS, innerGroupOffset, noRotation, -1, -1, PieceType.INNER_WALLS));
        class_2338 centerOffset = innerGroupOffset.method_10069(2, 0, 2);
        holder.method_35462((class_3443)new Piece(manager, CENTER_PIECES[centerIndex], centerOffset, noRotation, centerIndex, statueIndex, PieceType.CENTER));
        class_2338 statueOffset = centerOffset.method_10069(13, 0, 13);
        holder.method_35462((class_3443)new Piece(manager, STATUES[statueIndex], statueOffset, noRotation, centerIndex, statueIndex, PieceType.STATUE));
        int ruinCount = random.method_39332(structure.minRuins, structure.maxRuins);
        AncientRuinsGenerator.addSurroundingRuins(manager, random, pos, structure, holder, ruinCount);
    }

    private static void addOuterWallPieces(class_3485 manager, class_2338 basePos, class_6130 holder, class_5819 random) {
        class_2960 northWall = OUTER_WALL_ENTRANCE;
        class_2960 eastWall = OUTER_WALL_PIECES[random.method_43048(OUTER_WALL_PIECES.length)];
        class_2960 southWall = OUTER_WALL_PIECES[random.method_43048(OUTER_WALL_PIECES.length)];
        class_2960 westWall = OUTER_WALL_PIECES[random.method_43048(OUTER_WALL_PIECES.length)];
        class_2960 nwCorner = OUTER_WALL_CORNERS[random.method_43048(OUTER_WALL_CORNERS.length)];
        class_2960 neCorner = OUTER_WALL_CORNERS[random.method_43048(OUTER_WALL_CORNERS.length)];
        class_2960 seCorner = OUTER_WALL_CORNERS[random.method_43048(OUTER_WALL_CORNERS.length)];
        class_2960 swCorner = OUTER_WALL_CORNERS[random.method_43048(OUTER_WALL_CORNERS.length)];
        class_2338 nwCornerPos = basePos.method_10069(-39, 0, 37);
        holder.method_35462((class_3443)new Piece(manager, nwCorner, nwCornerPos, class_2470.field_11467, -1, -1, PieceType.OUTER_CORNER));
        class_2338 neCornerPos = basePos.method_10069(-16, 0, -32);
        holder.method_35462((class_3443)new Piece(manager, neCorner, neCornerPos, class_2470.field_11463, -1, -1, PieceType.OUTER_CORNER));
        class_2338 swCornerPos = basePos.method_10069(30, 0, 60);
        holder.method_35462((class_3443)new Piece(manager, swCorner, swCornerPos, class_2470.field_11465, -1, -1, PieceType.OUTER_CORNER));
        class_2338 seCornerPos = basePos.method_10069(53, 0, -9);
        holder.method_35462((class_3443)new Piece(manager, seCorner, seCornerPos, class_2470.field_11464, -1, -1, PieceType.OUTER_CORNER));
        class_2338 northWallPos = basePos.method_10069(-15, 0, 58);
        holder.method_35462((class_3443)new Piece(manager, northWall, northWallPos, class_2470.field_11467, -1, -1, PieceType.OUTER_WALLS));
        class_2338 southWallPos = basePos.method_10069(29, 0, -30);
        holder.method_35462((class_3443)new Piece(manager, southWall, southWallPos, class_2470.field_11464, -1, -1, PieceType.OUTER_WALLS));
        class_2338 eastWallPos = basePos.method_10069(53, 0, -8);
        holder.method_35462((class_3443)new Piece(manager, eastWall, eastWallPos, class_2470.field_11463, -1, -1, PieceType.OUTER_WALLS));
        class_2338 westWallPos = basePos.method_10069(-39, 0, 36);
        holder.method_35462((class_3443)new Piece(manager, westWall, westWallPos, class_2470.field_11465, -1, -1, PieceType.OUTER_WALLS));
    }

    private static void addSurroundingRuins(class_3485 manager, class_5819 random, class_2338 centerPos, AncientRuinsStructure structure, class_6130 pieces, int count) {
        int i;
        int interiorMinX = centerPos.method_10263() - 37;
        int interiorMinZ = centerPos.method_10260() - 30;
        int interiorMaxX = interiorMinX + 88;
        int interiorMaxZ = interiorMinZ + 88;
        int exclusionStartX = interiorMinX + 24;
        int exclusionStartZ = interiorMinZ + 24;
        int largeMinX = interiorMinX + 9 + random.method_43048(2);
        int largeMinZ = interiorMinZ + 9 + random.method_43048(2);
        int largeMaxX = interiorMaxX - 9 - random.method_43048(2);
        int largeMaxZ = interiorMaxZ - 9 - random.method_43048(2);
        int mediumMinX = interiorMinX + 6 + random.method_43048(3);
        int mediumMinZ = interiorMinZ + 6 + random.method_43048(3);
        int mediumMaxX = interiorMaxX - 6 - random.method_43048(3);
        int mediumMaxZ = interiorMaxZ - 6 - random.method_43048(3);
        int smallMinX = interiorMinX + 4;
        int smallMinZ = interiorMinZ + 4;
        int smallMaxX = interiorMaxX - 4;
        int smallMaxZ = interiorMaxZ - 4;
        PackingContext largeContext = new PackingContext(largeMinX, largeMinZ, largeMaxX - largeMinX, largeMaxZ - largeMinZ);
        PackingContext mediumContext = new PackingContext(mediumMinX, mediumMinZ, mediumMaxX - mediumMinX, mediumMaxZ - mediumMinZ);
        PackingContext smallContext = new PackingContext(smallMinX, smallMinZ, smallMaxX - smallMinX, smallMaxZ - smallMinZ);
        class_2338 exclusionStart = new class_2338(exclusionStartX, centerPos.method_10264(), exclusionStartZ);
        largeContext.addExclusionZone(exclusionStart, 40, 40);
        mediumContext.addExclusionZone(exclusionStart, 40, 40);
        smallContext.addExclusionZone(exclusionStart, 40, 40);
        ArrayList ruinsToPlace = Lists.newArrayList();
        int poolSize = 55 + random.method_43048(3);
        int smallCount = (int)((double)poolSize * 0.5);
        int mediumCount = (int)((double)poolSize * 0.3);
        int largeCount = (int)((double)poolSize * 0.2);
        for (i = 0; i < largeCount; ++i) {
            ruinsToPlace.add(new RuinToPlace(RuinSize.LARGE, random));
        }
        for (i = 0; i < mediumCount; ++i) {
            ruinsToPlace.add(new RuinToPlace(RuinSize.MEDIUM, random));
        }
        for (i = 0; i < smallCount; ++i) {
            ruinsToPlace.add(new RuinToPlace(RuinSize.SMALL, random));
        }
        Collections.shuffle(ruinsToPlace, new Random(random.method_43055()));
        ruinsToPlace.sort(Comparator.comparingInt(r -> -r.size.ordinal()));
        for (RuinToPlace ruin : ruinsToPlace) {
            PackingContext context = switch (ruin.size.ordinal()) {
                default -> throw new MatchException(null, null);
                case 2 -> largeContext;
                case 1 -> mediumContext;
                case 0 -> smallContext;
            };
            int spacing = AncientRuinsGenerator.getSpacingForSize(ruin.size);
            int[] dims = AncientRuinsGenerator.getTemplateDimensions(ruin.template);
            int widthWithSpacing = dims[0] + spacing * 2;
            int depthWithSpacing = dims[1] + spacing * 2;
            PlacementResult result = context.findBestPlacement(widthWithSpacing, depthWithSpacing, exclusionStart, 40);
            PlacementResult rotatedResult = context.findBestPlacement(depthWithSpacing, widthWithSpacing, exclusionStart, 40);
            if (result == null || rotatedResult != null && rotatedResult.wastedSpace < result.wastedSpace) {
                result = rotatedResult;
                class_2470 class_24702 = ruin.rotation = ruin.rotation == class_2470.field_11467 ? class_2470.field_11463 : class_2470.field_11467;
            }
            if (result == null) continue;
            int actualX = result.x + spacing;
            int actualZ = result.z + spacing;
            class_2338 ruinPos = new class_2338(actualX, centerPos.method_10264(), actualZ);
            pieces.method_35462((class_3443)new Piece(manager, ruin.template, ruinPos, ruin.rotation, -1, -1, PieceType.RUIN));
            context.placeRectangle(result.x, result.z, result.width, result.depth);
        }
    }

    private static int getSpacingForSize(RuinSize size) {
        return switch (size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 2;
            case 1 -> 2;
            case 2 -> 3;
        };
    }

    private static int[] getTemplateDimensions(class_2960 template) {
        String path = template.toString();
        if (path.contains("small_ruins_1")) {
            return new int[]{7, 8};
        }
        if (path.contains("small_ruins_2")) {
            return new int[]{7, 7};
        }
        if (path.contains("small_ruins_3")) {
            return new int[]{9, 9};
        }
        if (path.contains("small_ruins_4")) {
            return new int[]{7, 8};
        }
        if (path.contains("small_ruins_5")) {
            return new int[]{9, 7};
        }
        if (path.contains("medium_ruins_1")) {
            return new int[]{13, 12};
        }
        if (path.contains("medium_ruins_2")) {
            return new int[]{11, 15};
        }
        if (path.contains("medium_ruins_3")) {
            return new int[]{13, 14};
        }
        if (path.contains("large_ruins_1")) {
            return new int[]{19, 13};
        }
        if (path.contains("large_ruins_2")) {
            return new int[]{21, 13};
        }
        if (path.contains("large_ruins_3")) {
            return new int[]{17, 19};
        }
        return new int[]{9, 9};
    }

    private static class_2960 getRandomRuinTemplate(class_5819 random, RuinSize size) {
        return switch (size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SMALL_RUINS[random.method_43048(SMALL_RUINS.length)];
            case 1 -> MEDIUM_RUINS[random.method_43048(MEDIUM_RUINS.length)];
            case 2 -> LARGE_RUINS[random.method_43048(LARGE_RUINS.length)];
        };
    }

    private static int getMaxRuinSize(RuinSize size) {
        return switch (size.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 9;
            case 1 -> 15;
            case 2 -> 21;
        };
    }

    public static class Piece
    extends class_3470 {
        private final int centerIndex;
        private final int statueIndex;
        private final PieceType pieceType;

        public static Piece load(class_3485 manager, class_2487 nbt) {
            return new Piece(manager, nbt);
        }

        public Piece(class_3485 manager, class_2960 template, class_2338 pos, class_2470 rotation, int centerIndex, int statueIndex, PieceType pieceType) {
            super(ModStructurePieceTypes.ANCIENT_RUINS, 0, manager, template, template.toString(), Piece.createPlacementData(rotation), pos);
            this.centerIndex = centerIndex;
            this.statueIndex = statueIndex;
            this.pieceType = pieceType;
        }

        public Piece(class_3485 manager, class_2487 nbt) {
            super(ModStructurePieceTypes.ANCIENT_RUINS, nbt, manager, identifier -> Piece.createPlacementData(nbt.method_67491("Rot", class_2470.field_39313).orElse(class_2470.field_11467)));
            this.centerIndex = nbt.method_10550("CenterIndex").orElse(-1);
            this.statueIndex = nbt.method_10550("StatueIndex").orElse(-1);
            this.pieceType = PieceType.valueOf(nbt.method_68564("PieceType", "RUIN"));
        }

        private static class_3492 createPlacementData(class_2470 rotation) {
            return new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_16184((class_3491)class_3793.field_16721);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_67494("Rot", class_2470.field_39313, (Object)this.field_15434.method_15113());
            nbt.method_10569("CenterIndex", this.centerIndex);
            nbt.method_10569("StatueIndex", this.statueIndex);
            nbt.method_10582("PieceType", this.pieceType.name());
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 world, class_5819 random, class_3341 boundingBox) {
            if (metadata.equals("center_chest")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_center"));
            } else if (metadata.equals("statue_chest_1")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_statue_1"));
            } else if (metadata.equals("statue_chest_2")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_statue_2"));
            } else if (metadata.equals("statue_chest_3")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_statue_3"));
            } else if (metadata.equals("medium_chest")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_medium"));
            } else if (metadata.equals("large_chest")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/ancient_ruins_large"));
            }
        }

        private void setupSpawner(class_5425 world, class_3341 boundingBox, class_2338 structureBlockPos, String entityName) {
            for (class_2350 direction : class_2350.values()) {
                class_1299 entityType;
                class_2586 blockEntity;
                class_2680 state;
                class_2338 spawnerPos = structureBlockPos.method_10093(direction);
                if (!boundingBox.method_14662((class_2382)spawnerPos) || !((state = world.method_8320(spawnerPos)).method_26204() instanceof ReinforcedSpawnerBlock) || !((blockEntity = world.method_8321(spawnerPos)) instanceof ReinforcedSpawnerBlockEntity)) continue;
                ReinforcedSpawnerBlockEntity spawnerEntity = (ReinforcedSpawnerBlockEntity)blockEntity;
                if (entityName.equals("bore")) {
                    entityType = ModEntities.BORE;
                } else if (entityName.equals("brine")) {
                    entityType = ModEntities.BRINE;
                } else {
                    class_2960 entityId = class_2960.method_60655((String)"earth-and-water", (String)entityName);
                    entityType = (class_1299)class_7923.field_41177.method_63535(entityId);
                    if (entityType == null || !class_7923.field_41177.method_10250(entityId)) {
                        entityId = class_2960.method_60655((String)"minecraft", (String)entityName);
                        entityType = (class_1299)class_7923.field_41177.method_63535(entityId);
                    }
                }
                if (entityType != null) {
                    spawnerEntity.setEntityType(entityType);
                    spawnerEntity.activate();
                    class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)ReinforcedSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ReinforcedSpawnerBlock.KEYHOLE, (Comparable)Boolean.valueOf(false));
                    world.method_8652(spawnerPos, newState, 3);
                    spawnerEntity.method_5431();
                }
                return;
            }
        }

        private void placeChestWithLoot(class_5425 world, class_3341 boundingBox, class_5819 random, class_2338 structureBlockPos, class_2960 lootTable) {
            for (class_2350 direction : class_2350.values()) {
                class_2586 blockEntity;
                class_2680 state;
                class_2338 chestPos = structureBlockPos.method_10093(direction);
                if (!boundingBox.method_14662((class_2382)chestPos) || !(state = world.method_8320(chestPos)).method_27852(class_2246.field_10034) || !((blockEntity = world.method_8321(chestPos)) instanceof class_2595)) continue;
                class_2595 chestEntity = (class_2595)blockEntity;
                chestEntity.method_54867(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTable), random.method_43055());
                return;
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            super.method_14931(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
            this.field_15433.method_15165(this.field_15432, this.field_15434, class_2246.field_10465, false).forEach(structureBlockInfo -> {
                String metadata;
                if (structureBlockInfo.comp_1343() != null && !(metadata = structureBlockInfo.comp_1343().method_68564("metadata", "")).isEmpty()) {
                    this.method_15026(metadata, structureBlockInfo.comp_1341(), (class_5425)world, random, chunkBox);
                }
            });
        }
    }

    private static enum PieceType {
        INNER_WALLS,
        CENTER,
        STATUE,
        RUIN,
        OUTER_WALLS,
        OUTER_CORNER;

    }

    private static class PackingContext {
        private final List<FreeRect> freeRects;
        private final int baseX;
        private final int baseZ;

        public PackingContext(int x, int z, int width, int depth) {
            this.baseX = x;
            this.baseZ = z;
            this.freeRects = Lists.newArrayList();
            this.freeRects.add(new FreeRect(x, z, width, depth));
        }

        public void addExclusionZone(class_2338 pos, int width, int depth) {
            ArrayList newFreeRects = Lists.newArrayList();
            for (FreeRect rect : this.freeRects) {
                List<FreeRect> splits = this.splitRectangle(rect, pos.method_10263(), pos.method_10260(), width, depth);
                newFreeRects.addAll(splits);
            }
            this.freeRects.clear();
            this.freeRects.addAll(newFreeRects);
            this.removeDuplicatesAndContained();
        }

        public PlacementResult findBestPlacement(int width, int depth, class_2338 exclusion, int exclusionSize) {
            PlacementResult best = null;
            for (FreeRect rect : this.freeRects) {
                if (rect.width < width || rect.depth < depth || this.intersectsExclusion(rect.x, rect.z, width, depth, exclusion.method_10263(), exclusion.method_10260(), exclusionSize)) continue;
                int wastedSpace = rect.width * rect.depth - width * depth;
                if (best != null && wastedSpace >= best.wastedSpace) continue;
                best = new PlacementResult(rect.x, rect.z, width, depth, wastedSpace);
            }
            return best;
        }

        public void placeRectangle(int x, int z, int width, int depth) {
            ArrayList newFreeRects = Lists.newArrayList();
            for (FreeRect rect : this.freeRects) {
                List<FreeRect> splits = this.splitRectangle(rect, x, z, width, depth);
                newFreeRects.addAll(splits);
            }
            this.freeRects.clear();
            this.freeRects.addAll(newFreeRects);
            this.removeDuplicatesAndContained();
        }

        private List<FreeRect> splitRectangle(FreeRect rect, int x, int z, int width, int depth) {
            ArrayList result = Lists.newArrayList();
            if (!this.intersects(rect.x, rect.z, rect.width, rect.depth, x, z, width, depth)) {
                result.add(rect);
                return result;
            }
            if (x > rect.x) {
                result.add(new FreeRect(rect.x, rect.z, x - rect.x, rect.depth));
            }
            if (x + width < rect.x + rect.width) {
                result.add(new FreeRect(x + width, rect.z, rect.x + rect.width - (x + width), rect.depth));
            }
            if (z > rect.z) {
                result.add(new FreeRect(rect.x, rect.z, rect.width, z - rect.z));
            }
            if (z + depth < rect.z + rect.depth) {
                result.add(new FreeRect(rect.x, z + depth, rect.width, rect.z + rect.depth - (z + depth)));
            }
            return result;
        }

        private void removeDuplicatesAndContained() {
            block0: for (int i = 0; i < this.freeRects.size(); ++i) {
                int j = i + 1;
                while (j < this.freeRects.size()) {
                    FreeRect r2;
                    FreeRect r1 = this.freeRects.get(i);
                    if (this.contains(r1, r2 = this.freeRects.get(j))) {
                        this.freeRects.remove(j);
                        continue;
                    }
                    if (this.contains(r2, r1)) {
                        this.freeRects.remove(i);
                        --i;
                        continue block0;
                    }
                    ++j;
                }
            }
        }

        private boolean contains(FreeRect r1, FreeRect r2) {
            return r2.x >= r1.x && r2.z >= r1.z && r2.x + r2.width <= r1.x + r1.width && r2.z + r2.depth <= r1.z + r1.depth;
        }

        private boolean intersects(int x1, int z1, int w1, int d1, int x2, int z2, int w2, int d2) {
            return x1 + w1 > x2 && x2 + w2 > x1 && z1 + d1 > z2 && z2 + d2 > z1;
        }

        private boolean intersectsExclusion(int x, int z, int w, int d, int exX, int exZ, int exSize) {
            return this.intersects(x, z, w, d, exX, exZ, exSize, exSize);
        }
    }

    private static class RuinToPlace {
        RuinSize size;
        class_2960 template;
        class_2470 rotation;

        RuinToPlace(RuinSize size, class_5819 random) {
            this.size = size;
            this.template = AncientRuinsGenerator.getRandomRuinTemplate(random, size);
            this.rotation = class_2470.field_11467;
        }
    }

    private static enum RuinSize {
        SMALL,
        MEDIUM,
        LARGE;

    }

    private static class PlacementResult {
        int x;
        int z;
        int width;
        int depth;
        int wastedSpace;

        PlacementResult(int x, int z, int width, int depth, int wastedSpace) {
            this.x = x;
            this.z = z;
            this.width = width;
            this.depth = depth;
            this.wastedSpace = wastedSpace;
        }
    }

    private static class PlacedPiece {
        final class_2338 pos;
        final int width;
        final int depth;

        PlacedPiece(class_2338 pos, int width, int depth) {
            this.pos = pos;
            this.width = width;
            this.depth = depth;
        }
    }

    private static class FreeRect {
        int x;
        int z;
        int width;
        int depth;

        FreeRect(int x, int z, int width, int depth) {
            this.x = x;
            this.z = z;
            this.width = width;
            this.depth = depth;
        }
    }
}

