/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.structure.conduit_monument;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3470;
import net.minecraft.class_3485;
import net.minecraft.class_3486;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_3541;
import net.minecraft.class_3730;
import net.minecraft.class_3793;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6130;
import net.minecraft.class_6625;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import potatowolfie.earth_and_water.block.custom.ReinforcedSpawnerBlock;
import potatowolfie.earth_and_water.block.entity.custom.ReinforcedSpawnerBlockEntity;
import potatowolfie.earth_and_water.entity.ModEntities;
import potatowolfie.earth_and_water.entity.brine.BrineEntity;
import potatowolfie.earth_and_water.structure.ModStructurePieceTypes;
import potatowolfie.earth_and_water.structure.conduit_monument.ConduitMonumentStructure;

public class ConduitMonumentGenerator {
    private static final class_2960[] CENTER_PIECES = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/center_1"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/center_2"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/center_3")};
    private static final class_2960[] MEDIUM_RUINS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/medium_ruins_1"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/medium_ruins_2"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/medium_ruins_3")};
    private static final class_2960[] SMALL_RUINS = new class_2960[]{class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/small_ruins_1"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/small_ruins_2"), class_2960.method_60655((String)"earth-and-water", (String)"conduit_monument/small_ruins_3")};

    private static class_2960 getRandomCenterPiece(class_5819 random) {
        return (class_2960)class_156.method_27173((Object[])CENTER_PIECES, (class_5819)random);
    }

    private static class_2960 getRandomMediumRuin(class_5819 random) {
        return (class_2960)class_156.method_27173((Object[])MEDIUM_RUINS, (class_5819)random);
    }

    private static class_2960 getRandomSmallRuin(class_5819 random) {
        return (class_2960)class_156.method_27173((Object[])SMALL_RUINS, (class_5819)random);
    }

    public static void addPieces(class_3485 manager, class_2338 pos, class_2470 rotation, class_6130 holder, class_5819 random, ConduitMonumentStructure structure) {
        int centerIndex = random.method_43048(CENTER_PIECES.length);
        class_2960 centerPiece = CENTER_PIECES[centerIndex];
        holder.method_35462((class_3443)new Piece(manager, centerPiece, pos, rotation, centerIndex));
        int ruinCount = class_3532.method_15395((class_5819)random, (int)structure.minRuins, (int)structure.maxRuins);
        ConduitMonumentGenerator.addSurroundingRuins(manager, random, rotation, pos, structure, holder, ruinCount);
    }

    private static void addSurroundingRuins(class_3485 manager, class_5819 random, class_2470 centerRotation, class_2338 centerPos, ConduitMonumentStructure structure, class_6130 pieces, int count) {
        class_2338 blockPos = new class_2338(centerPos.method_10263(), 90, centerPos.method_10260());
        class_2338 blockPos2 = class_3499.method_15168((class_2338)new class_2338(15, 0, 15), (class_2415)class_2415.field_11302, (class_2470)centerRotation, (class_2338)class_2338.field_10980).method_10081((class_2382)blockPos);
        class_3341 centerBox = class_3341.method_34390((class_2382)blockPos, (class_2382)blockPos2);
        class_2338 blockPos3 = new class_2338(Math.min(blockPos.method_10263(), blockPos2.method_10263()), blockPos.method_10264(), Math.min(blockPos.method_10260(), blockPos2.method_10260()));
        List<class_2338> positions = ConduitMonumentGenerator.getRuinPositions(random, blockPos3);
        int mediumCount = 0;
        for (int i = 0; i < count && !positions.isEmpty(); ++i) {
            boolean isMedium;
            int index = random.method_43048(positions.size());
            class_2338 ruinPos = positions.remove(index);
            class_2470 ruinRotation = class_2470.method_16548((class_5819)random);
            boolean bl = isMedium = mediumCount < 3 && random.method_43057() <= structure.mediumProbability;
            if (isMedium) {
                ++mediumCount;
            }
            class_2960 ruinTemplate = isMedium ? ConduitMonumentGenerator.getRandomMediumRuin(random) : ConduitMonumentGenerator.getRandomSmallRuin(random);
            class_2338 ruinPos2 = class_3499.method_15168((class_2338)new class_2338(10, 0, 10), (class_2415)class_2415.field_11302, (class_2470)ruinRotation, (class_2338)class_2338.field_10980).method_10081((class_2382)ruinPos);
            class_3341 ruinBox = class_3341.method_34390((class_2382)ruinPos, (class_2382)ruinPos2);
            if (ruinBox.method_14657(centerBox)) continue;
            pieces.method_35462((class_3443)new Piece(manager, ruinTemplate, ruinPos, ruinRotation, -1));
        }
    }

    private static List<class_2338> getRuinPositions(class_5819 random, class_2338 centerPos) {
        ArrayList list = Lists.newArrayList();
        list.add(centerPos.method_10069(-12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, 12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, 12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, 12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(-12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, -12 - class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, -12 - class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, -12 - class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, -12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(12 + class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, 12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(-12 - class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, -12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(-12 - class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        list.add(centerPos.method_10069(-12 - class_3532.method_15395((class_5819)random, (int)1, (int)5), 0, 12 + class_3532.method_15395((class_5819)random, (int)1, (int)5)));
        return list;
    }

    public static class Piece
    extends class_3470 {
        private final int centerIndex;

        public Piece(class_3485 manager, class_2960 template, class_2338 pos, class_2470 rotation, int centerIndex) {
            super(ModStructurePieceTypes.CONDUIT_MONUMENT, 0, manager, template, template.toString(), Piece.createPlacementData(rotation), pos);
            this.centerIndex = centerIndex;
        }

        public Piece(class_3485 manager, class_2487 nbt) {
            super(ModStructurePieceTypes.CONDUIT_MONUMENT, nbt, manager, identifier -> Piece.createPlacementData(nbt.method_67491("Rot", class_2470.field_39313).orElse(class_2470.field_11467)));
            this.centerIndex = nbt.method_10550("CenterIndex").orElse(-1);
        }

        private static class_3492 createPlacementData(class_2470 rotation) {
            return new class_3492().method_15123(rotation).method_15125(class_2415.field_11302).method_16184((class_3491)class_3793.field_16721);
        }

        protected void method_14943(class_6625 context, class_2487 nbt) {
            super.method_14943(context, nbt);
            nbt.method_67494("Rot", class_2470.field_39313, (Object)this.field_15434.method_15113());
            nbt.method_10569("CenterIndex", this.centerIndex);
        }

        protected void method_15026(String metadata, class_2338 pos, class_5425 world, class_5819 random, class_3341 boundingBox) {
            if (this.centerIndex == -1) {
                return;
            }
            if (metadata.equals("chest_1")) {
                switch (this.centerIndex) {
                    case 0: {
                        this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/center_1_chest_1"));
                        break;
                    }
                    case 1: {
                        this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/center_2_chest_1"));
                        break;
                    }
                    case 2: {
                        this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/center_3"));
                    }
                }
            } else if (metadata.equals("chest_2")) {
                this.placeChestWithLoot(world, boundingBox, random, pos, class_2960.method_60655((String)"earth-and-water", (String)"chests/center_shared_chest_2"));
            } else if (metadata.startsWith("spawner_")) {
                String entityName = metadata.substring(8);
                this.setupSpawner(world, boundingBox, pos, entityName);
            }
        }

        private void setupSpawner(class_5425 world, class_3341 boundingBox, class_2338 structureBlockPos, String entityName) {
            for (class_2350 direction : class_2350.values()) {
                class_1299 entityType;
                class_2586 blockEntity;
                class_2680 state;
                class_2338 spawnerPos = structureBlockPos.method_10093(direction);
                if (!boundingBox.method_14662((class_2382)spawnerPos) || !((state = world.method_8320(spawnerPos)).method_26204() instanceof ReinforcedSpawnerBlock) || !((blockEntity = world.method_8321(spawnerPos)) instanceof ReinforcedSpawnerBlockEntity)) continue;
                ReinforcedSpawnerBlockEntity spawnerEntity = (ReinforcedSpawnerBlockEntity)blockEntity;
                if (entityName.equals("brine")) {
                    entityType = ModEntities.BRINE;
                } else {
                    class_2960 entityId = class_2960.method_60655((String)"earth-and-water", (String)entityName);
                    entityType = (class_1299)class_7923.field_41177.method_63535(entityId);
                    if (entityType == null || !class_7923.field_41177.method_10250(entityId)) {
                        entityId = class_2960.method_60655((String)"minecraft", (String)entityName);
                        entityType = (class_1299)class_7923.field_41177.method_63535(entityId);
                    }
                }
                if (entityType != null) {
                    spawnerEntity.setEntityType(entityType);
                    spawnerEntity.activate();
                    spawnerEntity.method_5431();
                    class_3218 serverWorld = world.method_8410();
                    class_2680 newState = (class_2680)((class_2680)state.method_11657((class_2769)ReinforcedSpawnerBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ReinforcedSpawnerBlock.KEYHOLE, (Comparable)Boolean.valueOf(false));
                    serverWorld.method_8652(spawnerPos, newState, 3);
                    serverWorld.method_8413(spawnerPos, state, newState, 3);
                }
                return;
            }
        }

        private void placeChestWithLoot(class_5425 world, class_3341 boundingBox, class_5819 random, class_2338 structureBlockPos, class_2960 lootTable) {
            for (class_2350 direction : class_2350.values()) {
                class_2586 blockEntity;
                class_2680 state;
                class_2338 chestPos = structureBlockPos.method_10093(direction);
                if (!boundingBox.method_14662((class_2382)chestPos) || !(state = world.method_8320(chestPos)).method_27852(class_2246.field_10034) || !((blockEntity = world.method_8321(chestPos)) instanceof class_2595)) continue;
                class_2595 chestEntity = (class_2595)blockEntity;
                chestEntity.method_54867(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTable), random.method_43055());
                return;
            }
        }

        private void fillUnderStructure(class_5281 world, class_3341 chunkBox, class_5819 random) {
            class_2338 structureStart = this.field_15432;
            class_2338 structureEnd = class_3499.method_15168((class_2338)new class_2338(this.field_15433.method_15160().method_10263() - 1, this.field_15433.method_15160().method_10264() - 1, this.field_15433.method_15160().method_10260() - 1), (class_2415)class_2415.field_11302, (class_2470)this.field_15434.method_15113(), (class_2338)class_2338.field_10980).method_10081((class_2382)this.field_15432);
            int minX = Math.min(structureStart.method_10263(), structureEnd.method_10263());
            int maxX = Math.max(structureStart.method_10263(), structureEnd.method_10263());
            int minY = Math.min(structureStart.method_10264(), structureEnd.method_10264());
            int maxY = Math.max(structureStart.method_10264(), structureEnd.method_10264());
            int minZ = Math.min(structureStart.method_10260(), structureEnd.method_10260());
            int maxZ = Math.max(structureStart.method_10260(), structureEnd.method_10260());
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    int terrainY;
                    class_2338 belowPos;
                    class_2680 belowState;
                    boolean hasBottomBlock;
                    class_2338 bottomPos = new class_2338(x, minY, z);
                    class_2680 bottomState = world.method_8320(bottomPos);
                    boolean bl = hasBottomBlock = !bottomState.method_26215() && !bottomState.method_27852(class_2246.field_10369);
                    if (hasBottomBlock && bottomState.method_27852(class_2246.field_10382)) {
                        hasBottomBlock = false;
                    }
                    if (!hasBottomBlock || !(belowState = world.method_8320(belowPos = new class_2338(x, minY - 1, z))).method_26215() && !belowState.method_26227().method_15767(class_3486.field_15517) || (terrainY = this.findTerrainHeight(world, x, z, minY - 1)) >= minY - 1) continue;
                    this.createTaperedPillar(world, x, z, terrainY, minY - 1, random);
                }
            }
        }

        private int findTerrainHeight(class_5281 world, int x, int z, int startY) {
            for (int y = startY; y >= world.method_31607(); --y) {
                class_2338 pos = new class_2338(x, y, z);
                class_2680 state = world.method_8320(pos);
                if (state.method_26215() || state.method_26227().method_15767(class_3486.field_15517)) continue;
                return y;
            }
            return world.method_31607();
        }

        private void createTaperedPillar(class_5281 world, int centerX, int centerZ, int terrainY, int topY, class_5819 random) {
            int pillarHeight = topY - terrainY;
            class_3541 noiseSampler = new class_3541(random);
            float baseRadiusMultiplier = 2.0f + random.method_43057() * 1.5f;
            float taperingCurve = 0.7f + random.method_43057() * 0.6f;
            if (pillarHeight > 10) {
                baseRadiusMultiplier += (float)(pillarHeight - 10) * 0.1f;
            }
            for (int y = terrainY + 1; y <= topY; ++y) {
                float progress = (float)(y - terrainY) / (float)pillarHeight;
                double noiseScale = 0.1;
                double noise = noiseSampler.method_22416((double)centerX * noiseScale, (double)y * noiseScale * 0.5, (double)centerZ * noiseScale);
                float noiseOffset = (float)noise * 0.5f;
                float radiusFloat = (1.0f - (float)Math.pow(progress, taperingCurve)) * baseRadiusMultiplier + noiseOffset;
                int radius = Math.max(0, (int)Math.ceil(radiusFloat));
                for (int dx = -radius - 1; dx <= radius + 1; ++dx) {
                    for (int dz = -radius - 1; dz <= radius + 1; ++dz) {
                        class_2338 fillPos;
                        class_2680 currentState;
                        double edgeNoise;
                        float edgeVariation;
                        float threshold;
                        int actualX = centerX + dx;
                        int actualZ = centerZ + dz;
                        double distance = Math.sqrt(dx * dx + dz * dz);
                        if (!(distance <= (double)(threshold = (float)radius + 0.5f + (edgeVariation = (float)(edgeNoise = noiseSampler.method_22416((double)actualX * 0.3, (double)y * 0.2, (double)actualZ * 0.3)) * 0.8f))) || !(currentState = world.method_8320(fillPos = new class_2338(actualX, y, actualZ))).method_26215() && !currentState.method_26227().method_15767(class_3486.field_15517)) continue;
                        class_2680 blockToPlace = this.getTerrainMatchingBlock(world, centerX, centerZ, terrainY, random, y, terrainY);
                        world.method_8652(fillPos, blockToPlace, 3);
                    }
                }
            }
        }

        private class_2680 getTerrainMatchingBlock(class_5281 world, int x, int z, int terrainY, class_5819 random, int currentY, int baseY) {
            class_2338 terrainPos = new class_2338(x, terrainY, z);
            class_2680 terrainBlock = world.method_8320(terrainPos);
            int depthFromBase = currentY - baseY;
            float depthRatio = (float)depthFromBase / (float)(terrainY - baseY + 1);
            if (terrainBlock.method_27852(class_2246.field_10102) || terrainBlock.method_27852(class_2246.field_9979)) {
                if (depthRatio < 0.3f) {
                    return class_2246.field_9979.method_9564();
                }
                if (depthRatio < 0.6f) {
                    return random.method_43057() < 0.5f ? class_2246.field_9979.method_9564() : class_2246.field_10102.method_9564();
                }
                return class_2246.field_10102.method_9564();
            }
            if (terrainBlock.method_27852(class_2246.field_10340) || terrainBlock.method_27852(class_2246.field_10445) || terrainBlock.method_27852(class_2246.field_10115) || terrainBlock.method_27852(class_2246.field_10508) || terrainBlock.method_27852(class_2246.field_10474)) {
                if (depthRatio < 0.4f) {
                    return class_2246.field_10340.method_9564();
                }
                float r = random.method_43057();
                if (r < 0.4f) {
                    return class_2246.field_10340.method_9564();
                }
                if (r < 0.6f) {
                    return class_2246.field_10115.method_9564();
                }
                if (r < 0.8f) {
                    return class_2246.field_10445.method_9564();
                }
                return terrainBlock;
            }
            if (terrainBlock.method_27852(class_2246.field_10566) || terrainBlock.method_27852(class_2246.field_10219) || terrainBlock.method_27852(class_2246.field_10253)) {
                if (depthRatio < 0.3f) {
                    return class_2246.field_10340.method_9564();
                }
                if (depthRatio < 0.6f) {
                    return random.method_43057() < 0.5f ? class_2246.field_10253.method_9564() : class_2246.field_10566.method_9564();
                }
                return class_2246.field_10566.method_9564();
            }
            if (terrainBlock.method_27852(class_2246.field_10255)) {
                if (depthRatio < 0.4f) {
                    return random.method_43057() < 0.6f ? class_2246.field_10340.method_9564() : class_2246.field_10255.method_9564();
                }
                return class_2246.field_10255.method_9564();
            }
            if (depthRatio < 0.4f) {
                return class_2246.field_9979.method_9564();
            }
            return class_2246.field_10102.method_9564();
        }

        private void spawnBrines(class_5281 world, class_5819 random) {
            int brineCount = 2 + random.method_43048(1);
            class_2338 structureCenter = this.field_15432.method_10069(this.field_15433.method_15160().method_10263() / 2, this.field_15433.method_15160().method_10264() / 2, this.field_15433.method_15160().method_10260() / 2);
            for (int i = 0; i < brineCount; ++i) {
                BrineEntity brine;
                int offsetZ;
                int offsetY;
                int offsetX = random.method_43048(20) - 10;
                class_2338 spawnPos = structureCenter.method_10069(offsetX, offsetY = random.method_43048(10) - 5, offsetZ = random.method_43048(20) - 10);
                if (!world.method_8316(spawnPos).method_15767(class_3486.field_15517) || (brine = new BrineEntity((class_1299<? extends BrineEntity>)ModEntities.BRINE, (class_1937)world.method_8410())) == null) continue;
                brine.method_5725(spawnPos, 0.0f, 0.0f);
                brine.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16474, null);
                brine.setHomePosition(structureCenter);
                world.method_8649((class_1297)brine);
            }
        }

        public void method_14931(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
            int i = world.method_8624(class_2902.class_2903.field_13195, this.field_15432.method_10263(), this.field_15432.method_10260());
            this.field_15432 = new class_2338(this.field_15432.method_10263(), i, this.field_15432.method_10260());
            super.method_14931(world, structureAccessor, chunkGenerator, random, chunkBox, chunkPos, pivot);
            this.fillUnderStructure(world, chunkBox, random);
            if (this.centerIndex != -1) {
                this.spawnBrines(world, random);
            }
            this.field_15433.method_15165(this.field_15432, this.field_15434, class_2246.field_10465, false).forEach(structureBlockInfo -> {
                String metadata;
                if (structureBlockInfo.comp_1343() != null && !(metadata = structureBlockInfo.comp_1343().method_68564("metadata", "")).isEmpty()) {
                    this.method_15026(metadata, structureBlockInfo.comp_1341(), (class_5425)world, random, chunkBox);
                }
            });
        }
    }
}

