/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class ExplosionUtil {
    public static void createSilentExplosion(class_3218 world, class_243 pos, float power, @Nullable class_1297 sourceEntity) {
        ExplosionUtil.createSilentExplosion(world, pos, power, sourceEntity, null, null, -1.0f, -1.0f);
    }

    public static void createSilentExplosion(class_3218 world, class_243 pos, float power, @Nullable class_1297 sourceEntity, @Nullable class_1297 directHit) {
        ExplosionUtil.createSilentExplosion(world, pos, power, sourceEntity, directHit, null, -1.0f, -1.0f);
    }

    public static void createSilentExplosion(class_3218 world, class_243 pos, float power, @Nullable class_1297 sourceEntity, @Nullable class_1297 directHit, float customDamage, float knockbackMultiplier) {
        ExplosionUtil.createSilentExplosion(world, pos, power, sourceEntity, directHit, null, customDamage, knockbackMultiplier);
    }

    public static void createSilentExplosion(class_3218 world, class_243 pos, float power, @Nullable class_1297 sourceEntity, @Nullable class_1297 directHit, @Nullable class_1282 customDamageSource, float customDamage, float knockbackMultiplier) {
        world.method_43275(sourceEntity, (class_6880)class_5712.field_28178, pos);
        float radius = power * 2.0f;
        int minX = class_3532.method_15357((double)(pos.field_1352 - (double)radius - 1.0));
        int maxX = class_3532.method_15357((double)(pos.field_1352 + (double)radius + 1.0));
        int minY = class_3532.method_15357((double)(pos.field_1351 - (double)radius - 1.0));
        int maxY = class_3532.method_15357((double)(pos.field_1351 + (double)radius + 1.0));
        int minZ = class_3532.method_15357((double)(pos.field_1350 - (double)radius - 1.0));
        int maxZ = class_3532.method_15357((double)(pos.field_1350 + (double)radius + 1.0));
        List entities = world.method_8335(sourceEntity, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        HashMap<class_1657, class_243> affectedPlayers = new HashMap<class_1657, class_243>();
        class_1282 damageSource = customDamageSource != null ? customDamageSource : world.method_48963().method_48819(sourceEntity, (class_1297)ExplosionUtil.getCausingEntity(sourceEntity));
        for (class_1297 class_12972 : entities) {
            class_1657 player;
            class_243 direction;
            double totalDistance;
            class_243 entityCenter;
            double distance;
            double normalizedDistance;
            if (class_12972 == directHit || ExplosionUtil.shouldSkipEntity(class_12972) || !((normalizedDistance = (distance = (entityCenter = ExplosionUtil.getEntityCenter(class_12972)).method_1022(pos)) / (double)radius) <= 1.0) || !((totalDistance = (direction = entityCenter.method_1020(pos)).method_1033()) > 0.0)) continue;
            direction = direction.method_1029();
            float damage = customDamage > 0.0f ? customDamage * (float)(1.0 - normalizedDistance) : ExplosionUtil.calculateImprovedDamage(power, normalizedDistance);
            if (damage > 0.1f) {
                class_12972.method_64397(world, damageSource, damage);
            }
            double exposure = ExplosionUtil.getExposure(pos, class_12972);
            double knockbackStrength = (1.0 - normalizedDistance) * exposure;
            if (knockbackMultiplier > 0.0f) {
                knockbackStrength *= (double)knockbackMultiplier;
            }
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                knockbackStrength *= 1.0 - livingEntity.method_45325(class_5134.field_51580);
            }
            class_243 knockback = direction.method_1021(knockbackStrength);
            class_12972.method_18799(class_12972.method_18798().method_1019(knockback));
            if (!(!(class_12972 instanceof class_1657) || (player = (class_1657)class_12972).method_7325() || player.method_68878() && player.method_31549().field_7479)) {
                affectedPlayers.put(player, knockback);
            }
            class_12972.method_56918(sourceEntity);
        }
        for (Map.Entry entry : affectedPlayers.entrySet()) {
            class_1657 player = (class_1657)entry.getKey();
            player.field_64356 = true;
        }
    }

    private static boolean shouldSkipEntity(class_1297 entity) {
        if (entity instanceof class_1542) {
            return true;
        }
        return entity instanceof class_1303;
    }

    private static class_243 getEntityCenter(class_1297 entity) {
        class_238 box = entity.method_5829();
        return new class_243((box.field_1323 + box.field_1320) * 0.5, (box.field_1322 + box.field_1325) * 0.5, (box.field_1321 + box.field_1324) * 0.5);
    }

    private static float calculateImprovedDamage(float power, double normalizedDistance) {
        float maxDamage = power * 7.0f;
        return (float)((double)maxDamage * (1.0 - normalizedDistance));
    }

    private static float calculateDamage(float power, double distance) {
        float maxDamage = (power * 2.0f + 1.0f) * 8.0f;
        return (float)((double)maxDamage * (1.0 - distance));
    }

    private static float getExposure(class_243 source, class_1297 entity) {
        class_238 box = entity.method_5829();
        double stepX = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
        double stepY = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
        double stepZ = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
        double offsetX = (1.0 - Math.floor(1.0 / stepX) * stepX) / 2.0;
        double offsetZ = (1.0 - Math.floor(1.0 / stepZ) * stepZ) / 2.0;
        if (stepX < 0.0 || stepY < 0.0 || stepZ < 0.0) {
            return 0.0f;
        }
        int visiblePoints = 0;
        int totalPoints = 0;
        for (double x = 0.0; x <= 1.0; x += stepX) {
            for (double y = 0.0; y <= 1.0; y += stepY) {
                for (double z = 0.0; z <= 1.0; z += stepZ) {
                    double pointX = class_3532.method_16436((double)x, (double)box.field_1323, (double)box.field_1320);
                    double pointY = class_3532.method_16436((double)y, (double)box.field_1322, (double)box.field_1325);
                    double pointZ = class_3532.method_16436((double)z, (double)box.field_1321, (double)box.field_1324);
                    class_243 point = new class_243(pointX + offsetX, pointY, pointZ + offsetZ);
                    if (entity.method_73183().method_17742(new class_3959(point, source, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333) {
                        ++visiblePoints;
                    }
                    ++totalPoints;
                }
            }
        }
        return (float)visiblePoints / (float)totalPoints;
    }

    @Nullable
    private static class_1309 getCausingEntity(@Nullable class_1297 from) {
        class_1676 projectileEntity;
        class_1297 owner;
        if (from == null) {
            return null;
        }
        if (from instanceof class_1541) {
            class_1541 tntEntity = (class_1541)from;
            return tntEntity.method_6970();
        }
        if (from instanceof class_1309) {
            class_1309 livingEntity = (class_1309)from;
            return livingEntity;
        }
        if (from instanceof class_1676 && (owner = (projectileEntity = (class_1676)from).method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)owner;
            return livingEntity;
        }
        return null;
    }

    public static void createSilentExplosion(class_3218 world, class_243 pos, float radius, float damage, double areaKnockback, double directHitKnockback, @Nullable class_1297 directHit) {
        ExplosionUtil.createSilentExplosion(world, pos, radius, null, directHit, null, damage, (float)areaKnockback);
    }
}

