/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.world.feature.custom;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5721;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_5861;
import potatowolfie.earth_and_water.block.ModBlocks;
import potatowolfie.earth_and_water.world.feature.custom.DarkDripstoneClusterFeatureConfig;
import potatowolfie.earth_and_water.world.feature.custom.DarkDripstoneHelper;

public class DarkDripstoneClusterFeature
extends class_3031<DarkDripstoneClusterFeatureConfig> {
    public DarkDripstoneClusterFeature(Codec<DarkDripstoneClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<DarkDripstoneClusterFeatureConfig> context) {
        class_5281 structureWorldAccess = context.method_33652();
        class_2338 blockPos = context.method_33655();
        DarkDripstoneClusterFeatureConfig DarkdripstoneClusterFeatureConfig = (DarkDripstoneClusterFeatureConfig)context.method_33656();
        class_5819 random = context.method_33654();
        if (!DarkDripstoneHelper.canGenerate((class_1936)structureWorldAccess, blockPos)) {
            return false;
        }
        int i = DarkdripstoneClusterFeatureConfig.height.method_35008(random);
        float f = DarkdripstoneClusterFeatureConfig.wetness.method_33920(random);
        float g = DarkdripstoneClusterFeatureConfig.density.method_33920(random);
        int j = DarkdripstoneClusterFeatureConfig.radius.method_35008(random);
        int k = DarkdripstoneClusterFeatureConfig.radius.method_35008(random);
        for (int l = -j; l <= j; ++l) {
            for (int m = -k; m <= k; ++m) {
                double d = this.DarkdripstoneChance(j, k, l, m, DarkdripstoneClusterFeatureConfig);
                class_2338 blockPos2 = blockPos.method_10069(l, 0, m);
                this.generate(structureWorldAccess, random, blockPos2, l, m, f, d, i, g, DarkdripstoneClusterFeatureConfig);
            }
        }
        return true;
    }

    private void generate(class_5281 world, class_5819 random, class_2338 pos, int localX, int localZ, float wetness, double DarkdripstoneChance, int height, float density, DarkDripstoneClusterFeatureConfig config) {
        Optional optional = class_5721.method_32982((class_3746)world, (class_2338)pos, (int)config.floorToCeilingSearchRange, DarkDripstoneHelper::canGenerate, DarkDripstoneHelper::cannotGenerate);
        if (!optional.isEmpty()) {
            OptionalInt optionalInt = ((class_5721)optional.get()).method_32985();
            OptionalInt optionalInt2 = ((class_5721)optional.get()).method_32987();
            if (!optionalInt.isEmpty() || !optionalInt2.isEmpty()) {
                boolean bl4;
                int t;
                int m;
                boolean bl3;
                int l;
                int j;
                boolean bl2;
                class_5721 caveSurface;
                boolean bl;
                boolean bl5 = bl = random.method_43057() < wetness;
                if (bl && optionalInt2.isPresent() && this.canWaterSpawn(world, pos.method_33096(optionalInt2.getAsInt()))) {
                    int i = optionalInt2.getAsInt();
                    caveSurface = ((class_5721)optional.get()).method_32983(OptionalInt.of(i - 1));
                    world.method_8652(pos.method_33096(i), class_2246.field_10382.method_9564(), 2);
                } else {
                    caveSurface = (class_5721)optional.get();
                }
                OptionalInt optionalInt3 = caveSurface.method_32987();
                boolean bl6 = bl2 = random.method_43058() < DarkdripstoneChance;
                if (optionalInt.isPresent() && bl2 && !this.isLava((class_4538)world, pos.method_33096(optionalInt.getAsInt()))) {
                    j = config.dripstoneBlockLayerThickness.method_35008(random);
                    this.placeDarkDripstoneBlocks(world, pos.method_33096(optionalInt.getAsInt()), j, class_2350.field_11036);
                    int k = optionalInt3.isPresent() ? Math.min(height, optionalInt.getAsInt() - optionalInt3.getAsInt()) : height;
                    l = this.getHeight(random, localX, localZ, density, k, config);
                } else {
                    l = 0;
                }
                boolean bl7 = bl3 = random.method_43058() < DarkdripstoneChance;
                if (optionalInt3.isPresent() && bl3 && !this.isLava((class_4538)world, pos.method_33096(optionalInt3.getAsInt()))) {
                    m = config.dripstoneBlockLayerThickness.method_35008(random);
                    this.placeDarkDripstoneBlocks(world, pos.method_33096(optionalInt3.getAsInt()), m, class_2350.field_11033);
                    j = optionalInt.isPresent() ? Math.max(0, l + class_3532.method_32751((class_5819)random, (int)(-config.maxStalagmiteStalactiteHeightDiff), (int)config.maxStalagmiteStalactiteHeightDiff)) : this.getHeight(random, localX, localZ, density, height, config);
                } else {
                    j = 0;
                }
                if (optionalInt.isPresent() && optionalInt3.isPresent() && optionalInt.getAsInt() - l <= optionalInt3.getAsInt() + j) {
                    int n = optionalInt3.getAsInt();
                    int o = optionalInt.getAsInt();
                    int p = Math.max(o - l, n + 1);
                    int q = Math.min(n + j, o - 1);
                    int r = class_3532.method_32751((class_5819)random, (int)p, (int)(q + 1));
                    int s = r - 1;
                    m = o - r;
                    t = s - n;
                } else {
                    m = l;
                    t = j;
                }
                m = Math.min(m, random.method_43056() ? 2 : 3);
                t = Math.min(t, random.method_43056() ? 2 : 3);
                boolean bl8 = bl4 = random.method_43056() && m > 0 && t > 0 && caveSurface.method_33385().isPresent() && m + t == caveSurface.method_33385().getAsInt();
                if (optionalInt.isPresent()) {
                    DarkDripstoneHelper.generatePointedDarkDripstone((class_1936)world, pos.method_33096(optionalInt.getAsInt() - 1), class_2350.field_11033, m, bl4);
                }
                if (optionalInt3.isPresent()) {
                    DarkDripstoneHelper.generatePointedDarkDripstone((class_1936)world, pos.method_33096(optionalInt3.getAsInt() + 1), class_2350.field_11036, t, bl4);
                }
            }
        }
    }

    private boolean isLava(class_4538 world, class_2338 pos) {
        return world.method_8320(pos).method_27852(class_2246.field_10164);
    }

    private int getHeight(class_5819 random, int localX, int localZ, float density, int height, DarkDripstoneClusterFeatureConfig config) {
        if (random.method_43057() > density) {
            return 0;
        }
        int i = Math.abs(localX) + Math.abs(localZ);
        float f = (float)class_3532.method_32854((double)i, (double)0.0, (double)config.maxDistanceFromCenterAffectingHeightBias, (double)((double)height / 2.0), (double)0.0);
        return (int)DarkDripstoneClusterFeature.clampedGaussian(random, 0.0f, height, f, config.heightDeviation);
    }

    private boolean canWaterSpawn(class_5281 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!(blockState.method_27852(class_2246.field_10382) || blockState.method_27852(ModBlocks.DARK_DRIPSTONE_BLOCK) || blockState.method_27852(ModBlocks.POINTED_DARK_DRIPSTONE))) {
            class_2350 direction;
            if (world.method_8320(pos.method_10084()).method_26227().method_15767(class_3486.field_15517)) {
                return false;
            }
            Iterator var4 = class_2350.class_2353.field_11062.iterator();
            do {
                if (var4.hasNext()) continue;
                return this.isStoneOrWater((class_1936)world, pos.method_10074());
            } while (this.isStoneOrWater((class_1936)world, pos.method_10093(direction = (class_2350)var4.next())));
            return false;
        }
        return false;
    }

    private boolean isStoneOrWater(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26164(class_3481.field_25806) || blockState.method_26227().method_15767(class_3486.field_15517);
    }

    private void placeDarkDripstoneBlocks(class_5281 world, class_2338 pos, int height, class_2350 direction) {
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 0; i < height; ++i) {
            if (!DarkDripstoneHelper.generateDarkDripstoneBlock((class_1936)world, (class_2338)mutable)) {
                return;
            }
            mutable.method_10098(direction);
        }
    }

    private double DarkdripstoneChance(int radiusX, int radiusZ, int localX, int localZ, DarkDripstoneClusterFeatureConfig config) {
        int i = radiusX - Math.abs(localX);
        int j = radiusZ - Math.abs(localZ);
        int k = Math.min(i, j);
        return class_3532.method_37958((float)k, (float)0.0f, (float)config.maxDistanceFromCenterAffectingChanceOfDripstoneColumn, (float)config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, (float)1.0f);
    }

    private static float clampedGaussian(class_5819 random, float min, float max, float mean, float deviation) {
        return class_5861.method_33903((class_5819)random, (float)mean, (float)deviation, (float)min, (float)max);
    }
}

