/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.world.feature.custom;

import java.util.function.Consumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5691;
import potatowolfie.earth_and_water.block.ModBlocks;
import potatowolfie.earth_and_water.block.custom.PointedDarkDripstoneBlock;

public class DarkDripstoneHelper {
    protected static double scaleHeightFromRadius(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double d = 0.384;
        double e = radius / scale * 0.384;
        double f = 0.75 * Math.pow(e, 1.3333333333333333);
        double g = Math.pow(e, 0.6666666666666666);
        double h = 0.3333333333333333 * Math.log(e);
        double i = heightScale * (f - g - h);
        i = Math.max(i, 0.0);
        return i / 0.384 * scale;
    }

    protected static boolean canGenerateBase(class_5281 world, class_2338 pos, int height) {
        if (DarkDripstoneHelper.canGenerateOrLava((class_1936)world, pos)) {
            return false;
        }
        float f = 6.0f;
        float g = 6.0f / (float)height;
        for (float h = 0.0f; h < (float)Math.PI * 2; h += g) {
            int j;
            int i = (int)(class_3532.method_15362((double)h) * (float)height);
            if (!DarkDripstoneHelper.canGenerateOrLava((class_1936)world, pos.method_10069(i, 0, j = (int)(class_3532.method_15374((double)h) * (float)height)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean canGenerate(class_1936 world, class_2338 pos) {
        return world.method_16358(pos, DarkDripstoneHelper::canGenerate);
    }

    protected static boolean canGenerateOrLava(class_1936 world, class_2338 pos) {
        return world.method_16358(pos, DarkDripstoneHelper::canGenerateOrLava);
    }

    protected static void getDripstoneThickness(class_2350 direction, int height, boolean merge, Consumer<class_2680> callback) {
        if (height >= 3) {
            callback.accept(DarkDripstoneHelper.getState(direction, class_5691.field_28068));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(DarkDripstoneHelper.getState(direction, class_5691.field_28067));
            }
        }
        if (height >= 2) {
            callback.accept(DarkDripstoneHelper.getState(direction, class_5691.field_28066));
        }
        if (height >= 1) {
            callback.accept(DarkDripstoneHelper.getState(direction, merge ? class_5691.field_28064 : class_5691.field_28065));
        }
    }

    protected static void generatePointedDarkDripstone(class_1936 world, class_2338 pos, class_2350 direction, int height, boolean merge) {
        if (DarkDripstoneHelper.canReplace(world.method_8320(pos.method_10093(direction.method_10153())))) {
            class_2338.class_2339 mutable = pos.method_25503();
            DarkDripstoneHelper.getDripstoneThickness(direction, height, merge, state -> {
                if (state.method_27852(ModBlocks.POINTED_DARK_DRIPSTONE)) {
                    state = (class_2680)state.method_11657((class_2769)PointedDarkDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.method_22351((class_2338)mutable)));
                }
                world.method_8652((class_2338)mutable, state, 2);
                mutable.method_10098(direction);
            });
        }
    }

    protected static boolean generateDarkDripstoneBlock(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26164(class_3481.field_28089)) {
            world.method_8652(pos, ModBlocks.DARK_DRIPSTONE_BLOCK.method_9564(), 2);
            return true;
        }
        return false;
    }

    private static class_2680 getState(class_2350 direction, class_5691 thickness) {
        return (class_2680)((class_2680)ModBlocks.POINTED_DARK_DRIPSTONE.method_9564().method_11657(PointedDarkDripstoneBlock.VERTICAL_DIRECTION, (Comparable)direction)).method_11657(PointedDarkDripstoneBlock.THICKNESS, (Comparable)thickness);
    }

    public static boolean canReplaceOrLava(class_2680 state) {
        return DarkDripstoneHelper.canReplace(state) || state.method_27852(class_2246.field_10164);
    }

    public static boolean canReplace(class_2680 state) {
        return state.method_27852(ModBlocks.DARK_DRIPSTONE_BLOCK) || state.method_26164(class_3481.field_28089);
    }

    public static boolean canGenerate(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382);
    }

    public static boolean cannotGenerate(class_2680 state) {
        return !state.method_26215() && !state.method_27852(class_2246.field_10382);
    }

    public static boolean canGenerateOrLava(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164);
    }
}

