/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.earth_and_water.world.feature.custom.limestone_rock;

import com.mojang.serialization.Codec;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import potatowolfie.earth_and_water.block.ModBlocks;
import potatowolfie.earth_and_water.world.feature.custom.limestone_rock.LimestoneRockFeatureConfig;

public class LimestoneRockFeature
extends class_3031<LimestoneRockFeatureConfig> {
    public LimestoneRockFeature(Codec<LimestoneRockFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<LimestoneRockFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 random = context.method_33654();
        class_2338 oceanFloor = this.findOceanFloorPosition(world, pos);
        if (oceanFloor == null) {
            return false;
        }
        int bigHeight = 3 + random.method_43048(3);
        int bigWidth = 3 + random.method_43048(2);
        int smallHeight = 2 + random.method_43048(2);
        int smallWidth = 2 + random.method_43048(2);
        int corner = random.method_43048(4);
        this.generateSupport(world, oceanFloor, bigWidth, random);
        this.generateBigRock(world, oceanFloor, bigWidth, bigHeight, random);
        this.generateSmallRock(world, oceanFloor, bigWidth, smallWidth, smallHeight, corner, random);
        return true;
    }

    private class_2338 findOceanFloorPosition(class_5281 world, class_2338 startPos) {
        class_2338.class_2339 mutablePos = startPos.method_25503();
        while (mutablePos.method_10264() < 63 && !world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382)) {
            mutablePos.method_10100(0, 1, 0);
        }
        boolean foundWater = false;
        for (int i = 0; i < 64; ++i) {
            if (world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382)) {
                foundWater = true;
                break;
            }
            mutablePos.method_10100(0, -1, 0);
        }
        if (!foundWater) {
            return null;
        }
        while (mutablePos.method_10264() > world.method_31607()) {
            class_2338 below = mutablePos.method_10074();
            class_2680 belowState = world.method_8320(below);
            if (!belowState.method_27852(class_2246.field_10382) && !belowState.method_26215() && world.method_8320((class_2338)mutablePos).method_27852(class_2246.field_10382)) {
                if (!this.isFlatArea(world, (class_2338)mutablePos)) {
                    return null;
                }
                return mutablePos;
            }
            mutablePos.method_10100(0, -1, 0);
        }
        return null;
    }

    private boolean isFlatArea(class_5281 world, class_2338 center) {
        int checkRadius = 3;
        int baseY = center.method_10264();
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int z = -checkRadius; z <= checkRadius; ++z) {
                class_2338 checkPos = center.method_10069(x, 0, z);
                class_2338 below = checkPos.method_10074();
                class_2680 belowState = world.method_8320(below);
                if (belowState.method_27852(class_2246.field_9993) || belowState.method_27852(class_2246.field_10463) || belowState.method_27852(class_2246.field_10376) || belowState.method_27852(class_2246.field_10238)) continue;
                if (belowState.method_27852(class_2246.field_10382) || belowState.method_26215()) {
                    return false;
                }
                int yDiff = Math.abs(checkPos.method_10264() - baseY);
                if (yDiff <= 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean canReplaceBlock(class_5281 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10102) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10460) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_28888) || state.method_27852(class_2246.field_10474) || state.method_27852(class_2246.field_10115) || state.method_27852(class_2246.field_10508)) {
            return true;
        }
        return state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_9993) || state.method_27852(class_2246.field_10463) || state.method_27852(class_2246.field_10376) || state.method_27852(class_2246.field_10238);
    }

    private void generateBigRock(class_5281 world, class_2338 center, int width, int height, class_5819 random) {
        int y;
        int extraHeight;
        int halfWidth = (width - 1) / 2;
        boolean skipNE = random.method_43057() < 0.5f;
        boolean skipSE = random.method_43057() < 0.5f;
        boolean skipSW = random.method_43057() < 0.5f;
        boolean skipNW = random.method_43057() < 0.5f;
        for (int y2 = 0; y2 < height; ++y2) {
            int currentSize = halfWidth;
            boolean isTopLayer = y2 == height - 1;
            for (int x = -currentSize; x <= currentSize; ++x) {
                for (int z = -currentSize; z <= currentSize; ++z) {
                    class_2338 pos;
                    float randomFactor;
                    float maxDist;
                    float distFromCenter;
                    boolean skipColumn = false;
                    if (x == currentSize && z == -currentSize && skipNE) {
                        skipColumn = true;
                    }
                    if (x == currentSize && z == currentSize && skipSE) {
                        skipColumn = true;
                    }
                    if (x == -currentSize && z == currentSize && skipSW) {
                        skipColumn = true;
                    }
                    if (x == -currentSize && z == -currentSize && skipNW) {
                        skipColumn = true;
                    }
                    boolean placeBlock = true;
                    if (isTopLayer && (distFromCenter = (float)Math.sqrt(x * x + z * z)) > (maxDist = (float)halfWidth * (randomFactor = 0.7f + random.method_43057() * 0.3f))) {
                        placeBlock = false;
                    }
                    if (skipColumn || !placeBlock || !this.canReplaceBlock(world, pos = center.method_10069(x, y2, z))) continue;
                    world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
                }
            }
        }
        if (skipNE && random.method_43057() < 0.35f) {
            extraHeight = 1 + random.method_43048(2);
            for (y = 0; y < extraHeight; ++y) {
                class_2338 pos = center.method_10069(halfWidth, y, -halfWidth);
                if (!this.canReplaceBlock(world, pos)) continue;
                world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
            }
        }
        if (skipSE && random.method_43057() < 0.35f) {
            extraHeight = 1 + random.method_43048(2);
            for (y = 0; y < extraHeight; ++y) {
                class_2338 pos = center.method_10069(halfWidth, y, halfWidth);
                if (!this.canReplaceBlock(world, pos)) continue;
                world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
            }
        }
        if (skipSW && random.method_43057() < 0.35f) {
            extraHeight = 1 + random.method_43048(2);
            for (y = 0; y < extraHeight; ++y) {
                class_2338 pos = center.method_10069(-halfWidth, y, halfWidth);
                if (!this.canReplaceBlock(world, pos)) continue;
                world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
            }
        }
        if (skipNW && random.method_43057() < 0.35f) {
            extraHeight = 1 + random.method_43048(2);
            for (y = 0; y < extraHeight; ++y) {
                class_2338 pos = center.method_10069(-halfWidth, y, -halfWidth);
                if (!this.canReplaceBlock(world, pos)) continue;
                world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
            }
        }
    }

    private void generateSupport(class_5281 world, class_2338 center, int width, class_5819 random) {
        int halfWidth = (width - 1) / 2;
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            block1: for (int z = -halfWidth; z <= halfWidth; ++z) {
                class_2338 supportPos;
                class_2680 state;
                class_2338 checkPos = center.method_10069(x, -1, z);
                class_2680 belowState = world.method_8320(checkPos);
                if (!belowState.method_27852(class_2246.field_10382) && !belowState.method_26215() && !belowState.method_27852(class_2246.field_9993) && !belowState.method_27852(class_2246.field_10463) && !belowState.method_27852(class_2246.field_10376) && !belowState.method_27852(class_2246.field_10238)) continue;
                for (int y = -1; y >= -10 && ((state = world.method_8320(supportPos = center.method_10069(x, y, z))).method_27852(class_2246.field_10382) || state.method_26215() || state.method_27852(class_2246.field_9993) || state.method_27852(class_2246.field_10463) || state.method_27852(class_2246.field_10376) || state.method_27852(class_2246.field_10238)); --y) {
                    world.method_8652(supportPos, ModBlocks.LIMESTONE.method_9564(), 2);
                    class_2680 checkBelow = world.method_8320(supportPos.method_10074());
                    if (!checkBelow.method_27852(class_2246.field_10382) && !checkBelow.method_26215() && !checkBelow.method_27852(class_2246.field_9993) && !checkBelow.method_27852(class_2246.field_10463) && !checkBelow.method_27852(class_2246.field_10376) && !checkBelow.method_27852(class_2246.field_10238)) continue block1;
                }
            }
        }
    }

    private void generateSmallRock(class_5281 world, class_2338 bigRockCenter, int bigWidth, int smallWidth, int smallHeight, int corner, class_5819 random) {
        int bigHalf = (bigWidth - 1) / 2;
        int smallHalf = smallWidth / 2;
        int xOffset = 0;
        int zOffset = 0;
        switch (corner) {
            case 0: {
                xOffset = bigHalf + smallHalf;
                zOffset = -(bigHalf + smallHalf);
                break;
            }
            case 1: {
                xOffset = bigHalf + smallHalf;
                zOffset = bigHalf + smallHalf;
                break;
            }
            case 2: {
                xOffset = -(bigHalf + smallHalf);
                zOffset = bigHalf + smallHalf;
                break;
            }
            case 3: {
                xOffset = -(bigHalf + smallHalf);
                zOffset = -(bigHalf + smallHalf);
            }
        }
        class_2338 smallRockCenter = bigRockCenter.method_10069(xOffset, 0, zOffset);
        this.generateSupport(world, smallRockCenter, smallWidth, random);
        boolean skipNE = random.method_43057() < 0.15f;
        boolean skipSE = random.method_43057() < 0.15f;
        boolean skipSW = random.method_43057() < 0.15f;
        boolean skipNW = random.method_43057() < 0.15f;
        for (int y = 0; y < smallHeight; ++y) {
            int currentSize = smallHalf;
            boolean isTopLayer = y == smallHeight - 1;
            for (int x = -currentSize; x <= currentSize; ++x) {
                for (int z = -currentSize; z <= currentSize; ++z) {
                    float randomFactor;
                    float maxDist;
                    float distFromCenter;
                    class_2338 pos = smallRockCenter.method_10069(x, y, z);
                    boolean isConnectingCorner = false;
                    if (isTopLayer) {
                        switch (corner) {
                            case 0: {
                                isConnectingCorner = x <= 0 && z >= 0;
                                break;
                            }
                            case 1: {
                                isConnectingCorner = x <= 0 && z <= 0;
                                break;
                            }
                            case 2: {
                                isConnectingCorner = x >= 0 && z <= 0;
                                break;
                            }
                            case 3: {
                                isConnectingCorner = x >= 0 && z >= 0;
                            }
                        }
                    }
                    boolean skipColumn = false;
                    if (x == currentSize && z == -currentSize && skipNE) {
                        skipColumn = true;
                    }
                    if (x == currentSize && z == currentSize && skipSE) {
                        skipColumn = true;
                    }
                    if (x == -currentSize && z == currentSize && skipSW) {
                        skipColumn = true;
                    }
                    if (x == -currentSize && z == -currentSize && skipNW) {
                        skipColumn = true;
                    }
                    boolean placeBlock = true;
                    if (isTopLayer && !isConnectingCorner && (distFromCenter = (float)Math.sqrt(x * x + z * z)) > (maxDist = (float)smallHalf * (randomFactor = 0.7f + random.method_43057() * 0.5f))) {
                        placeBlock = false;
                    }
                    if (skipColumn || !placeBlock || !this.canReplaceBlock(world, pos)) continue;
                    world.method_8652(pos, ModBlocks.LIMESTONE.method_9564(), 2);
                }
            }
        }
    }
}

