/*
 * Decompiled with CFR 0.152.
 */
package net.kloodoh.smokeshow.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.kloodoh.smokeshow.TintState;
import net.kloodoh.smokeshow.net.CampfireColorBulkPayload;
import net.kloodoh.smokeshow.net.CampfireColorUpdatePayload;
import net.minecraft.class_1132;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_5218;

@Environment(value=EnvType.CLIENT)
public final class TintPersistence {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, Integer>>(){}.getType();
    private static final String FILE_NAME = "smokeshow.json";

    private TintPersistence() {
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(CampfireColorUpdatePayload.ID, (payload, context) -> context.client().execute(() -> TintState.set(payload.pos(), payload.color())));
        ClientPlayNetworking.registerGlobalReceiver(CampfireColorBulkPayload.ID, (payload, context) -> {
            HashMap<class_2338, Integer> map = payload.colors();
            context.client().execute(() -> TintState.putAll(map));
        });
    }

    public static void load(class_310 client) {
        if (client == null) {
            return;
        }
        Path file = TintPersistence.configFile(client);
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        Map raw = new HashMap();
        try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            raw = (Map)GSON.fromJson((Reader)reader, MAP_TYPE);
        }
        catch (IOException e) {
            return;
        }
        if (raw == null || raw.isEmpty()) {
            return;
        }
        HashMap<class_2338, Integer> parsed = new HashMap<class_2338, Integer>();
        for (Map.Entry e : raw.entrySet()) {
            class_2338 pos = TintPersistence.parseKey((String)e.getKey());
            if (pos == null || e.getValue() == null) continue;
            parsed.put(pos, (Integer)e.getValue());
        }
        TintState.putAll(parsed);
    }

    public static void save(class_310 client) {
        if (client == null) {
            return;
        }
        Path file = TintPersistence.configFile(client);
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HashMap<String, Integer> raw = new HashMap<String, Integer>();
        for (Map.Entry<class_2338, Integer> e : TintState.snapshot().entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            raw.put(TintPersistence.keyOf(e.getKey()), e.getValue());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(raw, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Path configFile(class_310 client) {
        block4: {
            try {
                class_1132 srv;
                if (client == null || (srv = client.method_1576()) == null) break block4;
                Path root = srv.method_27050(class_5218.field_24188);
                Path dir = root.resolve("data").resolve("smokeshow");
                try {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dir.resolve(FILE_NAME);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return client.field_1697.toPath().resolve("config").resolve("smokeshow").resolve(FILE_NAME);
    }

    private static String keyOf(class_2338 pos) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
    }

    private static class_2338 parseKey(String s) {
        if (s == null) {
            return null;
        }
        String[] parts = s.split(",", 3);
        if (parts.length != 3) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[0].trim());
            int y = Integer.parseInt(parts[1].trim());
            int z = Integer.parseInt(parts[2].trim());
            return new class_2338(x, y, z);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

