/*
 * Decompiled with CFR 0.152.
 */
package net.kloodoh.smokeshow.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.kloodoh.smokeshow.TintState;
import net.minecraft.class_1132;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_642;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public final class TintStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String MOD_DIR = "smokeshow";
    private static final String TINTS_DIR = "tints";
    private static final String TINTS_FILE = "smokeshow.json";
    private static volatile String currentScopeId = "unknown";
    private static volatile long lastSaveNanos = 0L;

    private TintStorage() {
    }

    public static void loadAsync(class_310 client) {
        String scope = currentScopeId = TintStorage.computeScopeId(client);
        CompletableFuture.runAsync(() -> {
            Map<class_2338, Integer> data = TintStorage.readFromDisk(scope);
            if (data == null || client == null) {
                return;
            }
            client.execute(() -> {
                TintState.replaceAll(data);
                LOGGER.info("[Smokeshow] Loaded {} smoke tints for scope '{}'", (Object)data.size(), (Object)scope);
            });
        });
    }

    public static void saveAsync(class_310 client) {
        String scope;
        currentScopeId = scope = client == null ? currentScopeId : TintStorage.computeScopeId(client);
        HashMap<class_2338, Integer> snapshot = new HashMap<class_2338, Integer>(TintState.snapshot());
        CompletableFuture.runAsync(() -> TintStorage.writeToDisk(scope, snapshot));
    }

    public static void saveDebounced(class_310 client) {
        long now = System.nanoTime();
        if (now - lastSaveNanos > 500000000L) {
            lastSaveNanos = now;
            TintStorage.saveAsync(client);
        }
    }

    private static String computeScopeId(class_310 client) {
        try {
            if (client == null) {
                return "unknown";
            }
            class_642 info = client.method_1558();
            if (info != null) {
                String base;
                if (info.method_52811()) {
                    base = "realms_" + (info.field_3752 == null ? "unnamed" : info.field_3752);
                } else {
                    String addr = info.field_3761 == null || info.field_3761.isBlank() ? (info.field_3752 == null ? "unnamed" : info.field_3752) : info.field_3761;
                    base = "mp_" + addr;
                }
                return TintStorage.sanitize(base);
            }
            class_1132 srv = client.method_1576();
            if (srv != null) {
                Path root = srv.method_27050(class_5218.field_24188);
                String worldFolder = root == null ? "unknown" : TintStorage.lastName(root);
                return TintStorage.sanitize("sp_" + worldFolder);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("[Smokeshow] computeScopeId failed; using 'unknown'", t);
        }
        return "unknown";
    }

    private static String lastName(Path p) {
        try {
            Path name = p.getFileName();
            if (name != null) {
                return name.toString();
            }
            int n = p.getNameCount();
            if (n > 0) {
                return p.getName(n - 1).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "world";
    }

    private static String sanitize(String in) {
        String s = in == null ? "unknown" : in.toLowerCase();
        s = s.replaceAll("[^a-z0-9._-]+", "_").replaceAll("_+", "_").replaceAll("^_+|_+$", "");
        return s.isBlank() ? "unknown" : s;
    }

    private static Path scopedDir(String scopeId) {
        block6: {
            try {
                class_1132 srv;
                class_310 client = class_310.method_1551();
                if (client == null || (srv = client.method_1576()) == null) break block6;
                Path root = srv.method_27050(class_5218.field_24188);
                Path dir = root.resolve("data").resolve(MOD_DIR);
                try {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dir;
            }
            catch (Throwable client) {
                // empty catch block
            }
        }
        Path dir = FabricLoader.getInstance().getConfigDir().resolve(MOD_DIR).resolve(TINTS_DIR).resolve(scopeId);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dir;
    }

    private static Path scopedFile(String scopeId) {
        return TintStorage.scopedDir(scopeId).resolve(TINTS_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<class_2338, Integer> readFromDisk(String scope) {
        Path file = TintStorage.scopedFile(scope);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            JsonObject root = (JsonObject)GSON.fromJson((Reader)br, JsonObject.class);
            if (root == null) {
                Map<class_2338, Integer> map = null;
                return map;
            }
            JsonArray arr = root.getAsJsonArray("entries");
            HashMap<class_2338, Integer> map = new HashMap<class_2338, Integer>();
            if (arr != null) {
                for (JsonElement el : arr) {
                    if (!el.isJsonObject()) continue;
                    JsonObject o = el.getAsJsonObject();
                    int x = o.get("x").getAsInt();
                    int y = o.get("y").getAsInt();
                    int z = o.get("z").getAsInt();
                    int rgb = o.get("rgb").getAsInt();
                    map.put(new class_2338(x, y, z), rgb);
                }
            }
            HashMap<class_2338, Integer> hashMap = map;
            return hashMap;
        }
        catch (Throwable t) {
            LOGGER.error("[Smokeshow] Failed to load tints.json for scope '{}'", (Object)scope, (Object)t);
            return null;
        }
    }

    private static void writeToDisk(String scope, Map<class_2338, Integer> snapshot) {
        Path file = TintStorage.scopedFile(scope);
        JsonObject root = new JsonObject();
        root.addProperty("schema", (Number)1);
        root.addProperty("scope", scope);
        JsonArray arr = new JsonArray();
        for (Map.Entry<class_2338, Integer> e : snapshot.entrySet()) {
            class_2338 p = e.getKey();
            JsonObject o = new JsonObject();
            o.addProperty("x", (Number)p.method_10263());
            o.addProperty("y", (Number)p.method_10264());
            o.addProperty("z", (Number)p.method_10260());
            o.addProperty("rgb", (Number)e.getValue());
            arr.add((JsonElement)o);
        }
        root.add("entries", (JsonElement)arr);
        try (BufferedWriter bw = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)root, (Appendable)bw);
            LOGGER.info("[Smokeshow] Saved {} smoke tints to {}", (Object)snapshot.size(), (Object)file);
        }
        catch (Throwable t) {
            LOGGER.error("[Smokeshow] Failed to save tints.json for scope '{}'", (Object)scope, (Object)t);
        }
    }
}

