/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.mojang.blaze3d.platform.InputConstants;
import com.onewhohears.dscombat.client.input.forge.DSCKeysImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DSCKeys {
    public static final String VEHICLE_MOVE_CONTROL = "key.categories.vehicle_move_control";
    public static final String VEHICLE_CONTROL_UTIL = "key.categories.vehicle_control_util";
    public static final String VEHICLE_PASSENGER_CONTROL = "key.categories.vehicle_passenger_control";
    public static final String VEHICLE_COMBAT_CONTROL = "key.categories.vehicle_combat_control";
    public static KeyMapping throttleUpKey;
    public static KeyMapping throttleDownKey;
    public static KeyMapping pitchUpKey;
    public static KeyMapping pitchDownKey;
    public static KeyMapping rollLeftKey;
    public static KeyMapping rollRightKey;
    public static KeyMapping yawLeftKey;
    public static KeyMapping yawRightKey;
    public static KeyMapping weaponSelectKey;
    public static KeyMapping weaponSelect2Key;
    public static KeyMapping mouseModeKey;
    public static KeyMapping resetMouseKey;
    public static KeyMapping cameraTrackTargetKey;
    public static KeyMapping gimbalKey;
    public static KeyMapping shootKey;
    public static KeyMapping landingGear;
    public static KeyMapping flareKey;
    public static KeyMapping chaffKey;
    public static KeyMapping vehicleMenuKey;
    public static KeyMapping pingCycleKey;
    public static KeyMapping radarModeKey;
    public static KeyMapping changeSeat;
    public static KeyMapping dismount;
    public static KeyMapping eject;
    public static KeyMapping specialKey;
    public static KeyMapping special2Key;
    public static KeyMapping flipControlsKey;
    public static KeyMapping leanLeftKey;
    public static KeyMapping leanRightKey;
    public static KeyMapping afterBurnerKey;
    public static KeyMapping turnAssistKey;
    public static KeyMapping hudModeToggleKey;
    public static KeyMapping hudHintsToggleKey;
    public static KeyMapping hudLayoutEditKey;
    public static KeyMapping hudShowAllKey;
    private static final Map<String, KeyMapping> keys;

    private DSCKeys() {
    }

    public static void init() {
        throttleUpKey = DSCKeys.registerKey("throttle_up_key", VEHICLE_MOVE_CONTROL, 265);
        throttleDownKey = DSCKeys.registerKey("throttle_down_key", VEHICLE_MOVE_CONTROL, 264);
        pitchUpKey = DSCKeys.registerKey("pitch_up_key", VEHICLE_MOVE_CONTROL, 87);
        pitchDownKey = DSCKeys.registerKey("pitch_down_key", VEHICLE_MOVE_CONTROL, 83);
        rollLeftKey = DSCKeys.registerKey("roll_left_key", VEHICLE_MOVE_CONTROL, 263);
        rollRightKey = DSCKeys.registerKey("roll_right_key", VEHICLE_MOVE_CONTROL, 262);
        yawLeftKey = DSCKeys.registerKey("yaw_left_key", VEHICLE_MOVE_CONTROL, 65);
        yawRightKey = DSCKeys.registerKey("yaw_right_key", VEHICLE_MOVE_CONTROL, 68);
        mouseModeKey = DSCKeys.registerKey("mouse_mode_key", VEHICLE_CONTROL_UTIL, 341);
        flipControlsKey = DSCKeys.registerKey("flip_controls_key", VEHICLE_CONTROL_UTIL, 340);
        resetMouseKey = DSCKeys.registerKey("reset_mouse_key", VEHICLE_CONTROL_UTIL, 345);
        hudModeToggleKey = DSCKeys.registerKey("hud_mode_toggle_key", VEHICLE_CONTROL_UTIL, 296);
        hudHintsToggleKey = DSCKeys.registerKey("hud_hints_toggle_key", VEHICLE_CONTROL_UTIL, 297);
        hudLayoutEditKey = DSCKeys.registerKey("hud_layout_edit_key", VEHICLE_CONTROL_UTIL, 295);
        hudShowAllKey = DSCKeys.registerKey("hud_show_all_key", VEHICLE_CONTROL_UTIL, 298);
        leanLeftKey = DSCKeys.registerKey("lean_left_key", VEHICLE_CONTROL_UTIL, InputConstants.f_84822_.m_84873_());
        leanRightKey = DSCKeys.registerKey("lean_right_key", VEHICLE_CONTROL_UTIL, InputConstants.f_84822_.m_84873_());
        turnAssistKey = DSCKeys.registerKey("turn_assist_key", VEHICLE_CONTROL_UTIL, 346);
        cameraTrackTargetKey = DSCKeys.registerKey("camera_track_target_key", VEHICLE_CONTROL_UTIL, 344);
        vehicleMenuKey = DSCKeys.registerKey("plane_menu_key", VEHICLE_PASSENGER_CONTROL, 85);
        dismount = DSCKeys.registerKey("dismount_key", VEHICLE_PASSENGER_CONTROL, 72);
        changeSeat = DSCKeys.registerKey("change_seat_key", VEHICLE_PASSENGER_CONTROL, 89);
        landingGear = DSCKeys.registerKey("landing_gear_key", VEHICLE_PASSENGER_CONTROL, 75);
        gimbalKey = DSCKeys.registerKey("gimbal_key", VEHICLE_PASSENGER_CONTROL, 59);
        specialKey = DSCKeys.registerKey("special_key", VEHICLE_PASSENGER_CONTROL, 32);
        special2Key = DSCKeys.registerKey("special_2_key", VEHICLE_PASSENGER_CONTROL, 342);
        eject = DSCKeys.registerKey("eject_key", VEHICLE_PASSENGER_CONTROL, 93);
        shootKey = DSCKeys.registerMouse("shoot_key", VEHICLE_COMBAT_CONTROL, 1);
        weaponSelectKey = DSCKeys.registerKey("weapon_select_key", VEHICLE_COMBAT_CONTROL, 71);
        weaponSelect2Key = DSCKeys.registerKey("weapon_select_up_key", VEHICLE_COMBAT_CONTROL, InputConstants.f_84822_.m_84873_());
        flareKey = DSCKeys.registerKey("flare_key", VEHICLE_COMBAT_CONTROL, 86);
        chaffKey = DSCKeys.registerKey("chaff_key", VEHICLE_COMBAT_CONTROL, 86);
        radarModeKey = DSCKeys.registerKey("radar_mode_key", VEHICLE_COMBAT_CONTROL, 79);
        pingCycleKey = DSCKeys.registerKey("ping_cycle_key", VEHICLE_COMBAT_CONTROL, 73);
        afterBurnerKey = DSCKeys.registerKey("afterburner_toggle_key", VEHICLE_COMBAT_CONTROL, 66);
    }

    public static KeyMapping registerKey(String name, String category, int keycode) {
        KeyMapping key = DSCKeys.registerKeyImpl(name, category, keycode);
        keys.put(name, key);
        return key;
    }

    public static KeyMapping registerMouse(String name, String category, int keycode) {
        KeyMapping key = DSCKeys.registerMouseImpl(name, category, keycode);
        keys.put(name, key);
        return key;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static KeyMapping registerKeyImpl(String name, String category, int keycode) {
        void var2_2;
        void var1_1;
        return DSCKeysImpl.registerKeyImpl(name, (String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static KeyMapping registerMouseImpl(String name, String category, int keycode) {
        void var2_2;
        void var1_1;
        return DSCKeysImpl.registerMouseImpl(name, (String)var1_1, (int)var2_2);
    }

    @Nullable
    public static KeyMapping getKey(@NotNull String name) {
        return keys.get(name);
    }

    public static boolean isKeyPressed(String id) {
        KeyMapping key = DSCKeys.getKey(id);
        if (key == null) {
            return false;
        }
        return key.m_90857_();
    }

    public static Set<String> getKeyIds() {
        return keys.keySet();
    }

    public static boolean hasKey(String id) {
        return keys.containsKey(id);
    }

    static {
        keys = new HashMap<String, KeyMapping>();
    }
}

