/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimsEntityModel;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class ObjVehicleModel<T extends EntityVehicle>
extends KeyframeAnimsEntityModel<T> {
    private final Map<String, Mat4f> transforms = new HashMap<String, Mat4f>();

    public static RenderType getCullBaseRenderType(ResourceLocation texture) {
        return RenderType.m_110470_((ResourceLocation)texture);
    }

    public static RenderType getBaseRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public static RenderType getLayerRenderType(ResourceLocation texture) {
        return RenderType.m_110431_((ResourceLocation)texture);
    }

    public ObjVehicleModel(String modelId) {
        this(modelId, new JsonArray());
    }

    public ObjVehicleModel(String modelId, JsonArray anims) {
        super(modelId, anims, new String[0]);
    }

    public ObjVehicleModel(String modelId, JsonArray anims, String ... animDataIds) {
        super(modelId, anims, animDataIds);
    }

    public ObjVehicleModel(String modelId, String[] animDataIds) {
        this(modelId, new JsonArray(), animDataIds);
    }

    protected Function<ResourceLocation, RenderType> getTextureRenderTypeLookup(T entity) {
        return texture -> {
            String path = texture.m_135815_();
            ResourceLocation loc = texture;
            if (path.contains("base")) {
                loc = entity.textureManager.getDynamicTexture();
            } else if (path.contains("extra_")) {
                int index = path.indexOf("extra_");
                String[] extras = path.substring(index).split("_");
                String newLoc = path.substring(0, index) + extras[0] + "_" + extras[1] + "_" + entity.textureManager.getBaseTextureIndex() + ".png";
                loc = new ResourceLocation(texture.m_135827_(), newLoc);
            }
            if (((VehicleClientStats)entity.getAssets()).isDontCull()) {
                return ObjVehicleModel.getBaseRenderType(loc);
            }
            return ObjVehicleModel.getCullBaseRenderType(loc);
        };
    }

    protected void rotate(T entity, float partialTicks, PoseStack poseStack) {
        QuaternionF q = UtilAngles.lerpQ((float)partialTicks, (QuaternionF)((EntityVehicle)entity).getPrevQ(), (QuaternionF)((EntityVehicle)entity).getClientQ());
        poseStack.m_252781_(q.convert());
    }

    protected int getLight(T entity, int lightmap) {
        if (!((EntityVehicle)entity).isOperational()) {
            return 1;
        }
        return lightmap;
    }
}

