/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay;

import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilPrint;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WindTunnelOverlay {
    static final long CHECK_TUNNEL_RATE = 2000L;
    static long prevTunnelCheckTime = System.currentTimeMillis();
    static final int VALUE_OFFSET = 50;
    static final int LABEL_PADDING = 2;
    @Nullable
    static EntityWindTunnel tunnel;

    static void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!player.m_20310_(2)) {
            return;
        }
        if (System.currentTimeMillis() - prevTunnelCheckTime >= 2000L) {
            WindTunnelOverlay.findTunnel(player.m_20182_(), UtilEntity.getLevel((Entity)player));
        }
        if (tunnel == null) {
            return;
        }
        int index = 0;
        graphics.m_280488_(gui.m_93082_(), tunnel.getStatsId(), 2, 2, 65280);
        graphics.m_280488_(gui.m_93082_(), "Speed", 2, 2 + 10 * ++index, 65535);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(tunnel.getSpeed()), 50, 2 + 10 * index, 65535);
        graphics.m_280488_(gui.m_93082_(), "Total", 2, 2 + 10 * ++index, 0xFFFFFF);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.totalAcc), 50, 2 + 10 * index, 0xFFFFFF);
        graphics.m_280488_(gui.m_93082_(), "Thrust", 2, 2 + 10 * ++index, 255);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.thrustAcc), 50, 2 + 10 * index, 255);
        graphics.m_280488_(gui.m_93082_(), "Drag", 2, 2 + 10 * ++index, 0xFF0000);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.dragAcc), 50, 2 + 10 * index, 0xFF0000);
        graphics.m_280488_(gui.m_93082_(), "Lift", 2, 2 + 10 * ++index, 65280);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.liftAcc), 50, 2 + 10 * index, 65280);
        graphics.m_280488_(gui.m_93082_(), "Weight", 2, 2 + 10 * ++index, 0);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.weightAcc), 50, 2 + 10 * index, 0);
        graphics.m_280488_(gui.m_93082_(), "RotAcc", 2, 2 + 10 * ++index, 255);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printVec3SigFig(WindTunnelOverlay.tunnel.rotAcc), 50, 2 + 10 * index, 255);
        graphics.m_280488_(gui.m_93082_(), "AOA", 2, 2 + 10 * ++index, 0xFF00FF);
        StringBuilder aoaStr = new StringBuilder();
        for (Float aoa : WindTunnelOverlay.tunnel.aoas) {
            aoaStr.append(UtilPrint.printDec(aoa.floatValue())).append(" ");
        }
        graphics.m_280488_(gui.m_93082_(), aoaStr.toString(), 50, 2 + 10 * index, 0xFF00FF);
        int color = 65280;
        if (WindTunnelOverlay.tunnel.windCompAcc < 0.0) {
            color = 0xFF0000;
        }
        graphics.m_280488_(gui.m_93082_(), "WCA", 2, 2 + 10 * ++index, color);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printSigFig(WindTunnelOverlay.tunnel.windCompAcc), 50, 2 + 10 * index, color);
        double Ny = WindTunnelOverlay.tunnel.centripetalAcc / 0.024525;
        graphics.m_280488_(gui.m_93082_(), "Ny", 2, 2 + 10 * ++index, 0xFFFF00);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printSigFig(Ny), 50, 2 + 10 * index, 0xFFFF00);
        graphics.m_280488_(gui.m_93082_(), "YawRate", 2, 2 + 10 * ++index, 0xFF00FF);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printDec(WindTunnelOverlay.tunnel.yawRate * 20.0), 50, 2 + 10 * index, 0xFF00FF);
        graphics.m_280488_(gui.m_93082_(), "TurnRad", 2, 2 + 10 * ++index, 65535);
        graphics.m_280488_(gui.m_93082_(), UtilPrint.printDec(WindTunnelOverlay.tunnel.turnRadius), 50, 2 + 10 * index, 65535);
    }

    static void findTunnel(Vec3 pos, Level level) {
        Optional<EntityWindTunnel> opt = UtilVehicleEntity.findWindTunnel(pos, level);
        tunnel = opt.orElse(null);
        prevTunnelCheckTime = System.currentTimeMillis();
    }
}

