/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DebugOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (DebugOverlay.defaultRenderConditions()) {
            return false;
        }
        return DebugOverlay.getPlayerRootVehicle() instanceof EntityVehicle && (Boolean)Config.CLIENT.debugMode.get() != false;
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)DebugOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int color = 65280;
        int space = 160;
        graphics.m_280488_(FONT, "V" + UtilParse.prettyVec3((Vec3)vehicle.m_20184_(), (int)2), screenWidth - space, 0, color);
        graphics.m_280488_(FONT, "F" + UtilParse.prettyVec3((Vec3)vehicle.forces, (int)0), screenWidth - space, 10, color);
        graphics.m_280488_(FONT, "A" + UtilParse.prettyVec3((Vec3)vehicle.getAngularVel(), (int)2), screenWidth - space, 20, color);
        graphics.m_280488_(FONT, "M" + UtilParse.prettyVec3((Vec3)vehicle.getMoment(), (int)2), screenWidth - space, 30, color);
        graphics.m_280488_(FONT, "Q" + UtilParse.prettyQ((QuaternionF)vehicle.getClientQ(), (int)2), screenWidth - space, 40, color);
        graphics.m_280488_(FONT, "YR: " + String.format("%3.2f", Float.valueOf(vehicle.getYawRate() * 20.0f)) + " TR: " + String.format("%3.2f", Float.valueOf(vehicle.getActualTurnRadius())), screenWidth - space, 50, color);
        QuaternionF q = vehicle.getClientQ();
        Vec3 thrust = vehicle.getThrustForce(q);
        Vec3 drag = vehicle.calcTotalDrag(q);
        Vec3 lift = vehicle.calcTotalLift(q);
        double weight = vehicle.getWeightForce().f_82480_;
        double forceY = thrust.f_82480_ + drag.f_82480_ + lift.f_82480_ + weight;
        double thrustDragXZ = thrust.m_165924_() - drag.m_165924_();
        double tdXZAcc = vehicle.getAccFromForce(thrustDragXZ, true) * 1000.0;
        graphics.m_280488_(FONT, "FY: " + String.format("%3.1f", forceY), screenWidth - space, 60, color);
        graphics.m_280488_(FONT, "FTD_XZ: " + String.format("%3.1f", thrustDragXZ) + " ATD_XZ: " + String.format("%3.3f", tdXZAcc), screenWidth - space, 70, color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_debug";
    }
}

