/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class HudOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation HUD = new ResourceLocation("dscombat", "textures/ui/hud_overlay.png");
    public static final ResourceLocation ATTITUDE_TEXTURE = new ResourceLocation("dscombat", "textures/ui/hud_attitude.png");
    public static final Color GREEN_ME_SAY_ALONE_RAMP = new Color(0, 255, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final float START = 0.6f;
    public static final float END = 0.1f;
    public static final float CHANGE_G = (float)GREEN_ME_SAY_ALONE_RAMP.getGreen() / 0.5f;
    public static final float CHANGE_R = (float)RED.getRed() / 0.5f;
    public static final byte ATTITUDE_TEXTURE_WIDTH = 90;
    public static final short ATTITUDE_TEXTURE_HEIGHT = 294;
    public static final short VERTICAL_BOUNDS_WIDTH = 128;
    public static final byte HORIZONTAL_BOUNDS_U_WIDTH = 79;
    public static final short HORIZONTAL_BOUNDS_V_HEIGHT = 71;
    public static final short HORIZONTAL_BOUNDS_V_OFFSET_0 = 112;
    public static final byte NUMBERS_UV_WIDTH = 6;
    public static final byte NUMBERS_UV_HEIGHT = 8;
    public static final byte HORIZONTAL_BOUNDS_BLIT_OFFSET = -2;

    private static void drawStrings(PoseStack poseStack, int screenWidth, int screenHeight, EntityPlane plane, GuiGraphics graphics) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)screenWidth / 2.0 + 30.0, ((double)screenHeight + 128.0) / 2.0 - 28.0, 0.0);
        poseStack.m_85841_(0.7f, 0.7f, 1.0f);
        graphics.m_280488_(FONT, String.format("AOA: %3.1f", Float.valueOf(plane.getAOA())), 0, 0, 65280);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)screenWidth / 2.0 - 56.0, ((double)screenHeight + 128.0) / 2.0 - 28.0, 0.0);
        poseStack.m_85841_(0.7f, 0.7f, 1.0f);
        graphics.m_280488_(FONT, "m/s: " + String.format("%3.1f", plane.m_20184_().m_82553_() * 20.0), 0, 0, 65280);
        graphics.m_280488_(FONT, "A: " + plane.getAltitude(), 0, 10, 65280);
        graphics.m_280488_(FONT, "[" + plane.m_146903_() + "," + plane.m_146904_() + "," + plane.m_146907_() + "]", 0, 20, 65280);
        poseStack.m_85849_();
    }

    private void drawAttitudeOverlay(PoseStack poseStack, int screenWidth, int screenHeight, EntityPlane plane, GuiGraphics graphics) {
        poseStack.m_85836_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ATTITUDE_TEXTURE);
        double xOrigin = ((double)screenWidth - 79.0) / 2.0;
        double yOrigin = ((double)screenHeight - 71.0) / 2.0 + 1.0;
        poseStack.m_85837_(xOrigin + 39.0, yOrigin + 35.5, -2.0);
        poseStack.m_252781_(Vec3f.ZP.rotationDegrees(-plane.zRot).convert());
        poseStack.m_85837_(-((double)plane.getYawRate() * 5.6), 0.0, 0.0);
        graphics.m_280163_(ATTITUDE_TEXTURE, -39, -35, 0.0f, (float)(112 + (int)(plane.m_146909_() * 8.0f / 5.0f)), 90, 71, 90, 294);
        poseStack.m_85849_();
    }

    private static int getHealthColor(float health, float max) {
        float healthPercent = health / max;
        if (healthPercent >= 0.6f) {
            return GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        if (healthPercent < 0.6f && healthPercent > 0.1f) {
            return new Color((int)(CHANGE_R * (0.6f - healthPercent)), (int)(CHANGE_G * (healthPercent - 0.1f)), 0).getRGB();
        }
        return RED.getRGB();
    }

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (HudOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        if (!(HudOverlay.getPlayerRootVehicle() instanceof EntityPlane)) {
            return false;
        }
        return !DSCClientInputs.isCameraFree();
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityPlane plane = (EntityPlane)HudOverlay.getPlayerRootVehicle();
        assert (plane != null);
        PoseStack poseStack = graphics.m_280168_();
        HudOverlay.drawStrings(poseStack, screenWidth, screenHeight, plane, graphics);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HUD);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        graphics.m_280218_(HUD, (screenWidth - 128) / 2, (screenHeight - 128) / 2, 0, 0, 128, 128);
        poseStack.m_85836_();
        poseStack.m_85837_(((double)screenWidth - 9.0) / 2.0, ((double)screenHeight - 6.0) / 2.0, 0.0);
        graphics.m_280218_(HUD, 0, 0, 150, 16, 9, 6);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(((double)screenWidth - 22.0) / 2.0, ((double)screenHeight - 22.0) / 2.0, 0.0);
        int vOffsetForCircle = plane.radarSystem.isClientLocking() ? 38 : 16;
        graphics.m_280218_(HUD, 0, 0, 128, vOffsetForCircle, 22, 22);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(((double)screenWidth - 25.0) / 2.0, ((double)screenHeight - 5.0) / 2.0, 0.0);
        graphics.m_280218_(HUD, 0, 59, 128, 60, 25, 5);
        poseStack.m_85849_();
        this.drawAttitudeOverlay(poseStack, screenWidth, screenHeight, plane, graphics);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_hud";
    }
}

