/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCKeys;
import com.onewhohears.dscombat.client.overlay.HudLayoutManager;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.screen.HudLayoutEditScreen;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityHelicopter;
import com.onewhohears.dscombat.entity.vehicle.EntityPlane;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class ModernHudOverlay
extends VehicleOverlayComponent {
    private static boolean lastF7 = false;
    private static boolean lastF8 = false;
    private static int hudMode = 0;
    private static int hintsMode = 1;
    private static boolean lastF6 = false;
    private static boolean editMode = false;
    private static String draggingId = null;
    private static boolean resizing = false;
    private static double dragDX = 0.0;
    private static double dragDY = 0.0;
    private static final double RESIZE_HANDLE = 14.0;

    private int argb(float a, int r, int g, int b) {
        int ai = (int)(a * 255.0f) & 0xFF;
        return ai << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private String vehicleTypeId(EntityVehicle v) {
        if (v instanceof EntityHelicopter) {
            return "HELICOPTER";
        }
        if (v instanceof EntityPlane) {
            return "PLANE";
        }
        if (((VehicleStats)v.getStats()).isBoat()) {
            return "BOAT";
        }
        if (((VehicleStats)v.getStats()).getType() == VehicleType.CAR) {
            if (((VehicleStats)v.getStats()).asCar().isTank()) {
                return "TANK";
            }
            return "CAR";
        }
        return "GENERIC";
    }

    private HudLayoutManager.Rect getRect(EntityVehicle v, String id, int px, int py, int pw, int ph, int sw, int sh) {
        String vt = this.vehicleTypeId(v);
        HudLayoutManager.Rect fb = new HudLayoutManager.Rect((double)px / (double)sw, (double)py / (double)sh, (double)pw / (double)sw, (double)ph / (double)sh);
        return HudLayoutManager.get(vt, id, fb);
    }

    private void setRect(EntityVehicle v, String id, HudLayoutManager.Rect r) {
        HudLayoutManager.set(this.vehicleTypeId(v), id, r);
    }

    private void drawEditHandle(GuiGraphics graphics, int x, int y, int w, int h, String label, int text) {
        int border = 1;
        graphics.m_280509_(x - border, y - border, x + w + border, y + h + border, this.withAlpha(new Color(255, 255, 255).getRGB(), 0.12f));
        graphics.m_280488_(FONT, label, x + 2, y - 10, text);
        graphics.m_280509_(x + w - 8, y + h - 2, x + w + 2, y + h + 2, this.withAlpha(new Color(255, 255, 255).getRGB(), 0.3f));
    }

    private void handleDragging(EntityVehicle v, int sw, int sh) {
        Minecraft mc = Minecraft.m_91087_();
        double mxWin = mc.f_91067_.m_91589_();
        double myWin = mc.f_91067_.m_91594_();
        double mxGui = mxWin * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
        double myGui = myWin * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
        float scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        double mx = mxGui / (double)scale;
        double my = myGui / (double)scale;
        boolean left = mc.f_91067_.m_91560_();
        if (draggingId == null && left) {
            this.selectIfInside(v, "att", mx, my, sw, sh);
            this.selectIfInside(v, "head", mx, my, sw, sh);
            this.selectIfInside(v, "br", mx, my, sw, sh);
            this.selectIfInside(v, "bl", mx, my, sw, sh);
        }
        if (draggingId != null && left) {
            HudLayoutManager.Rect r = HudLayoutManager.get(this.vehicleTypeId(v), draggingId, new HudLayoutManager.Rect(0.0, 0.0, 0.3, 0.2));
            if (resizing) {
                r.w = this.clamp01(mx / (double)sw - r.x);
                r.h = this.clamp01(my / (double)sh - r.y);
            } else {
                r.x = this.clamp01(mx / (double)sw - dragDX);
                r.y = this.clamp01(my / (double)sh - dragDY);
            }
            this.setRect(v, draggingId, r);
        }
        if (!left) {
            draggingId = null;
        }
    }

    private void selectIfInside(EntityVehicle v, String id, double mx, double my, int sw, int sh) {
        HudLayoutManager.Rect r = HudLayoutManager.get(this.vehicleTypeId(v), id, new HudLayoutManager.Rect(0.4, 0.4, 0.2, 0.1));
        double x = r.x * (double)sw;
        double y = r.y * (double)sh;
        double w = r.w * (double)sw;
        double h = r.h * (double)sh;
        if (mx >= x && mx <= x + w && my >= y && my <= y + h) {
            draggingId = id;
            resizing = mx >= x + w - 14.0 && my >= y + h - 14.0;
            dragDX = (mx - x) / (double)sw;
            dragDY = (my - y) / (double)sh;
        }
    }

    private double clamp01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }

    private void drawHintsCompact(GuiGraphics graphics, int sw, int sh, int text) {
        String s = "[Space] Hover  [K] Gear  [V] Flares  [O] Radar  [F8] Hints  [F7] HUD";
        int y = sh - 14;
        graphics.m_280137_(FONT, s, sw / 2, y, text);
    }

    private void drawHintsFull(GuiGraphics graphics, int sw, int sh, int text) {
        int x = 8;
        int y = 8;
        int w = 220;
        int h = sh - 16;
        graphics.m_280509_(x, y, x + w, y + h, this.withAlpha(new Color(20, 20, 20).getRGB(), 0.85f));
        int yy = y + 8;
        graphics.m_280488_(FONT, "Controls (F8 to hide)", x + 8, yy, text);
        graphics.m_280488_(FONT, "Hover: Space", x + 8, yy += 12, text);
        graphics.m_280488_(FONT, "Gear: K", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Flares: V", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Radar Mode: O", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Track Target: RSHIFT", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Gimbal: ;", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Throttle: Up/Down", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Yaw: A/D", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Roll: Left/Right", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "Pitch: W/S", x + 8, yy += 10, text);
        graphics.m_280488_(FONT, "HUD Mode: F7", x + 8, yy += 10, text);
        yy += 10;
    }

    private int withAlpha(int rgb, float a) {
        int ai = (int)(a * 255.0f) & 0xFF;
        return ai << 24 | rgb & 0xFFFFFF;
    }

    private static String speedUnitLabel() {
        String u;
        return switch (u = (String)Config.CLIENT.hudSpeedUnit.get()) {
            case "kph" -> "km/h";
            case "knots" -> "kt";
            default -> "m/s";
        };
    }

    private static double speedConverted(double mps) {
        String u;
        return switch (u = (String)Config.CLIENT.hudSpeedUnit.get()) {
            case "kph" -> mps * 3.6;
            case "knots" -> mps * 1.943844492;
            default -> mps;
        };
    }

    private static String altUnitLabel() {
        String u = (String)Config.CLIENT.hudAltUnit.get();
        return u.equals("ft") ? "ft" : "m";
    }

    private static double altConverted(double meters) {
        String u = (String)Config.CLIENT.hudAltUnit.get();
        return u.equals("ft") ? meters * 3.280839895 : meters;
    }

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (ModernHudOverlay.defaultRenderConditions()) {
            return false;
        }
        if (!((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return ModernHudOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        this.updateToggles();
        float scale = ((Double)Config.CLIENT.modernHudScale.get()).floatValue();
        float alpha = ((Double)Config.CLIENT.modernHudOpacity.get()).floatValue();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        int sw = (int)((float)screenWidth / scale);
        int sh = (int)((float)screenHeight / scale);
        EntityVehicle v = (EntityVehicle)ModernHudOverlay.getPlayerRootVehicle();
        assert (v != null);
        boolean isHeli = v instanceof EntityHelicopter;
        boolean isPlane = v instanceof EntityPlane;
        boolean showAllHold = DSCKeys.hudShowAllKey != null && DSCKeys.hudShowAllKey.m_90857_();
        int localHudMode = showAllHold ? 1 : hudMode;
        int localHintsMode = showAllHold ? 2 : hintsMode;
        int panel = this.withAlpha(new Color(24, 24, 24).getRGB(), alpha);
        int text = new Color(220, 255, 220).getRGB();
        int accent = new Color(88, 220, 88).getRGB();
        int warn = new Color(255, 170, 0).getRGB();
        int danger = new Color(255, 80, 80).getRGB();
        int defAttW = localHudMode == 0 ? 150 : 180;
        int defAttH = localHudMode == 0 ? 90 : 110;
        int defAttX = sw / 2 - defAttW / 2;
        int defAttY = sh / 2 - defAttH / 2 + 12;
        HudLayoutManager.Rect attR = this.getRect(v, "att", defAttX, defAttY, defAttW, defAttH, sw, sh);
        int attX = (int)Math.round(attR.x * (double)sw);
        int attY = (int)Math.round(attR.y * (double)sh);
        int attW = (int)Math.round(attR.w * (double)sw);
        int attH = (int)Math.round(attR.h * (double)sh);
        if (localHudMode == 1) {
            graphics.m_280509_(attX, attY, attX + attW, attY + attH, this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        int defHrW = localHudMode == 0 ? 180 : 220;
        int hrH = 18;
        int defHrX = sw / 2 - defHrW / 2;
        int defHrY = attY - hrH - 4;
        HudLayoutManager.Rect headR = this.getRect(v, "head", defHrX, defHrY, defHrW, hrH, sw, sh);
        int hrX = (int)Math.round(headR.x * (double)sw);
        int hrY = (int)Math.round(headR.y * (double)sh);
        int hrW = (int)Math.round(headR.w * (double)sw);
        if (localHudMode == 1) {
            graphics.m_280509_(hrX, hrY, hrX + hrW, hrY + hrH, this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        this.drawHeadingRibbon(graphics, v, hrX, hrY, hrW, hrH, text, accent);
        this.drawAttitude(graphics, v, attX, attY, attW, attH, text, accent);
        if (isPlane) {
            try {
                double aoa = ((EntityPlane)v).getAOA();
                graphics.m_280488_(FONT, String.format("AOA %3.1f", aoa), attX + attW + 6, attY + attH / 2 - 4, text);
            }
            catch (Throwable aoa) {
                // empty catch block
            }
        }
        int defPrW = 190;
        int defPrH = 96;
        int defPrX = sw - defPrW - 1 - 6;
        int defPrY = sh - defPrH - 1 - 4;
        HudLayoutManager.Rect brR = this.getRect(v, "br", defPrX, defPrY, defPrW, defPrH, sw, sh);
        int prX = (int)Math.round(brR.x * (double)sw);
        int prY = (int)Math.round(brR.y * (double)sh);
        int prW = (int)Math.round(brR.w * (double)sw);
        int prH = (int)Math.round(brR.h * (double)sh);
        if (localHudMode == 1) {
            graphics.m_280509_(prX, prY, prX + prW, prY + prH, panel);
        }
        float throttleGoal = v.inputs.getGoalThrottle(v);
        float throttlePct = ((VehicleStats)v.getStats()).negativeThrottle ? (throttleGoal + 1.0f) / 2.0f : throttleGoal;
        int barX = prX + 10;
        int barY = prY + 10;
        int barW = 14;
        int barH = prH - 20;
        if (localHudMode == 1) {
            graphics.m_280509_(barX, barY, barX + barW, barY + barH, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        }
        int fillH = (int)((float)barH * Math.max(0.0f, Math.min(1.0f, throttlePct)));
        if (localHudMode == 1) {
            graphics.m_280509_(barX, barY + (barH - fillH), barX + barW, barY + barH, this.withAlpha(accent, alpha));
            graphics.m_280488_(FONT, "THR", barX - 2, prY + prH - 12, text);
        }
        double rpmPct = 0.0;
        if (isHeli) {
            EntityHelicopter heli = (EntityHelicopter)v;
            rpmPct = Math.max(0.0, Math.min(1.0, heli.getRotorPower()));
        }
        int rbX = barX + barW + 16;
        int rbY = barY;
        int rbW = barW;
        int rbH = barH;
        if (localHudMode == 1 && isHeli) {
            graphics.m_280509_(rbX, rbY, rbX + rbW, rbY + rbH, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        }
        int rpmFill = (int)((double)rbH * rpmPct);
        if (localHudMode == 1 && isHeli) {
            graphics.m_280509_(rbX, rbY + (rbH - rpmFill), rbX + rbW, rbY + rbH, this.withAlpha(warn, alpha));
            graphics.m_280488_(FONT, "RPM", rbX - 2, prY + prH - 12, text);
        }
        double speed = ModernHudOverlay.speedConverted(v.m_20184_().m_82553_() * 20.0);
        double climb = ModernHudOverlay.speedConverted(v.m_20184_().f_82480_ * 20.0);
        int metricsX = rbX + rbW + 12;
        int metricsY = barY + (localHudMode == 0 ? -8 : 0);
        graphics.m_280488_(FONT, String.format("spd  %4.1f %s", speed, ModernHudOverlay.speedUnitLabel()), metricsX, metricsY, text);
        if (localHudMode == 1) {
            graphics.m_280488_(FONT, String.format("clb  %4.1f %s", climb, ModernHudOverlay.speedUnitLabel()), metricsX, metricsY + 10, climb >= 0.0 ? text : warn);
        }
        graphics.m_280488_(FONT, String.format("hdg  %3.0f\u00b0", Float.valueOf((v.m_146908_() + 360.0f) % 360.0f)), metricsX, metricsY + (localHudMode == 1 ? 20 : 10), text);
        float fuelPct = 0.0f;
        try {
            fuelPct = Math.max(0.0f, Math.min(1.0f, v.getCurrentFuel() / Math.max(1.0f, v.getMaxFuel())));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int barsX = metricsX;
        int barsY = metricsY + (hudMode == 1 ? 36 : 22);
        int bw = 120;
        int bh = 6;
        if (localHudMode == 1) {
            graphics.m_280509_(barsX, barsY, barsX + bw, barsY + bh, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            graphics.m_280509_(barsX, barsY, barsX + (int)((float)bw * fuelPct), barsY + bh, this.withAlpha(new Color(0, 180, 255).getRGB(), alpha));
            graphics.m_280488_(FONT, String.format("fuel %3.0f%%", Float.valueOf(fuelPct * 100.0f)), barsX + bw + 6, barsY - 1, text);
        }
        barsY += bh + 4;
        float hp = v.getHealth();
        float hpMax = v.getMaxHealth();
        float hpPct = Math.max(0.0f, Math.min(1.0f, hpMax <= 0.0f ? 0.0f : hp / hpMax));
        if (localHudMode == 1) {
            graphics.m_280509_(barsX, barsY, barsX + bw, barsY + bh, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            graphics.m_280509_(barsX, barsY, barsX + (int)((float)bw * hpPct), barsY + bh, this.withAlpha(new Color(80, 220, 80).getRGB(), alpha));
            graphics.m_280488_(FONT, String.format("hp %3.0f%%", Float.valueOf(hpPct * 100.0f)), barsX + bw + 6, barsY - 1, text);
        }
        barsY += bh + 4;
        float ar = v.getArmor();
        float arMax = v.getMaxTotalArmor();
        float arPct = Math.max(0.0f, Math.min(1.0f, arMax <= 0.0f ? 0.0f : ar / arMax));
        if (localHudMode == 1) {
            graphics.m_280509_(barsX, barsY, barsX + bw, barsY + bh, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
            graphics.m_280509_(barsX, barsY, barsX + (int)((float)bw * arPct), barsY + bh, this.withAlpha(new Color(180, 180, 60).getRGB(), alpha));
            graphics.m_280488_(FONT, String.format("arm %3.0f%%", Float.valueOf(arPct * 100.0f)), barsX + bw + 6, barsY - 1, text);
        }
        int plX = 7;
        int defPlW = localHudMode == 0 ? 180 : 220;
        int defPlH = localHudMode == 0 ? 82 : 110;
        int defPlY = sh - defPlH - 1;
        HudLayoutManager.Rect blR = this.getRect(v, "bl", plX, defPlY, defPlW, defPlH, sw, sh);
        int plY = (int)Math.round(blR.y * (double)sh);
        int plW = (int)Math.round(blR.w * (double)sw);
        int plH = (int)Math.round(blR.h * (double)sh);
        plX = (int)Math.round(blR.x * (double)sw);
        graphics.m_280509_(plX, plY, plX + plW, plY + plH, this.withAlpha(new Color(24, 24, 24).getRGB(), alpha * (localHudMode == 0 ? 0.5f : 0.85f)));
        int tapeX = plX + 10;
        int tapeY = plY + 10;
        int tapeW = 14;
        int tapeH = plH - 20;
        graphics.m_280509_(tapeX, tapeY, tapeX + tapeW, tapeY + tapeH, this.withAlpha(new Color(60, 60, 60).getRGB(), alpha));
        double alt = ModernHudOverlay.altConverted(v.getAltitude());
        graphics.m_280488_(FONT, String.format("alt %4.0f %s", alt, ModernHudOverlay.altUnitLabel()), tapeX + tapeW + 8, tapeY, text);
        int pty = tapeY + tapeH / 2;
        graphics.m_280509_(tapeX + tapeW + 2, pty - 1, tapeX + tapeW + 10, pty + 1, this.withAlpha(accent, alpha));
        int chipY = plY + (hudMode == 0 ? 28 : 34);
        int chipH = 14;
        int chipW = 50;
        float chipAlpha = alpha;
        if (isHeli) {
            boolean ige = false;
            double hMax = (Double)Config.SERVER.groundEffectMaxHeight.get();
            if (((Boolean)Config.SERVER.enableGroundEffect.get()).booleanValue() && hMax > 0.0) {
                int limit = (int)Math.ceil(hMax) + 1;
                int aglBlocks = UtilVehicleEntity.getDistFromGround((Entity)v, limit, true);
                ige = (double)aglBlocks < hMax;
            }
            int c1 = this.withAlpha(new Color(ige ? 88 : 60, ige ? 220 : 60, 88).getRGB(), chipAlpha);
            graphics.m_280509_(plX + 10, chipY, plX + 10 + chipW, chipY + chipH, c1);
            graphics.m_280488_(FONT, "IGE", plX + 12, chipY + 3, Color.BLACK.getRGB());
            double speedXZ = v.m_20184_().m_165924_();
            double full = Math.max(1.0E-6, (Double)Config.SERVER.translationalLiftFullSpeed.get());
            double etlFactor = Math.min(1.0, speedXZ / full);
            boolean etl = (Boolean)Config.SERVER.enableTranslationalLift.get() != false && etlFactor > 0.05;
            int c2 = this.withAlpha(new Color(etl ? 220 : 60, etl ? 180 : 60, 88).getRGB(), chipAlpha);
            graphics.m_280509_(plX + 10 + chipW + 6, chipY, plX + 10 + chipW * 2 + 6, chipY + chipH, c2);
            graphics.m_280488_(FONT, "ETL", plX + 12 + chipW + 6, chipY + 3, Color.BLACK.getRGB());
            double vy = v.m_20184_().f_82480_;
            double descent = vy < 0.0 ? -vy : 0.0;
            double trig = (Double)Config.SERVER.vrsDescentTrigger.get();
            double cap = (Double)Config.SERVER.vrsHorizMaxSpeed.get();
            boolean vrs = (Boolean)Config.SERVER.enableVRS.get() != false && descent > trig && speedXZ < cap;
            int c3 = this.withAlpha(new Color(vrs ? 220 : 60, 88, 88).getRGB(), chipAlpha);
            graphics.m_280509_(plX + 10 + (chipW + 6) * 2, chipY, plX + 10 + (chipW + 6) * 3, chipY + chipH, c3);
            graphics.m_280488_(FONT, "VRS", plX + 12 + (chipW + 6) * 2, chipY + 3, Color.BLACK.getRGB());
        } else if (isPlane) {
            boolean gearOut = v.canToggleLandingGear() && v.isLandingGear();
            int cg = this.withAlpha(new Color(gearOut ? 88 : 60, gearOut ? 220 : 60, 88).getRGB(), chipAlpha);
            graphics.m_280509_(plX + 10, chipY, plX + 10 + chipW, chipY + chipH, cg);
            graphics.m_280488_(FONT, "GEAR", plX + 12, chipY + 3, Color.BLACK.getRGB());
            boolean flaps = v.isFlapsDown();
            int cf = this.withAlpha(new Color(flaps ? 220 : 60, flaps ? 180 : 60, 88).getRGB(), chipAlpha);
            graphics.m_280509_(plX + 10 + chipW + 6, chipY, plX + 10 + chipW * 2 + 6, chipY + chipH, cf);
            graphics.m_280488_(FONT, "FLAPS", plX + 12 + chipW + 6, chipY + 3, Color.BLACK.getRGB());
        }
        int stW = 54;
        int stH = 90;
        int stX = attX - stW - 8;
        int stY = attY + (attH - stH) / 2;
        if (localHudMode == 1) {
            graphics.m_280509_(stX, stY, stX + stW, stY + stH, this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
        }
        double spd = ModernHudOverlay.speedConverted(v.m_20184_().m_82553_() * 20.0);
        if (localHudMode == 1) {
            graphics.m_280488_(FONT, String.format("%4.1f %s", spd, ModernHudOverlay.speedUnitLabel()), stX + 4, stY + stH / 2 - 4, text);
        }
        int atW = 54;
        int atH = 90;
        int atX = attX + attW + 8;
        int atY = attY + (attH - atH) / 2;
        if (localHudMode == 1) {
            graphics.m_280509_(atX, atY, atX + atW, atY + atH, this.withAlpha(new Color(16, 16, 16).getRGB(), alpha * 0.6f));
            graphics.m_280488_(FONT, String.format("%4.0f %s", alt, ModernHudOverlay.altUnitLabel()), atX + 4, atY + atH / 2 - 4, text);
        }
        if (localHudMode == 0) {
            graphics.m_280488_(FONT, String.format("%4.1f %s", speed, ModernHudOverlay.speedUnitLabel()), 12, 12, text);
            graphics.m_280488_(FONT, String.format("%4.0f %s", alt, ModernHudOverlay.altUnitLabel()), sw - 90, 12, text);
        }
        if (localHintsMode == 2) {
            this.drawHintsFull(graphics, sw, sh, text);
        } else if (localHintsMode == 1) {
            this.drawHintsCompact(graphics, sw, sh, text);
        }
        if (editMode) {
            this.drawEditHandle(graphics, attX, attY, attW, attH, "att", text);
            this.drawEditHandle(graphics, hrX, hrY, hrW, hrH, "head", text);
            this.drawEditHandle(graphics, prX, prY, prW, prH, "br", text);
            this.drawEditHandle(graphics, plX, plY, plW, plH, "bl", text);
            this.handleDragging(v, sw, sh);
        }
        graphics.m_280168_().m_85849_();
    }

    private void updateToggles() {
        Minecraft mc;
        boolean f6;
        boolean f7 = DSCKeys.hudModeToggleKey != null && DSCKeys.hudModeToggleKey.m_90857_();
        boolean f8 = DSCKeys.hudHintsToggleKey != null && DSCKeys.hudHintsToggleKey.m_90857_();
        boolean bl = f6 = DSCKeys.hudLayoutEditKey != null && DSCKeys.hudLayoutEditKey.m_90857_();
        if (f7 && !lastF7) {
            hudMode = (hudMode + 1) % 2;
        }
        if (f8 && !lastF8) {
            hintsMode = (hintsMode + 1) % 3;
        }
        if (f6 && !lastF6) {
            mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (screen instanceof HudLayoutEditScreen) {
                HudLayoutEditScreen s = (HudLayoutEditScreen)screen;
                s.closeAndSave();
            } else {
                mc.m_91152_((Screen)new HudLayoutEditScreen(() -> HudLayoutManager.save()));
            }
        }
        lastF7 = f7;
        lastF8 = f8;
        lastF6 = f6;
        mc = Minecraft.m_91087_();
        editMode = mc.f_91080_ instanceof HudLayoutEditScreen;
    }

    private void drawHeadingRibbon(GuiGraphics graphics, EntityVehicle v, int x, int y, int w, int h, int text, int accent) {
        double hdg = ((double)v.m_146908_() + 360.0) % 360.0;
        graphics.m_280509_(x + w / 2 - 1, y, x + w / 2 + 1, y + h, accent);
        double pxPerDeg = 4.0;
        int spanDeg = (int)((double)w / pxPerDeg);
        int start = (int)(hdg - (double)(spanDeg / 2));
        for (int deg = start - start % 10; deg <= start + spanDeg; deg += 10) {
            int d = (int)Math.floor(((double)deg - hdg) * pxPerDeg) + w / 2;
            if (d < 0 || d > w) continue;
            int vlen = deg % 30 == 0 ? h - 4 : h - 8;
            graphics.m_280509_(x + d, y + 2, x + d + 1, y + vlen, this.withAlpha(text, 0.5f));
            if (deg % 30 != 0) continue;
            int label = (deg % 360 + 360) % 360;
            String s = Integer.toString(label);
            graphics.m_280137_(FONT, s, x + d, y + h - 12, text);
        }
    }

    private void drawAttitude(GuiGraphics graphics, EntityVehicle v, int x, int y, int w, int h, int text, int accent) {
        float pitch = v.m_146909_();
        float roll = v.zRot;
        float pxPerDeg = 2.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        graphics.m_280168_().m_252781_(Vec3f.ZP.rotationDegrees(-roll).convert());
        int bandW = w - 10;
        int cy = (int)(pitch * pxPerDeg);
        graphics.m_280509_(-bandW / 2, cy - 1, bandW / 2, cy + 1, text);
        for (int pd = -45; pd <= 45; pd += 15) {
            int yy = (int)((float)pd * pxPerDeg) + cy;
            int len = pd % 30 == 0 ? 12 : 8;
            graphics.m_280509_(-len, yy, -2, yy + 1, this.withAlpha(text, 0.6f));
            graphics.m_280509_(2, yy, len, yy + 1, this.withAlpha(text, 0.6f));
        }
        graphics.m_280509_(-6, -1, 6, 1, accent);
        graphics.m_280509_(-1, -6, 1, 6, accent);
        graphics.m_280168_().m_85849_();
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_modern_hud";
    }
}

