/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.OverlayController;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.math.Mat4f;
import com.onewhohears.onewholibs.util.math.QuaternionF;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import com.onewhohears.onewholibs.util.math.Vec3f;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RadarOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation PING_HUD = new ResourceLocation("dscombat", "textures/ui/ping_hud.png");
    public static final ResourceLocation PING_DATA = new ResourceLocation("dscombat", "textures/ui/ping_data.png");
    public static final ResourceLocation PING_ICONS = new ResourceLocation("dscombat", "textures/ui/ping_data_icons_color.png");
    public static final int ICON_SIZE = 16;
    public static final int ICON_WIDTH = 240;
    public static final int DEFAULT_SIZE = 100;
    protected static final int[] HUD_PING_ANIM = new int[]{0, 1, 2, 3, 2, 1};
    protected static float PARTIAL_TICK;

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (RadarOverlay.defaultRenderConditions()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91080_ != null) {
            return false;
        }
        Entity entity = RadarOverlay.getPlayerVehicle();
        if (!(entity instanceof EntityRidablePart)) {
            return false;
        }
        EntityRidablePart seat = (EntityRidablePart)entity;
        EntityVehicle vehicle = seat.getParentVehicle();
        if (vehicle == null) {
            return false;
        }
        RadarSystem radar = vehicle.radarSystem;
        if (!radar.hasRadar()) {
            return false;
        }
        PARTIAL_TICK = partialTick;
        List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
        return !pings.isEmpty();
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityRidablePart seat = (EntityRidablePart)RadarOverlay.getPlayerVehicle();
        assert (seat != null);
        EntityVehicle vehicle = seat.getParentVehicle();
        assert (vehicle != null);
        RadarSystem radar = vehicle.radarSystem;
        List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
        int selected = radar.getClientSelectedPingIndex();
        int hover = DSCClientInputs.getRadarHoverIndex();
        Camera cam = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 view = cam.m_90583_();
        float z_rot = UtilAngles.lerpAngle((float)PARTIAL_TICK, (float)vehicle.zRotO, (float)vehicle.zRot);
        graphics.m_280168_().m_85836_();
        QuaternionF q = Vec3f.ZP.rotationDegrees(z_rot);
        q.mul(Vec3f.XP.rotationDegrees(cam.m_90589_()));
        q.mul(Vec3f.YP.rotationDegrees(cam.m_90590_() + 180.0f));
        graphics.m_280168_().m_252781_(q.convert());
        graphics.m_280168_().m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        Mat4f view_mat = Mat4f.from((Matrix4f)graphics.m_280168_().m_85850_().m_252922_());
        graphics.m_280168_().m_85849_();
        Mat4f proj_mat = OverlayController.PROJECTION_MATRIX;
        float cursorX = (float)screenWidth / 2.0f;
        float cursorY = (float)screenHeight / 2.0f;
        boolean hovering = false;
        int size = (Integer)Config.CLIENT.radarPingOverlaySize.get();
        int icon_size = 16 * size / 100 * 7 / 4;
        int halfSize = size / 2;
        int halfIconSize = icon_size / 2;
        int sizeFraction = -icon_size / 4;
        int iconLeft = halfIconSize + sizeFraction;
        int iconMid = halfSize - halfIconSize;
        int iconRight = size - icon_size - halfIconSize - sizeFraction;
        float min = 0.2f;
        float max = 0.45f;
        float max_dist = 1000.0f;
        for (int i = 0; i < pings.size(); ++i) {
            RadarStats.RadarPing ping = pings.get(i);
            Vec3 dp = ping.getPosForClient().m_82546_(vehicle.m_20182_());
            double dist = dp.m_82542_(1.0, 0.0, 1.0).m_82553_();
            int hud_ping_offset = 0;
            if (i == selected) {
                hud_ping_offset = size * 4;
            } else if (i == hover) {
                assert (RadarOverlay.getPlayer() != null);
                hud_ping_offset = HUD_PING_ANIM[RadarOverlay.getPlayer().f_19797_ / 6 % 6] * size;
            }
            float[] screen_pos = UtilGeometry.worldToScreenPos((Vec3)ping.getPosForClient(), (Mat4f)view_mat, (Mat4f)proj_mat, (int)screenWidth, (int)screenHeight);
            if (screen_pos[0] < 0.0f || screen_pos[1] < 0.0f) continue;
            float x_win = screen_pos[0];
            float y_win = screen_pos[1];
            float scale = (float)Math.max((double)min, (double)max - dist / (double)max_dist * (double)(max - min));
            float adj = (float)size * scale / 2.0f;
            float x_pos = x_win - adj;
            float y_pos = y_win - adj;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(x_pos, y_pos, 0.0f);
            graphics.m_280168_().m_85841_(scale, scale, scale);
            if (!ping.entityType.isMissile()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)PING_HUD);
                graphics.m_280163_(PING_HUD, 0, 0, 0.0f, (float)hud_ping_offset, size, size, size, size * 5);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)PING_ICONS);
            if (ping.entityType.isMissile()) {
                graphics.m_280411_(PING_ICONS, iconMid, iconMid, icon_size, icon_size, 80.0f, 16.0f, 16, 16, 240, 16);
            }
            graphics.m_280411_(PING_ICONS, iconLeft, iconMid, icon_size, icon_size, (float)(ping.entityType.getIconIndex() * 16), 0.0f, 16, 16, 240, 16);
            graphics.m_280411_(PING_ICONS, iconRight, iconMid, icon_size, icon_size, (float)(ping.terrainType.getIconIndex() * 16), 0.0f, 16, 16, 240, 16);
            if (ping.isFriendly) {
                graphics.m_280411_(PING_ICONS, iconMid, iconLeft, icon_size, icon_size, 64.0f, 0.0f, 16, 16, 240, 16);
            }
            if (ping.isShared()) {
                graphics.m_280411_(PING_ICONS, iconMid, iconRight, icon_size, icon_size, 144.0f, 0.0f, 16, 16, 240, 16);
            }
            graphics.m_280168_().m_85849_();
            if (hovering || !(cursorX < x_win + adj) || !(cursorX > x_win - adj) || !(cursorY < y_win + adj) || !(cursorY > y_win - adj)) continue;
            DSCClientInputs.setRadarHoverIndex(i);
            hovering = true;
        }
        if (!hovering) {
            DSCClientInputs.resetRadarHoverIndex();
        }
        if (hover != -1 && hover < pings.size()) {
            RadarStats.RadarPing ping = pings.get(hover);
            int dist = (int)ping.getPosForClient().m_82554_(vehicle.m_20182_());
            int alt = UtilEntity.getDistFromSeaLevel((double)ping.getPosForClient().f_82480_, (Level)vehicle.getWorld());
            String text = dist + " | " + alt;
            int color = 0xFFFF00;
            WeaponInstance<?> weapon = null;
            if (seat.isTurret()) {
                weapon = ((EntityTurret)seat).getWeaponData();
            } else if (seat.canPassengerShootParentWeapon()) {
                weapon = vehicle.weaponSystem.getSelected();
            }
            if (weapon != null && ((WeaponStats)weapon.getStats()).requiresRadar()) {
                if ((double)dist <= ((WeaponStats)weapon.getStats()).getMobTurretRange()) {
                    color = 65280;
                    text = text + " | O";
                } else {
                    color = 0xFF0000;
                    text = text + " | X";
                }
            }
            graphics.m_280137_(FONT, text, screenWidth / 2, screenHeight / 2 - 20, color);
        }
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_radar";
    }
}

