/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VehicleCompassOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation COMPASS = new ResourceLocation("dscombat", "textures/ui/hud_compass.png");
    public static final short COMPASS_TEXTURE_WIDTH = 720;
    public static final byte COMPASS_TEXTURE_HEIGHT = 16;
    public static final short COMPASS_U_WIDTH = 161;
    public static final byte COMPASS_CORRECTIONAL_OFFSET = 30;

    private static String textByHeading(int h) {
        return switch (h) {
            case 0 -> "S";
            case 180 -> "N";
            case 90 -> "W";
            case 270 -> "E";
            case 45 -> "SW";
            case 135 -> "NW";
            case 225 -> "NE";
            case 315 -> "SE";
            default -> "";
        };
    }

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleCompassOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleCompassOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        int y = 10;
        int color = 0xE6E600;
        assert (Minecraft.m_91087_().f_91074_ != null);
        float heading = Mth.m_14177_((float)Minecraft.m_91087_().f_91074_.m_146908_());
        if (heading < 0.0f) {
            heading += 360.0f;
        }
        String stringHeading = !Objects.equals(VehicleCompassOverlay.textByHeading((int)heading), "") ? VehicleCompassOverlay.textByHeading((int)heading) : String.valueOf((int)heading);
        graphics.m_280137_(FONT, stringHeading, screenWidth / 2, y + 40, color);
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COMPASS);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)(screenWidth - 161) / 2.0 - 1.0, 30.0, 0.0);
        graphics.m_280163_(COMPASS, 0, 0, Minecraft.m_91087_().f_91074_.m_146908_() * 2.0f - 30.0f, 0.0f, 161, 16, 720, 16);
        graphics.m_280168_().m_85849_();
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_compass";
    }
}

