/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VehicleControlOverlay
extends VehicleOverlayComponent {
    public static final ResourceLocation RUDDER_PEDAL = new ResourceLocation("dscombat", "textures/ui/rudder_pedal.png");
    public static final ResourceLocation RUDDER_PEDAL_PUSHED = new ResourceLocation("dscombat", "textures/ui/rudder_pedal_pushed.png");
    public static final ResourceLocation STICK_BASE = new ResourceLocation("dscombat", "textures/ui/stick_base.png");
    public static final ResourceLocation STICK_KNOB = new ResourceLocation("dscombat", "textures/ui/stick_knob.png");
    public static final int STICK_BASE_SIZE = 60;
    public static final int STICK_KNOB_SIZE = 10;
    protected static int PEDAL_HEIGHT = 25;
    protected static int PEDAL_WIDTH = 20;

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleControlOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue() && !((Boolean)Config.CLIENT.showControlsInModernHUD.get()).booleanValue()) {
            return false;
        }
        return VehicleControlOverlay.getPlayerRootVehicle() instanceof EntityVehicle;
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleControlOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 1;
        if (vehicle.isAircraft()) {
            ResourceLocation texture = vehicle.inputs.yaw < 0.0f ? RUDDER_PEDAL_PUSHED : RUDDER_PEDAL;
            graphics.m_280163_(texture, xOrigin, yOrigin -= PEDAL_HEIGHT, 0.0f, 0.0f, PEDAL_WIDTH, PEDAL_HEIGHT, PEDAL_WIDTH, PEDAL_HEIGHT);
            texture = vehicle.inputs.yaw > 0.0f ? RUDDER_PEDAL_PUSHED : RUDDER_PEDAL;
            graphics.m_280163_(texture, xOrigin + 60 - PEDAL_WIDTH, yOrigin, 0.0f, 0.0f, PEDAL_WIDTH, PEDAL_HEIGHT, PEDAL_WIDTH, PEDAL_HEIGHT);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STICK_BASE);
        graphics.m_280163_(STICK_BASE, xOrigin, yOrigin -= 60, 0.0f, 0.0f, 60, 60, 60, 60);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STICK_KNOB);
        int baseSizeHalf = 30;
        int knobSizeHalf = 5;
        float yinput = vehicle.inputs.pitch;
        float xinput = vehicle.isAircraft() ? vehicle.inputs.roll : vehicle.inputs.yaw;
        float inputLength = Mth.m_14116_((float)(xinput * xinput + yinput * yinput));
        if (inputLength > 1.0f) {
            xinput /= inputLength;
            yinput /= inputLength;
        }
        graphics.m_280163_(STICK_KNOB, xOrigin + baseSizeHalf - knobSizeHalf + (int)(xinput * (float)baseSizeHalf), yOrigin + baseSizeHalf - knobSizeHalf + (int)(yinput * (float)baseSizeHalf), 0.0f, 0.0f, 10, 10, 10, 10);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_controls";
    }
}

