/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.client.overlay.components.VehicleControlOverlay;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;

public class VehicleStatsOverlay
extends VehicleOverlayComponent {
    public static final Color GREEN_ME_SAY_ALONE_RAMP = new Color(0, 255, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final float START = 0.6f;
    public static final float END = 0.1f;
    public static final float CHANGE_G = (float)GREEN_ME_SAY_ALONE_RAMP.getGreen() / 0.5f;
    public static final float CHANGE_R = (float)RED.getRed() / 0.5f;

    public static int getHealthColor(float health, float max) {
        float healthPercent = health / max;
        if (healthPercent >= 0.6f) {
            return GREEN_ME_SAY_ALONE_RAMP.getRGB();
        }
        if (healthPercent < 0.6f && healthPercent > 0.1f) {
            return new Color((int)(CHANGE_R * (0.6f - healthPercent)), (int)(CHANGE_G * (healthPercent - 0.1f)), 0).getRGB();
        }
        return RED.getRGB();
    }

    @Override
    protected boolean shouldRender(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (VehicleStatsOverlay.defaultRenderConditions()) {
            return false;
        }
        if (((Boolean)Config.CLIENT.enableModernHUD.get()).booleanValue()) {
            return false;
        }
        if (!(VehicleStatsOverlay.getPlayerRootVehicle() instanceof EntityVehicle)) {
            return false;
        }
        return !DSCClientInputs.isCameraLockedForward();
    }

    @Override
    protected void render(Gui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)VehicleStatsOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int xOrigin = screenWidth - 60 - 1;
        int yOrigin = screenHeight - 60 - 3 - 40 - 10;
        if (vehicle.isAircraft()) {
            yOrigin -= VehicleControlOverlay.PEDAL_HEIGHT;
        }
        graphics.m_280488_(FONT, "m/s: " + String.format("%3.1f", vehicle.m_20184_().m_82553_() * 20.0), xOrigin, yOrigin, 65280);
        graphics.m_280488_(FONT, "A: " + vehicle.getAltitude(), xOrigin, yOrigin - 10, 65280);
        float health = vehicle.getHealth();
        float maxHealth = vehicle.getMaxHealth();
        graphics.m_280488_(FONT, "H: " + (int)health + "/" + (int)maxHealth, xOrigin, yOrigin - 20, VehicleStatsOverlay.getHealthColor(health, maxHealth));
        float armor = vehicle.getArmor();
        float maxArmor = vehicle.getMaxTotalArmor();
        graphics.m_280488_(FONT, "S: " + (int)armor + "/" + (int)maxArmor, xOrigin, yOrigin - 30, VehicleStatsOverlay.getHealthColor(armor, maxArmor));
        graphics.m_280137_(FONT, "[" + vehicle.m_146903_() + "," + vehicle.m_146904_() + "," + vehicle.m_146907_() + "]", screenWidth / 2, 0, 65280);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_stats";
    }
}

