/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.screen.VehicleSubScreen;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilScreen;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class VehicleRadarScreen
extends VehicleSubScreen {
    public static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/background/vehicle_radar_screen.png");
    public static final ResourceLocation RADAR_BG = new ResourceLocation("dscombat", "textures/ui/radar.png");
    public static final ResourceLocation RADAR_PING = new ResourceLocation("dscombat", "textures/ui/hud_ping.png");
    public static final ResourceLocation RADAR_PING_HOVER = new ResourceLocation("dscombat", "textures/ui/hud_ping_hover.png");
    public static final ResourceLocation RADAR_PING_SELECT = new ResourceLocation("dscombat", "textures/ui/hud_ping_select.png");
    public static final ResourceLocation PING_DATA = new ResourceLocation("dscombat", "textures/ui/ping_data_icons_color.png");
    private static final int imageWidth = 240;
    private static final int imageHeight = 180;
    private static final int textureSize = 256;
    private static final int PING_SIZE = 6;
    private int leftTicks = 0;
    private static final int HALF_PS = 3;
    private static final int SQUARE_PS = 14;
    private static final int LEFT = 9;
    private static final int UP = 13;

    protected VehicleRadarScreen() {
        super("screen.dscombat.vehicle_radar_screen", BG_TEXTURE, 240, 180, 256, 256);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.renderRadar(graphics, mouseX, mouseY, partialTick);
    }

    protected void renderRadar(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADAR_BG);
        graphics.m_280411_(RADAR_BG, this.guiX + 4, this.guiY + 66, 110, 110, 0.0f, 0.0f, 127, 128, 127, 128);
        EntityVehicle vehicle = this.getVehicle();
        RadarSystem radar = vehicle.radarSystem;
        List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
        if (pings.isEmpty()) {
            return;
        }
        int selected = radar.getClientSelectedPingIndex();
        int hover = DSCClientInputs.getRadarHoverIndex();
        int centerX = this.guiX + 4 + 55;
        int centerY = this.guiY + 66 + 55;
        boolean hovering = false;
        for (int i = 0; i < pings.size(); ++i) {
            int y;
            float yaw;
            int x;
            RadarStats.RadarPing ping = pings.get(i);
            Vec3 dp = ping.getPosForClient().m_82546_(vehicle.m_20182_());
            double dist = dp.m_165924_();
            double screen_dist = this.getScreenDistRatio(dist);
            if (screen_dist > 1.0) {
                screen_dist = 1.0;
            }
            if (!this.drawPingAtPos(ping, x = Mth.m_14045_((int)((int)((double)(-Mth.m_14031_((float)(yaw = (UtilAngles.getYaw((Vec3)dp) - vehicle.m_146908_() + 180.0f) * ((float)Math.PI / 180))) * 55.0f) * screen_dist)), (int)-50, (int)50) + centerX, y = Mth.m_14045_((int)((int)((double)(Mth.m_14089_((float)yaw) * 55.0f) * screen_dist)), (int)-50, (int)50) + centerY, i == selected, i == hover, graphics, mouseX, mouseY, partialTick, vehicle)) continue;
            DSCClientInputs.setRadarHoverIndex(i);
            hovering = true;
        }
        if (!hovering) {
            DSCClientInputs.resetRadarHoverIndex();
        }
    }

    protected boolean drawPingAtPos(RadarStats.RadarPing ping, int x, int y, boolean selected, boolean hover, @NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick, EntityVehicle vehicle) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (selected) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADAR_PING_SELECT);
        } else if (hover) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADAR_PING_HOVER);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RADAR_PING);
        }
        graphics.m_280411_(RADAR_PING, x - 3, y - 3, 6, 6, 0.0f, 0.0f, 200, 200, 200, 200);
        Vec2 vec2 = new Vec2((float)x, (float)y);
        Vec2 vec22 = new Vec2((float)mouseX, (float)mouseY);
        if (vec2.m_165914_(vec22) > 14.0f) {
            return false;
        }
        int dist = (int)ping.getPosForClient().m_82554_(vehicle.m_20182_());
        int alt = UtilEntity.getDistFromSeaLevel((double)ping.getPosForClient().f_82480_, (Level)vehicle.getWorld());
        String text = dist + " | " + alt;
        MutableComponent comp = UtilMCText.literal((String)text);
        int width = this.f_96547_.m_92852_((FormattedText)comp);
        graphics.m_280430_(this.f_96547_, (Component)comp, (int)((float)x - (float)width / 2.0f), y - 13, 65280);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)PING_DATA);
        graphics.m_280411_(PING_DATA, x - 9, y - 3, 6, 6, (float)(ping.entityType.getIconIndex() * 16), 0.0f, 16, 16, 240, 16);
        graphics.m_280411_(PING_DATA, x + 3, y - 3, 6, 6, (float)(ping.terrainType.getIconIndex() * 16), 0.0f, 16, 16, 240, 16);
        if (ping.isFriendly) {
            graphics.m_280411_(PING_DATA, x - 6, y + 3, 6, 6, 64.0f, 0.0f, 16, 16, 240, 16);
        }
        if (ping.isShared()) {
            graphics.m_280411_(PING_DATA, x, y + 3, 6, 6, 144.0f, 0.0f, 16, 16, 240, 16);
        }
        return true;
    }

    protected double getScreenDistRatio(double distance) {
        return distance / DSCClientInputs.getRadarDisplayRange();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (DSCClientInputs.isRadarHovering()) {
            RadarSystem radar = this.getVehicle().radarSystem;
            List<RadarStats.RadarPing> pings = radar.getClientRadarPings();
            if (DSCClientInputs.getRadarHoverIndex() < pings.size()) {
                radar.clientSelectTarget(pings.get(DSCClientInputs.getRadarHoverIndex()));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    protected void m_7856_() {
        this.vertical_widget_shift = 10;
        super.m_7856_();
        this.positionWidgetGrid((AbstractWidget)CycleButton.m_168894_(value -> UtilMCText.translatable((String)value.getTranslatable())).m_168961_((Object[])RadarStats.RadarMode.values()).m_168948_((Object)DSCClientInputs.getPreferredRadarMode()).m_168936_(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.radar_mode"), this.onRadarModeCycle()), this.ROWS, this.COLUMNS, 1, 2);
        this.vertical_widget_shift = 34;
        this.COLUMNS = 4;
        EditBox rangeBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
        this.positionWidgetGrid((AbstractWidget)rangeBox, this.ROWS, this.COLUMNS, 3, 2);
        rangeBox.m_94144_("" + DSCClientInputs.getRadarDisplayRange());
        rangeBox.m_94202_(0xFFFFFF);
        rangeBox.m_94151_(this.onRadarDisplayRangeChange());
        this.positionWidgetGrid((AbstractWidget)new Button(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.cycle_radar_display_range"), onPress -> {
            DSCClientInputs.cycleRadarDisplayRange();
            rangeBox.m_94144_("" + DSCClientInputs.getRadarDisplayRange());
        }, Supplier::get), this.ROWS, this.COLUMNS, 0, 2, 3);
        this.positionWidgetGrid((AbstractWidget)new Button(0, 0, 20, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.cycle_radar_target"), onPress -> this.getVehicle().radarSystem.clientSelectNextTarget(), Supplier::get), this.ROWS, this.COLUMNS, 6, 2, 2);
        EditBox pingSizeBox = new EditBox(this.f_96547_, 0, 0, 20, 20, (Component)UtilMCText.empty());
        this.positionWidgetGrid((AbstractWidget)pingSizeBox, this.ROWS, 6, 17, 2);
        pingSizeBox.m_94144_(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        pingSizeBox.m_94202_(0xFFFFFF);
        pingSizeBox.m_94151_(UtilScreen.getIntResponder(value -> Config.CLIENT.radarPingOverlaySize.set((Object)Math.max(Math.min(value, 1000), 10))));
        PageButton increaseSize = new PageButton(0, 0, true, button -> {
            Config.CLIENT.radarPingOverlaySize.set((Object)Math.min((Integer)Config.CLIENT.radarPingOverlaySize.get() + 50, 1000));
            pingSizeBox.m_94144_(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        }, false);
        this.positionWidgetGrid((AbstractWidget)increaseSize, this.ROWS, 6, 16, 2);
        PageButton decreaseSize = new PageButton(0, 0, false, button -> {
            Config.CLIENT.radarPingOverlaySize.set((Object)Math.max((Integer)Config.CLIENT.radarPingOverlaySize.get() - 50, 10));
            pingSizeBox.m_94144_(String.valueOf(Config.CLIENT.radarPingOverlaySize.get()));
        }, false);
        this.positionWidgetGrid((AbstractWidget)decreaseSize, this.ROWS, 6, 15, 2);
    }

    @Override
    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        graphics.m_280430_(this.f_96547_, (Component)UtilMCText.translatable((String)"ui.dscombat.change_ping_size"), this.guiX + this.left_padding + 126, this.guiY + this.top_padding + 82, 0x555555);
    }

    private CycleButton.OnValueChange<RadarStats.RadarMode> onRadarModeCycle() {
        return (button, value) -> DSCClientInputs.setPreferredRadarMode(value);
    }

    private Consumer<String> onRadarDisplayRangeChange() {
        return range -> {
            try {
                double number = Double.parseDouble(range);
                DSCClientInputs.setRadarDisplayRange(number);
            }
            catch (NumberFormatException e) {
                DSCClientInputs.setRadarDisplayRange(250.0);
            }
        };
    }
}

