/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.onewhohears.dscombat.common.container.menu.WeaponPartsBlockContainerMenu;
import com.onewhohears.dscombat.common.network.toserver.ToServerCraftWeaponPart;
import com.onewhohears.dscombat.crafting.WeaponPartRecipe;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.UtilMCText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

public class WeaponPartsBlockScreen
extends AbstractContainerScreen<WeaponPartsBlockContainerMenu> {
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("dscombat", "textures/ui/aircraft_screen.png");
    private static final int buttonNum = 7;
    private List<Integer> fails = new ArrayList<Integer>();
    private final int maxTab;
    private int tabIndex = 0;
    private int weaponIndex = 0;

    public WeaponPartsBlockScreen(WeaponPartsBlockContainerMenu menu, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)menu, playerInv, title);
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 256;
        this.f_97727_ = 256;
        this.maxTab = (int)((float)PartPresets.get().getWeaponPartRecipes(Minecraft.m_91087_().f_91073_.m_7465_()).length / 7.0f);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int index;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        Minecraft m = Minecraft.m_91087_();
        RenderSystem.enableBlend();
        if (PartPresets.get().getWeaponPartRecipeNum() == 0) {
            return;
        }
        int startX = this.f_97735_ + this.f_97728_;
        int startY = this.f_97736_ + this.f_97729_;
        int wx = startX + 51;
        int wy = startY + 12;
        for (int i = 0; i < 7 && (index = this.tabIndex * 7 + i) < PartPresets.get().getWeaponPartRecipeNum(); ++i) {
            ItemStack stack = PartPresets.get().getWeaponPartRecipes(m.f_91073_.m_7465_())[index].m_8043_(m.f_91073_.m_9598_());
            m.m_91291_().m_269128_(stack, ItemDisplayContext.GUI, wx, wy, graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_(), (Level)m.f_91073_, 0);
            graphics.m_280480_(stack, wx, wy);
            graphics.m_280370_(this.f_96547_, stack, wx, wy);
            wx += 20;
        }
        WeaponPartRecipe recipe = PartPresets.get().getWeaponPartRecipes(m.f_91073_.m_7465_())[this.weaponIndex];
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        for (int i = 0; i < ((WeaponPartsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6643_(); ++i) {
            if (i < ingredients.size()) {
                ItemStack[] items = ((Ingredient)ingredients.get(i)).m_43908_();
                ItemStack stack = items.length == 0 ? Items.f_42127_.m_7968_() : items[m.f_91074_.f_19797_ / 20 % items.length];
                ((WeaponPartsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, stack);
                if (!this.fails.contains(i)) continue;
                Slot slot = ((WeaponPartsBlockContainerMenu)this.m_6262_()).m_38853_(i);
                int left = this.f_97735_ + slot.f_40220_;
                int top = this.f_97736_ + slot.f_40221_;
                graphics.m_280509_(left, top, left + 17, top + 17, 0x77FF0000);
                continue;
            }
            ((WeaponPartsBlockContainerMenu)this.m_6262_()).recipeSlots.m_6836_(i, ItemStack.f_41583_);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float pTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        graphics.m_280218_(BG_TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280430_(this.f_96547_, this.f_96539_, this.f_97728_ + 38, this.f_97729_, 0x404040);
        graphics.m_280430_(this.f_96547_, this.f_169604_, this.f_97730_ + 38, this.f_97731_ + 56, 0x404040);
        graphics.m_280430_(this.f_96547_, (Component)UtilMCText.translatable((String)"ui.dscombat.ingredients"), this.f_97728_ + 123, this.f_97729_ + 32, 43520);
        if (PartPresets.get().getWeaponPartRecipeNum() == 0) {
            return;
        }
        WeaponPartRecipe wr = PartPresets.get().getWeaponPartRecipes(Minecraft.m_91087_().f_91073_.m_7465_())[this.weaponIndex];
        PartStats data = wr.getPartData();
        if (data == null) {
            return;
        }
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)data.getDisplayNameComponent());
        data.addToolTips(list, (TooltipFlag)TooltipFlag.Default.f_256730_);
        graphics.m_280430_(this.f_96547_, (Component)list.get(0), this.f_97728_ + 38, this.f_97729_ + 34, 263172);
        float scale = 0.5f;
        graphics.m_280168_().m_85841_(scale, scale, scale);
        float invScale = 1.0f / scale;
        int startX = (int)((float)(this.f_97728_ + 38) * invScale);
        int startY = (int)((float)(this.f_97729_ + 43) * invScale);
        for (int i = 1; i < list.size(); ++i) {
            graphics.m_280430_(this.f_96547_, (Component)list.get(i), startX, startY, ((Component)list.get(i)).m_7383_().m_131135_().m_131265_());
            Objects.requireNonNull(this.f_96547_);
            startY += 9;
        }
        graphics.m_280168_().m_85841_(1.0f / scale, 1.0f / scale, 1.0f / scale);
    }

    protected void m_7856_() {
        super.m_7856_();
        int startX = this.f_97735_ + this.f_97728_;
        int startY = this.f_97736_ + this.f_97729_;
        int wx = startX + 39;
        int wy = startY + 10;
        Button prevButton = new Button(0, 0, 10, 20, (Component)UtilMCText.literal((String)"<"), onPress -> this.prevButton(), Supplier::get);
        prevButton.m_252865_(wx);
        prevButton.m_253211_(wy);
        this.m_142416_((GuiEventListener)prevButton);
        wx += 10;
        int b = 0;
        while (b < 7) {
            int c = b++;
            Button acb = new Button(0, 0, 20, 20, (Component)UtilMCText.empty(), onPress -> this.weaponButton(c), Supplier::get);
            acb.m_252865_(wx);
            acb.m_253211_(wy);
            this.m_142416_((GuiEventListener)acb);
            wx += 20;
        }
        Button nextButton = new Button(0, 0, 10, 20, (Component)UtilMCText.literal((String)">"), onPress -> this.nextButton(), Supplier::get);
        nextButton.m_252865_(wx);
        nextButton.m_253211_(wy);
        this.m_142416_((GuiEventListener)nextButton);
        Button craftButton = new Button(0, 0, 80, 20, (Component)UtilMCText.translatable((String)"ui.dscombat.craft_button"), onPress -> this.craftButton(), Supplier::get);
        craftButton.m_252865_(startX + 122);
        craftButton.m_253211_(startY + 110);
        this.m_142416_((GuiEventListener)craftButton);
    }

    public void m_181908_() {
        super.m_181908_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void prevButton() {
        --this.tabIndex;
        if (this.tabIndex < 0) {
            this.tabIndex = this.maxTab;
        }
    }

    private void nextButton() {
        ++this.tabIndex;
        if (this.tabIndex > this.maxTab) {
            this.tabIndex = 0;
        }
    }

    private void weaponButton(int num) {
        this.resetFails();
        int max = PartPresets.get().getWeaponPartRecipeNum();
        int a = this.tabIndex * 7 + num;
        this.weaponIndex = a >= max ? max - 1 : a;
    }

    private void craftButton() {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer player = m.f_91074_;
        if (player == null) {
            return;
        }
        WeaponPartRecipe recipe = PartPresets.get().getWeaponPartRecipes(m.f_91073_.m_7465_())[this.weaponIndex];
        if (recipe.matches(player.m_150109_(), (Level)m.f_91073_)) {
            new ToServerCraftWeaponPart(recipe.m_6423_(), ((WeaponPartsBlockContainerMenu)this.f_97732_).getPos()).sendToServer();
        } else {
            player.m_5661_((Component)UtilMCText.translatable((String)"error.dscombat.cant_craft"), true);
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12507_, (float)1.0f));
            this.setFails(UtilItem.testRecipeFails(recipe.m_7527_(), (Container)player.m_150109_()));
        }
    }

    public void setFails(List<Integer> fails) {
        if (fails == null) {
            return;
        }
        this.fails = fails;
    }

    public void resetFails() {
        this.fails.clear();
    }
}

