/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.onewhohears.dscombat.command.argument.WeaponArgument;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MissileCommand {
    public MissileCommand(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"missile").requires(stack -> stack.m_6761_(2))).then(Commands.m_82127_((String)"no_owner").then(this.testMissileParams(ctx -> null)))).then(Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91449_()).then(this.testMissileParams(ctx -> EntityArgument.m_91452_((CommandContext)ctx, (String)"owner")))));
    }

    private ArgumentBuilder<CommandSourceStack, ?> testMissileParams(GetOwnerCommand owner) {
        return Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), null, owner.apply((CommandContext<CommandSourceStack>)context), -1.0, -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"weapon", (ArgumentType)WeaponArgument.weapon()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), owner.apply((CommandContext<CommandSourceStack>)context), -1.0, -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speed", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), owner.apply((CommandContext<CommandSourceStack>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), -1000.0f, -1000.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pitch", (ArgumentType)AngleArgument.m_83807_()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), owner.apply((CommandContext<CommandSourceStack>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), AngleArgument.m_83810_((CommandContext)context, (String)"pitch"), -1000.0f))).then(Commands.m_82129_((String)"yaw", (ArgumentType)AngleArgument.m_83807_()).executes(context -> this.testMissile((CommandContext<CommandSourceStack>)context, EntityArgument.m_91461_((CommandContext)context, (String)"target"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos"), WeaponArgument.getWeapon((CommandContext<CommandSourceStack>)context, "weapon"), owner.apply((CommandContext<CommandSourceStack>)context), DoubleArgumentType.getDouble((CommandContext)context, (String)"speed"), AngleArgument.m_83810_((CommandContext)context, (String)"pitch"), AngleArgument.m_83810_((CommandContext)context, (String)"yaw"))))))));
    }

    private int testMissile(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, Vec3 pos, WeaponStats weaponStats, Entity owner, double initSpeed, float pitch, float yaw) throws CommandSyntaxException {
        String defaultId = "aim120b";
        if (weaponStats == null) {
            weaponStats = WeaponPresets.get().get(defaultId);
        }
        if (weaponStats == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.default_weapon_not_exist", (Object[])new Object[]{defaultId}));
            return 0;
        }
        WeaponInstance<?> weapon = weaponStats.createWeaponInstance();
        int i = 0;
        for (Entity entity : targets) {
            Level level;
            EntityWeapon<?> ew;
            Vec3 dp = entity.m_20182_().m_82546_(pos).m_82541_();
            if (pitch != -1000.0f) {
                if (yaw == -1000.0f) {
                    yaw = UtilAngles.getYaw((Vec3)dp);
                }
                dp = Vec3.m_82498_((float)pitch, (float)yaw);
            }
            if ((ew = weapon.getEntity(level = UtilEntity.getLevel((Entity)entity))) == null) continue;
            ew.m_5602_(owner);
            ew.m_146884_(pos);
            weapon.setDirection(ew, dp);
            if (initSpeed != -1.0) {
                ew.m_20256_(dp.m_82490_(initSpeed));
            }
            if (ew instanceof EntityMissile) {
                Entity v;
                EntityMissile missile = (EntityMissile)ew;
                missile.target = v = entity.m_20201_();
                missile.targetPos = v.m_20182_();
            }
            level.m_7967_(ew);
            ++i;
        }
        if (i == 0) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.translatable((String)"error.dscombat.no_targets_found"));
        } else if (i > 0) {
            int num = i;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> UtilMCText.translatable((String)"success.dscombat.launched_missile", (Object[])new Object[]{num}), true);
        }
        return 1;
    }

    static interface GetOwnerCommand {
        public Entity apply(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

