/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.onewhohears.dscombat.command.argument.VehiclePresetArgument;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WindTunnelCommand {
    public WindTunnelCommand(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"windtunnel").requires(stack -> stack.m_6761_(2))).then(Commands.m_82127_((String)"set_all").then(Commands.m_82129_((String)"preset", (ArgumentType)VehiclePresetArgument.vehiclePreset()).then(Commands.m_82129_((String)"speed", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"rotation", (ArgumentType)Vec3Argument.m_120841_()).then(Commands.m_82129_((String)"throttle", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.m_82129_((String)"afterburner", (ArgumentType)BoolArgumentType.bool()).executes((context, tunnel) -> this.setWindTunnelCommand((CommandContext<CommandSourceStack>)context, tunnel, VehiclePresetArgument.getVehiclePreset((CommandContext<CommandSourceStack>)context, "preset"), Vec3Argument.m_120844_((CommandContext)context, (String)"speed"), Vec3Argument.m_120844_((CommandContext)context, (String)"rotation"), FloatArgumentType.getFloat((CommandContext)context, (String)"throttle"), BoolArgumentType.getBool((CommandContext)context, (String)"afterburner")))))))))).then(Commands.m_82127_((String)"set_hidden").then(Commands.m_82129_((String)"hidden", (ArgumentType)BoolArgumentType.bool()).executes((context, tunnel) -> this.setVehicleHidden((CommandContext<CommandSourceStack>)context, tunnel, BoolArgumentType.getBool((CommandContext)context, (String)"hidden")))))).then(Commands.m_82127_((String)"set_altitude").then(Commands.m_82129_((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-1000.0f, (float)10000.0f)).executes((context, tunnel) -> this.setVehicleAltitude((CommandContext<CommandSourceStack>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"altitude")))))).then(Commands.m_82127_((String)"set_inputs").then(Commands.m_82129_((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).then(Commands.m_82129_((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).then(Commands.m_82129_((String)"roll", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)1.0f)).executes((context, tunnel) -> this.setVehicleInputs((CommandContext<CommandSourceStack>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"pitch"), FloatArgumentType.getFloat((CommandContext)context, (String)"yaw"), FloatArgumentType.getFloat((CommandContext)context, (String)"roll")))))))).then(Commands.m_82127_((String)"find_lift_drag").then(Commands.m_82129_((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).then(Commands.m_82129_((String)"turn_rate", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1000.0f)).then(Commands.m_82129_((String)"aoa", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)90.0f)).then(Commands.m_82129_((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-64.0f, (float)10000.0f)).executes((context, tunnel) -> this.findLiftDrag((CommandContext<CommandSourceStack>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"speed"), FloatArgumentType.getFloat((CommandContext)context, (String)"turn_rate"), FloatArgumentType.getFloat((CommandContext)context, (String)"aoa"), FloatArgumentType.getFloat((CommandContext)context, (String)"altitude"))))))))).then(Commands.m_82127_((String)"set_preset").then(Commands.m_82129_((String)"preset", (ArgumentType)VehiclePresetArgument.vehiclePreset()).executes((context, tunnel) -> this.setPresetCommand((CommandContext<CommandSourceStack>)context, tunnel, VehiclePresetArgument.getVehiclePreset((CommandContext<CommandSourceStack>)context, "preset")))))).then(Commands.m_82127_((String)"set_speed_list").then(Commands.m_82129_((String)"speed_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setSpeedList((CommandContext<CommandSourceStack>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"speed_list")))))).then(Commands.m_82127_((String)"set_aoa_list").then(Commands.m_82129_((String)"aoa_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setAOAList((CommandContext<CommandSourceStack>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"aoa_list")))))).then(Commands.m_82127_((String)"set_turn_rate_list").then(Commands.m_82129_((String)"turn_rate_list", (ArgumentType)StringArgumentType.string()).executes((context, tunnel) -> this.setTurnRateList((CommandContext<CommandSourceStack>)context, tunnel, StringArgumentType.getString((CommandContext)context, (String)"turn_rate_list")))))).then(Commands.m_82127_((String)"find_multi_lift_drag").then(Commands.m_82129_((String)"altitude", (ArgumentType)FloatArgumentType.floatArg((float)-64.0f, (float)10000.0f)).executes((context, tunnel) -> this.findMultiLiftDrag((CommandContext<CommandSourceStack>)context, tunnel, FloatArgumentType.getFloat((CommandContext)context, (String)"altitude"))))));
    }

    private int findMultiLiftDrag(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, float altitude) {
        tunnel.startFindMultiLiftDragJob(altitude);
        return 1;
    }

    private int setSpeedList(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, String list) {
        tunnel.setSpeedList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    private int setAOAList(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, String list) {
        tunnel.setAOAList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    private int setTurnRateList(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, String list) {
        tunnel.setTurnRateList(WindTunnelCommand.parseNumList(list));
        return 1;
    }

    public static double[] parseNumList(String string_list) {
        String[] split = string_list.split(";");
        double[] num_list = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            try {
                num_list[i] = Double.parseDouble(split[i]);
                continue;
            }
            catch (NumberFormatException e) {
                num_list[i] = 0.0;
            }
        }
        return num_list;
    }

    private int findLiftDrag(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, float speed, float turn_rate, float aoa, float altitude) {
        tunnel.startFindLiftDragJob(speed, turn_rate, aoa, altitude);
        return 1;
    }

    private int setWindTunnelCommand(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, @Nullable VehicleStats preset, @Nullable Vec3 speed, @Nullable Vec3 rotation, float throttle, boolean afterburner) {
        if (preset != null) {
            tunnel.setPreset(preset.getId());
        }
        if (speed != null) {
            tunnel.setSpeed(speed);
        }
        if (rotation != null) {
            tunnel.setQ(UtilAngles.toQuaternionF((double)rotation.f_82480_, (double)rotation.f_82479_, (double)rotation.f_82481_));
        }
        if (throttle >= 0.0f) {
            tunnel.setThrottle(throttle);
        }
        tunnel.setAfterBurner(afterburner);
        return 1;
    }

    private int setPresetCommand(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, @Nullable VehicleStats preset) {
        if (preset != null) {
            tunnel.setPreset(preset.getId());
        }
        return 1;
    }

    private int setVehicleHidden(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, boolean hidden) {
        tunnel.setHideModel(hidden);
        return 1;
    }

    private int setVehicleAltitude(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, float altitude) {
        tunnel.setAltitude(altitude);
        return 1;
    }

    private int setVehicleInputs(CommandContext<CommandSourceStack> context, EntityWindTunnel tunnel, float pitch, float yaw, float roll) {
        tunnel.setInputs(new Vec3((double)pitch, (double)yaw, (double)roll));
        return 1;
    }

    private static Optional<EntityWindTunnel> getWindTunnel(CommandContext<CommandSourceStack> context) {
        return UtilVehicleEntity.findWindTunnel(((CommandSourceStack)context.getSource()).m_81371_(), (Level)((CommandSourceStack)context.getSource()).m_81372_());
    }

    public static interface IWindTunnelCommand
    extends Command<CommandSourceStack> {
        default public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Optional<EntityWindTunnel> opt = WindTunnelCommand.getWindTunnel(context);
            if (opt.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)UtilMCText.literal((String)"No Wind Tunnels within 16 blocks found!"));
                return 0;
            }
            return this.run(context, opt.get());
        }

        public int run(CommandContext<CommandSourceStack> var1, EntityWindTunnel var2) throws CommandSyntaxException;
    }
}

