/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.data.radar.RadarStats;
import com.onewhohears.dscombat.util.UtilClientPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;

public class ToClientRadarPings
extends BaseS2CMessage {
    public final int id;
    public final List<RadarStats.RadarPing> pings;

    public ToClientRadarPings(int id, List<RadarStats.RadarPing> pings) {
        this.id = id;
        this.pings = pings;
    }

    public ToClientRadarPings(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.pings = new ArrayList<RadarStats.RadarPing>();
        int num = buffer.readInt();
        for (int i = 0; i < num; ++i) {
            this.pings.add(new RadarStats.RadarPing(buffer));
        }
    }

    public MessageType getType() {
        return PacketHandler.S2C_RADAR_PINGS;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeInt(this.pings.size());
        for (int i = 0; i < this.pings.size(); ++i) {
            this.pings.get(i).write(buffer);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> UtilClientPacket.pingsPacket(this.id, this.pings));
    }
}

