/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.mojang.datafixers.util.Pair;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.crafting.WeaponRecipe;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilItem;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ToServerCraftWeapon
extends BaseC2SMessage {
    public final String recipeId;
    public final BlockPos pos;

    public ToServerCraftWeapon(ResourceLocation recipeId, BlockPos pos) {
        this.recipeId = recipeId.toString();
        this.pos = pos;
    }

    public ToServerCraftWeapon(FriendlyByteBuf buffer) {
        this.recipeId = buffer.m_130277_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.pos = UtilGeometry.toBlockPos((Vec3)new Vec3(x, y, z));
    }

    public MessageType getType() {
        return PacketHandler.C2S_CRAFT_WEAPON;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.recipeId);
        buffer.writeDouble((double)this.pos.m_123341_());
        buffer.writeDouble((double)this.pos.m_123342_());
        buffer.writeDouble((double)this.pos.m_123343_());
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            Level level = UtilEntity.getLevel((Entity)player);
            Optional option = level.m_7465_().m_220248_((RecipeType)WeaponRecipe.Type.INSTANCE, (Container)player.m_150109_(), level, new ResourceLocation(this.recipeId));
            if (option.isEmpty()) {
                return;
            }
            WeaponRecipe recipe = (WeaponRecipe)((Pair)option.get()).getSecond();
            UtilItem.handleInventoryRecipe((Player)player, (Recipe)recipe, (BlockPos)this.pos);
        });
    }
}

