/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilEntity;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ToServerVehicleCollide
extends BaseC2SMessage {
    public final int id;
    public final float amount;
    public final boolean isFall;

    public ToServerVehicleCollide(int id, float amount, boolean isFall) {
        this.id = id;
        this.amount = amount;
        this.isFall = isFall;
    }

    public ToServerVehicleCollide(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.amount = buffer.readFloat();
        this.isFall = buffer.readBoolean();
    }

    public MessageType getType() {
        return PacketHandler.C2S_VEHICLE_COLLIDE;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeFloat(this.amount);
        buffer.writeBoolean(this.isFall);
    }

    public void handle(NetworkManager.PacketContext context) {
        context.queue(() -> {
            Player player = context.getPlayer();
            Level level = UtilEntity.getLevel((Entity)player);
            Entity patt0$temp = level.m_6815_(this.id);
            if (patt0$temp instanceof EntityVehicle) {
                EntityVehicle plane = (EntityVehicle)patt0$temp;
                plane.collideHurt(this.amount, this.isFall);
            }
        });
    }
}

