/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.onewhohears.onewholibs.util.UtilItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BucketConvertRecipe
extends CustomRecipe {
    private final NonNullList<Ingredient> allIngredients = NonNullList.m_122779_();
    private final Ingredient converter;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;

    public BucketConvertRecipe(ResourceLocation pId, Ingredient converter, NonNullList<Ingredient> ingredients, ItemStack output) {
        super(pId, CraftingBookCategory.MISC);
        this.allIngredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42446_}));
        this.allIngredients.add((Object)converter);
        this.allIngredients.addAll(ingredients);
        this.converter = converter;
        this.ingredients = ingredients;
        this.output = output;
    }

    public boolean matches(CraftingContainer container, Level level) {
        return UtilItem.testRecipe(this.m_7527_(), (Container)container);
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.allIngredients;
    }

    public NonNullList<Ingredient> getFluidIngredients() {
        return this.ingredients;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (this.converter.test(item)) {
                ItemStack item2 = item.m_41777_();
                item2.m_41721_(item.m_41773_() + 1);
                nonnulllist.set(i, (Object)item2);
                continue;
            }
            if (!UtilItem.hasCraftingRemainingItem((ItemStack)item)) continue;
            nonnulllist.set(i, (Object)UtilItem.getCraftingRemainingItem((ItemStack)item));
        }
        return nonnulllist;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer container, RegistryAccess registry) {
        return this.getOutput();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean m_5598_() {
        return false;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registry) {
        return this.getOutput();
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public Ingredient getConverter() {
        return this.converter;
    }

    public static class Serializer
    implements RecipeSerializer<BucketConvertRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("dscombat", "bucket_convert");

        @NotNull
        public BucketConvertRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            JsonObject converter = serializedRecipe.get("converter").getAsJsonObject();
            JsonArray ingredientsJson = serializedRecipe.get("ingredients").getAsJsonArray();
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientsJson.size(); ++i) {
                ingredients.add((Object)Ingredient.m_43917_((JsonElement)ingredientsJson.get(i).getAsJsonObject()));
            }
            String output = serializedRecipe.get("output").getAsString();
            return new BucketConvertRecipe(recipeId, Ingredient.m_43917_((JsonElement)converter), (NonNullList<Ingredient>)ingredients, UtilItem.getItem((String)output).m_7968_());
        }

        @NotNull
        public BucketConvertRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient converter = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            NonNullList ingredients = (NonNullList)buffer.m_236838_(size -> NonNullList.m_122779_(), Ingredient::m_43940_);
            ItemStack output = buffer.m_130267_();
            return new BucketConvertRecipe(recipeId, converter, (NonNullList<Ingredient>)ingredients, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, BucketConvertRecipe recipe) {
            recipe.getConverter().m_43923_(buffer);
            buffer.m_236828_(recipe.getFluidIngredients(), (buff, ing) -> ing.m_43923_(buff));
            buffer.m_130055_(recipe.getOutput());
        }
    }
}

