/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.forge;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.dscombat.crafting.WeaponPartRecipe;
import com.onewhohears.dscombat.crafting.WeaponRecipe;
import com.onewhohears.dscombat.data.parts.PartPresetGenerator;
import com.onewhohears.dscombat.data.vehicle.VehiclePresetGenerator;
import com.onewhohears.dscombat.data.weapon.WeaponPresetGenerator;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class DSCRecipeGenerator
extends RecipeProvider {
    public DSCRecipeGenerator(PackOutput output) {
        super(output);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.genAircraftRecipes(finishedRecipeConsumer);
        this.genWeaponRecipes(finishedRecipeConsumer);
        this.genWeaponPartRecipes(finishedRecipeConsumer);
    }

    protected void genAircraftRecipes(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        VehiclePresetGenerator.INSTANCE.GEN_MAP.forEach((key, preset) -> {
            if (!preset.isCraftable()) {
                return;
            }
            finishedRecipeConsumer.accept(new FinishedPresetRecipe((JsonPresetStats)preset, "workbench_vehicle_", VehicleRecipe.Serializer.INSTANCE));
        });
    }

    protected void genWeaponRecipes(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        WeaponPresetGenerator.INSTANCE.GEN_MAP.forEach((key, preset) -> finishedRecipeConsumer.accept(new FinishedPresetRecipe((JsonPresetStats)preset, "workbench_weapon_", WeaponRecipe.Serializer.INSTANCE)));
    }

    protected void genWeaponPartRecipes(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        PartPresetGenerator.INSTANCE.GEN_MAP.forEach((key, preset) -> {
            if (!preset.isCraftableWeaponPart()) {
                return;
            }
            finishedRecipeConsumer.accept(new FinishedPresetRecipe((JsonPresetStats)preset, "workbench_weapon_part_", WeaponPartRecipe.Serializer.INSTANCE));
        });
    }

    public static class FinishedPresetRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String presetId;
        private final RecipeSerializer<?> type;

        public FinishedPresetRecipe(JsonPresetStats preset, String prefix, RecipeSerializer<?> type) {
            this.id = ResourceLocation.m_214293_((String)preset.getNameSpace(), (String)(prefix + preset.getId()));
            this.presetId = preset.getId();
            this.type = type;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("presetId", this.presetId);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return this.type;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

